#include "pt.h"

int pascal
/* XTAG:cursor */
cursor(fn, moveSelection)
	register int fn, moveSelection;
{
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;

	int doFast, fid;

doFast = 0;

switch( fn ) {

/* These can be done by only redrawing one or two lines */

case FCURDOWN:
	fid = selWindow->fileId;
	/* a special case when the last line does not have a CRNL */
	if( readChar(fid, fileSize(fid)-1) != '\n' )
		goto wordMoves;

case FCURLEFT:
case FCURRIGHT:
case FCURUP:
	doFast = 1;

case FWORDLEFT:
case FWORDRIGHT:
case FBEGINLINE:
case FENDLINE:
wordMoves:
	fn = doCursor(fn, doFast, moveSelection);
	if( fn == -1 )
		goto notDefined;
	break;

case FLEFTMBUTTON:
case FRIGHTMBUTTON:
	doMouseButtons(fn);
	break;

notDefined:
	msg("Key not defined", 1);
default:
	return 0;
}

return 1;
}

int pascal
/* XTAG:doMouseButtons */
doMouseButtons(fn)
	int fn;
{
	extern int evhead, evtail;
	extern struct event events[];
	extern int mouseHorizontal, mouseVertical;
	extern unsigned char msgBuffer[];

	register int i;
	int j, mbStatus;

	switch( fn ) {
		case FLEFTMBUTTON:
			mbStatus = 0x1;
			j = 0x2; /* left button pressed */
			break;
		case FRIGHTMBUTTON:
			mbStatus = 0x2;
			j = 0x8; /* right button pressed */
			break;
	}
	/* record the button press event */
	if( ++evtail >= NEVENTS )
		evtail = 0;
	i = evtail;
	events[i].mask = j;
	events[i].buttons = mbStatus;
	events[i].vertical = mouseVertical;
	events[i].horizontal = mouseHorizontal;
	/* record the button release event */
	if( ++evtail >= NEVENTS )
		evtail = 0;
	i = evtail;
	/* event type is release button */
	events[i].mask = j << 1;
	events[i].buttons = 0;
	events[i].vertical = mouseVertical;
	events[i].horizontal = mouseHorizontal;
	return 0;
}

int pascal
/* XTAG:doCursor */
doCursor(fn, doFast, moveSelection)
	int fn, doFast, moveSelection;
{
	extern struct window *windowList;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int mousePresent;
	extern int mouseHorizontal, mouseVertical;
	extern union REGS rin, rout;
	extern int scrRows, scrCols;
	extern int evhead, evtail;
	extern unsigned char msgBuffer[];
	extern int debug;
	extern int cursorMouse;
	extern int lastColumn;
	extern int lastFn;
	extern int selMode;

	long cp;
	register int i, j;
	unsigned char ch;
	int row, col, where;
	int fid, alphaNumeric;
	struct window *w;

	msg("", 1);
	if( mousePresent ) {
		if( cursorMouse || selWindow == NULL ) {
			rin.x.ax = 3;	/* get the mouse cursor position */
			int86(51, &rin, &rout);
			col = rout.x.cx>>3;
			row = rout.x.dx>>3;
		} else {
			/* find the position of the current selection */
			posToxy(selWindow, selBegin, &row, &col);
			/* special case so that cursor up and down move */
			/* down the page in a straight line so far as is */
			/* possible */
			if( (lastColumn != -1) && (col != lastColumn)
			 && (lastFn==FCURUP || lastFn==FCURDOWN)
			)
				col = lastColumn;
		}
	} else {	/* find the current mouse cursor position */
		getCPos(&row, &col);
	}
	/* convert to screen pixels */
	i = col << 3;
	j = row << 3;

	/* adjust it according to the function invoked */
	switch( fn ) {

	case FWORDLEFT:
	doWordLeft:
		xyToPos(&row, &col, &where, &cp, &w);
		if( where != INSIDEWINDOW )
			break;

		fid = w->fileId;

		/* skip the white space between words */
		while( cp >= 0 ) {
			ch = readChar(fid, --cp);
			if( !isspace(ch))
				break;
		}

		alphaNumeric = isalnum(ch);
		/* skip the characters in the word */
		while( 1 ) {
			ch = readChar(fid, --cp);
				/****** OLD VERSION.  vi "big" words *******/
				/*if(ch==' '||ch=='\t'||ch=='\n'||ch=='\0')*/
				/*******************************************/
			/* if we have switched from alphanumeric to not */
			/* alphanumeric or the reverse, then quit */
			if( alphaNumeric ) {
				if( !isalnum(ch) && ch != '_' ) {
					++cp;
					break;
				}
			} else if( isalnum(ch) || isspace(ch) || ch=='_' ) {
				++cp;
				break;
			}
		}

	finishUp:
		posToxy(w, cp, &row, &col);
		if( moveSelection ) {
			selBegin = selEnd = cp;
			if( indentToShowSelection(-1) ) {
				redrawBox(selWindow->row1, selWindow->col1,
					selWindow->row2, selWindow->col2);
				updateScreen(selWindow->row1,
					selWindow->row2);
				posToxy(w, cp, &row, &col);
			}
		}
		i = col << 3;
		j = row << 3;
		break;

	case FWORDRIGHT:
	doWordRight:

		xyToPos(&row, &col, &where, &cp, &w);
		if( where != INSIDEWINDOW )
			break;

		fid = w->fileId;

		ch = readChar(fid, cp);
		alphaNumeric = isalnum(ch);

		/* skip the characters in the word */
		while( 1 ) {
			ch = readChar(fid, ++cp);
				/****** OLD VERSION.  vi "big" words *******/
				/***if( ch==' ' || ch=='\n' || ch=='\0' )***/
				/*******************************************/
			/* if we have switched from alphanumeric to not */
			/* alphanumeric or the reverse, then quit */
			if( alphaNumeric ) {
				if( !isalnum(ch) && ch != '_' )
					break;
			} else if( isalnum(ch) || isspace(ch) || ch=='_' )
				break;
		}

		/* skip the white space between words */
		while( isspace(ch) )
			ch = readChar(fid, ++cp);

		goto finishUp;

	case FENDLINE:
		xyToPos(&row, &col, &where, &cp, &w);
		if( where != INSIDEWINDOW )
			break;
		fid = w->fileId;
		while( 1 ) {
			ch = readChar(fid, cp++);
			if( ch == '\n' || ch == '\0' )
				break;
		}
		--cp;		/* we went one past the NL */
		goto finishUp;

	case FBEGINLINE:
		xyToPos(&row, &col, &where, &cp, &w);
		if( where != INSIDEWINDOW )
			break;
		fid = w->fileId;
		if( readChar(fid, cp) == '\n' )
			--cp;
		while( cp >= -2 ) {
			ch = readChar(fid, cp--);
			if( ch == '\n' )
				break;
		}
		++cp;	/* cp now points to the '\n' */
		/* skip tabs and blanks */
		while( 1 ) {
			ch = readChar(fid, ++cp);
			if( ch != ' ' && ch != '\t' )
				break;
		}
		goto finishUp;

	case FCURRIGHT:
		switch( selMode ) {
			default:
			case SELCHAR:
				break;
			case SELWORD:
				goto doWordRight;
			case SELLINE:
				goto doCurDown;
		}
		if( i < (8*(scrCols-1)) )
			i += 8;
		break;

	case FCURLEFT:
		switch( selMode ) {
			default:
			case SELCHAR:
				break;
			case SELWORD:
				goto doWordLeft;
			case SELLINE:
				goto doCurUp;
		}
		if( i > 0 )
			i -= 8;
		break;

	case FCURUP:
	doCurUp:
		if( j > 0 )
			j -= 8;
		break;

	case FCURDOWN:
	doCurDown:
		if( j < (8*(scrRows-1)) )
			j += 8;
		break;

	default:
		return -1;
	}

	mouseHorizontal = i;
	mouseVertical = j;

	doScreenUpdate(fn, i, j, doFast, moveSelection);
	return 0;
}


void pascal
/* XTAG:doScreenUpdate */
doScreenUpdate(fn, i, j, doFast, moveSelection)
	int fn, i, j, doFast, moveSelection;
{
	extern struct window *selWindow;
	extern struct window *windowList;
	extern long selBegin, selEnd;
	extern int selMode;
	extern union REGS rin, rout;
	extern int mouseHorizontal, mouseVertical;
	extern int scrRows, scrCols;
	extern int evhead, evtail;
	extern struct event events[];
	extern unsigned char msgBuffer[];
	extern int debug;
	extern int cursorMouse;
	extern int lastColumn;

	long cp, oldSelBegin;
	unsigned char ch;
	int n, row, col, row2, where;
	register struct window *w;
	struct window *w2;

	row = j >> 3;
	col = i >> 3;
	lastColumn = col;
	rin.x.ax = 2;	/* hide cursor */
	int86(51, &rin, &rout);
	rin.x.ax = 4;	/* move cursor */
	rin.x.cx = i;
	rin.x.dx = j;
	int86(51, &rin, &rout);
	rin.x.ax = 1;	/* show cursor */
	int86(51, &rin, &rout);
	if( moveSelection && !cursorMouse ) {

		xyToPos(&row, &col, &where, &cp, &w2);
		w = w2;

		/* This is to prevent the right cursor movement from */
		/* getting stuck on a tab.  It should happen only when */
		/* the selection is on a tab. */
		if( selBegin == cp && selEnd == cp && fn == FCURRIGHT )
			++cp;

		/* see if we scrolled off an edge of the window */
		if( where != INSIDEWINDOW && selWindow != NULL) {
			w = selWindow;
			if( row > (w->row2-1) ) {
				n = (w->row2-w->row1+1)/3;
				w->posTopline = nextLine(w->fileId,
							w->posTopline, &n);
				w->numTopline += n;
				row -= n;
			} else if( row < (w->row1+1) ) {
				n = (w->row2-w->row1+1)/3;
				w->posTopline = prevLine(w->fileId,
							w->posTopline, &n);
				w->numTopline -= n;
				row += n;
			}
			redrawBox(w->row1, w->col1, w->row2, w->col2);
			updateScreen(w->row1, w->row2);
			xyToPos(&row, &col, &where, &cp, &w2);
			w = w2;
			doFast = 0;
		}

		if( where == INSIDEWINDOW ) {
			/* if the cursor is off the screen then disable	 */
			/* the fast cursor motion since it screws up the */
			/* display we set doFast=0 to disable the fast	 */
			/* cursor motion.  Also, do not do fast if the   */
			/* selection mode is not character		 */
			if( selBegin < w->posTopline
			 || selEnd >= w->posBotline
			 || selMode != SELCHAR
			)
				doFast = 0;
			
			/* this speeds up simple cursor movements */
 			if( selBegin == selEnd && doFast ) {
 				oldSelBegin = selBegin;
				selEnd = selBegin = cp;
				ch = readChar(w->fileId, selBegin);
				/* do not allow a NL to be selected */
				/* without a CR */
				if( ch == '\n' )
					selBegin--;
				n = -1;
				if( (cp < oldSelBegin-1)
				 || (cp == oldSelBegin-1 && ch == '\n') ) {
					row2 = row + 1;
					oldSelBegin = prevLine(w->fileId, cp,
						&n);
				} else {
					if( cp > oldSelBegin+2
					 || (cp == oldSelBegin+2
					 && ch != '\n') )
						row2 = row--;
					else
						row2 = row;
					oldSelBegin = prevLine(w->fileId,
						oldSelBegin,&n);
				}
				setMap(row, 0, row2, scrCols-1, 1, 0x07);
				maskTop(selWindow);
				oldSelBegin = fillLine(w, oldSelBegin,
					row, w->col1+1, w->col2-1);
				if( row != row2 )
					fillLine(w, oldSelBegin,
						row2, w->col1+1, w->col2-1);
				updateScreen(row, row2);
			} else {
 				n = selMode;
				select(w, cp, row, col, -1);
				selMode = n;
				modeExtend(w, selBegin, &selBegin, &selEnd);
				setMap(row, 0, row, scrCols-1, 1, 0x07);
				maskTop(selWindow);
				n = -1;
				oldSelBegin=prevLine(w->fileId, selBegin, &n);
				fillLine(w, oldSelBegin, row, w->col1+1,
					w->col2-1);
				updateScreen(row, row);
			}
		}
	} else {
		setCPos(row, col);
	}
	if( ++evtail >= NEVENTS )
		evtail = 0;
	i = evtail;
	events[i].mask = 0x1;
	events[i].buttons = 0;
	events[i].vertical = mouseVertical;
	events[i].horizontal = mouseHorizontal;
}
