{$C-,I-,K-}
program IchiEditor;
{ Note: Must declare maximum Stack/Heap on compilation.  Each $2000 of heap }
{       provides work space for a 90k file.  We normally request $2000.     }

{$I VARTYPES.INC}  { Variable, type, and const declarations }
{$I USERS.INC   }  { Message line plus other utility routines }
{$I USER.INC    }  { Editor kernel and primitive level helper routines }
{$I INITIALI.INC}  { File read/write, Initialization, help screens }
{$I LOGO.INC    }  { Logo, marquee, and execDos procedures }
{$I SCREEN.INC  }  { Screen updating routines   }
{$I KCMD.INC    }  { Ctrl-K block oriented routines }
{$I OCMD.INC    }  { Ctrl-O windows oriented routines }
{$I QCMD.INC    }  { Ctrl-Q quick movements & search/replace routines }
{$I CMD.INC     }  { General direct editing commands }
{$I TASKINP.INC }  { Input classification and scheduling routines }

begin { program body }
    if EditFileExist('ICHI.000') then
        Ovrpath('.')
    else if EditFileExist('\ICHI.000') then
        Ovrpath('\')
    else begin
        clrscr;
        gotoxy(10,10); write('ͻ');
        gotoxy(10,11); write(' ICHI.000 must be in the DEFAULT or ROOT directory ');
        gotoxy(10,12); write('ͼ');
        gotoxy(1,20);
        Beep; Exit;
    end;

    EditInitialize;   { Obligatory initialization of dynamic structures }

    if paramCount = 1 then begin
        fnameStr := paramStr(1);
        if EditFileExist(fnameStr) then begin
            EditAppCmdnam('Reading '+fnameStr);
            EditFileRead(fnameStr);
            Editbackground;
            EditZapcmdnam;
            EditUpdcmdline;
        end
        else begin
            EditAppCmdnam('Creating new file '+fnameStr);
            Curwin^.filename := fnameStr;
        end;
    end;

    EditdoLogo;
    EditZapcmdnam;
    EditUpdcmdline;
    EditUpdExtraLine(Curwin^.Curline);

    while not Rundown do
        if EditKeypressed then
            EditClsinp
        else
            EditBackground;

    Clr_Scrn(VideoAdr, Defnorows * Defnocols, txtColor);
end.