/*
 * xvdflt.c - load routine for 'default' XV image
 *
 * LoadDfltPic()  -  loads up 'pic'  note:  can't fail(!)
 */


/*
 * Copyright 1989, 1990, 1991, 1992 by John Bradley and
 *                       The University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation. 
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 *
 * The author may be contacted via:
 *    US Mail:   John Bradley
 *               GRASP Lab, Room 301C
 *               3401 Walnut St.  
 *               Philadelphia, PA  19104
 *
 *    Phone:     (215) 898-8813
 *    EMail:     bradley@cis.upenn.edu       
 */


#include "xv.h"

#ifdef VMS
#  include "[.bitmaps]xvpic_logo."
#  include "[.bitmaps]xvpic_jhb."
#  include "[.bitmaps]xvpic_rev."
#  include "[.bitmaps]xf_left."
#  include "[.bitmaps]xf_right."
#else
#  include "bitmaps/xvpic_logo"
#  include "bitmaps/xvpic_jhb"
#  include "bitmaps/xvpic_rev"
#  include "bitmaps/xf_left"
#  include "bitmaps/xf_right"
#endif

#define DWIDE 320
#define DHIGH 200

/* local function defs */
#ifdef __STDC__
static void setcolor(int, int, int, int);
static void gen_bg();
#else
static void setcolor(), gen_bg();
#endif


/*******************************************/
void LoadDfltPic()
/*******************************************/
{
  /* load up the stuff XV expects us to load up */

  SetDirRButt(F_FORMAT, F_GIF);
  SetDirRButt(F_COLORS, F_FULLCOLOR);

  SetISTR(ISTR_FORMAT,"<internal>");
  sprintf(formatStr, "%dx%d internal image.",DWIDE, DHIGH);

  pic = (byte *) calloc(DWIDE * DHIGH,1);
  if (!pic) FatalError("couldn't malloc 'pic' in LoadDfltPic()");

  pWIDE = DWIDE;  pHIGH = DHIGH;

  xbm2pic(xvpic_logo_bits, xvpic_logo_width, xvpic_logo_height, 
	   pic, pWIDE, pHIGH, DWIDE/2, 60, 100);

  xbm2pic(xvpic_jhb_bits, xvpic_jhb_width, xvpic_jhb_height, 
	   pic, pWIDE, pHIGH, pWIDE/2, 134, 101);

  xbm2pic(xf_right_bits, xf_right_width, xf_right_height, 
	   pic, pWIDE, pHIGH, DWIDE/2 - 100, 134, 101);
  xbm2pic(xf_left_bits, xf_left_width, xf_left_height, 
	   pic, pWIDE, pHIGH, DWIDE/2 + 100, 134, 101);

  xbm2pic(xvpic_rev_bits, xvpic_rev_width, xvpic_rev_height, 
	   pic, pWIDE, pHIGH, DWIDE/2, 180, 101);


  setcolor(0, 80,80,150);
  gen_bg();

  /* set up colormap */
  setcolor(100, 202,219,232);   /* XV */
  setcolor(101, 164,242,254);   /* jhb + fish + revdate */
}



/*******************************************/
void xbm2pic(bits, bwide, bhigh, pic, pwide, phigh, cx, cy, col)
     char *bits;
     byte *pic;
     int   bwide, bhigh, pwide, phigh, cx, cy, col;
/*******************************************/
{
  /* draws an X bitmap into an 8-bit 'pic'.  Only '1' bits from the bitmap
     are drawn (in color 'col').  '0' bits are ignored */

  int     i, j, k, bit, x, y;
  byte   *pptr, *bptr;

  y = cy - bhigh/2;

  for (i=0; i<bhigh; i++,y++) {
    if ( (y>=0) && (y<phigh) ) {
      pptr = pic + y * pwide;
      bptr = (byte *) bits + i * ((bwide+7)/8);
      x = cx - bwide/2;

      for (j=0,bit=0; j<bwide; j++, bit = (++bit)&7, x++) {
	if (!bit) k = *bptr++;
	if ( (k&1) && (x>=0) && (x<pwide))
	  pptr[x] = col;

	k = k >> 1;
      }
    }
  }
}  


/*******************************************/
static void setcolor(i, rv, gv, bv)
int i, rv, gv, bv;
{
  r[i] = rv;
  g[i] = gv;
  b[i] = bv;
}


/*******************************************/
static void gen_bg()
{
  int i,j;
  byte *pp;

  pp = pic;
  for (i=0; i<pHIGH; i++)
    for (j=0; j<pWIDE; j++, pp++) {
      if (*pp == 0) {
	*pp = ((i+j) * 64) / (pHIGH + pWIDE);
      }
    }

  setcolor( 0, 120, 171, 172);
  setcolor(63,   2,  69,  66);

  for (i=1; i<63; i++) {
    setcolor(i, r[0] + ((r[63]-r[0]) * i)/64,
                g[0] + ((g[63]-g[0]) * i)/64,
                b[0] + ((b[63]-b[0]) * i)/64);
  }
}

