int  get_key(void)
	{
	int  ch;
	ch = getch();
	if( ch == 0 )
		ch = getch() + 0x0100;
	return(ch);
	}

void highliteon(int col,int row,char *string)
	{
	gotoxy(col, row);
	textbackground(RED);
	textcolor(WHITE);
	cprintf("%s",string);
	}
void highliteoff(int col,int row,char *string)
	{
	gotoxy(col, row);
	textbackground(BLUE);
	textcolor(WHITE);
	cprintf("%s",string);
	}

// function getselection
int getselection( int num_items, int lengthitems, int column, int *listpos, char *listnames)
	{
	// num_items -> first index of array
    // lengthitems -> lenght of items
	// column -> starting column for the list items
	// listpos -> pointer to an array of row locations for the listnames
	// listnames -> pointer to a list of names for the list items
	int i,current,row,ch;
	char *stringptr;
//	textbackground(BLUE);
//	textcolor(WHITE);
//	clrscr();
	for( i = 0 ; i < num_items ; i++ )
		{
		gotoxy(column,*(listpos+i) - 3);
		cprintf("%s",listnames + i * lengthitems);
		}

	current = 0;
	row = *(listpos+current) -3;
	stringptr = listnames + current * lengthitems;
	highliteon(column, row, stringptr);
	FOREVER
		{
		switch(ch = get_key())
			{
			case UP:	highliteoff (column, *(listpos+current) -3, listnames + current * lengthitems);
						current -= 1;
						if( current < 0 )
							current = num_items - 1;
						highliteon (column, *(listpos+current) -3, listnames +current * lengthitems);
						break;

			case DOWN:  highliteoff (column, *(listpos+current) -3, listnames + current * lengthitems);
						current += 1;
						if( current > (num_items - 1) )
							current = 0;
						highliteon (column, *(listpos+current) -3, listnames +current * lengthitems);
						break;

			case ENTER: highliteoff (column, *(listpos+current) -3, listnames + current * lengthitems);
						break;

			case ESC:	highliteoff (column, *(listpos+current) -3, listnames + current * lengthitems);
						break;

			default:	break;
			}
		if( ch == ENTER )
			return(current);
		if( ch == ESC )
			return (-1);
		}
	}


void calc_cluster_sectors( uint cluster, ulong *first_sector, ulong *last_sector )
	{
	// uint cluster - cluster number to be converted to first and last sector
	// ulong *first_sector = the address of the first sector number
	// ulong *last_sector = the address of the last sector number

	// use the  cluster number to calculate the sectors to be read
	*first_sector = // first multiply the cluster number times the sectors/cluster
					(ulong)cluster * (ulong)hdb.sectors_cluster
					// then subtract out the fact that the data really begins with cluster 2
					- 2L * (ulong)hdb.sectors_cluster
					// then add the reserved sectors
					+ (ulong)hdb.reserved_sectors
					// then add the number of sectors in the fats
					+ (ulong)hdb.sectors_fat * (ulong)hdb.number_fats
					// then add the number of sectors in the root directory
					+ (((ulong)hdb.number_entries_root_dir * 32L)/(ulong)hdb.bytes_sector);
	*last_sector = *first_sector + (ulong)hdb.sectors_cluster -1L;
	}

