// clean the directory
void clean_dir(uint cluster, char *dirstring)
	{
	// uint cluster - the cluster number of the directory to be displayed
    // uchar *dirstring - previous directory names
	uint	i,j,k,m; // indexes for 'for' loops
	uint 	ch; 	// ich = input character from keyboard,
	char	temp[256]; // temp string for new directory
	char	temp1[9];
    uint	flag;	// tells whether the rest of the diretory is valid
	ulong	first_sector;    // first_sector = first sector of the cluster
	ulong	last_sector;     // last_sector = last sector of the cluster
	uint 	next_cluster;	 // next_cluster = value of a cluster - points to next cluster
	ulong 	fat_sector;      // fat_sector = relative sector number of the fat table
	ulong	next_fat_sector; // next_fat_sector = relative sector number of the fat table for the next cluster
	ulong	num_clusters;    // num_clusters = number of clusters in the directory
	uint 	fat_offset;      // fat_offset = offset into the sector to find the next cluster value
	uint	next_fat_offset; // next_fat_offset = same for next cluster
	uchar 	far *sec_buf;    	 // *sec_buf = pointer to sector buffer
	uchar 	*fat_sec_buf;       // *fat_sec_buf = pointer to fat sector buffer
	uchar 	*next_fat_sec_buf;  // *next_fat_sec_buf = pointer to next fat sector buffer
	uint 	far *cluster_chain_begin; // far *cluster_chain_begin = far pointer to beginning of cluster chain for this directory
	uint 	far *cluster_chain_ptr;   // far* cluster_chain_ptr = pointer to object within the cluster chain



	// allocate memory for the sector buffers and set the pointers
	sec_buf = (uchar far*)farcalloc((ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector,sizeof(uchar));
	if( sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc sec_buf");
		getch();
		exit(0);
		}
	fat_sec_buf = (uchar*)calloc(hdb.bytes_sector, sizeof(char));
	if( fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc fat_sec_buf");
		getch();
		exit(0);
		}
	next_fat_sec_buf = (uchar*)calloc(hdb.bytes_sector,sizeof(char));
	if( next_fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc next_fat_sec_buf");
		getch();
		exit(0);
		}

	// calculate the sector and offset of the cluster location in the fat
	fat_sector =  ((ulong)cluster * 2L)/(ulong)hdb.bytes_sector
				  // use the first fat so add in the reserved sectors
				  + (ulong)hdb.reserved_sectors;
	fat_offset = (uint)(((ulong)cluster * 2L) % (ulong)hdb.bytes_sector);
	read_sec((uchar far*)fat_sec_buf, fat_sector,1);  // read the fat sector
	next_cluster = *(uint*)&fat_sec_buf[(uint)fat_offset];

	// count the clusters for this directory
	num_clusters = 1L; // got one at least
	while( next_cluster != 0xffff )
		{
		num_clusters += 1L;  // got more than one so increment
		// find the sector holding the next cluster
		next_fat_sector =  (ulong)((next_cluster * 2)/hdb.bytes_sector)
				+ (ulong)hdb.reserved_sectors;  // use the first fat so add in the reserved sectors
		// find the offset into the sector for the next cluster
		next_fat_offset = (next_cluster * 2) % hdb.bytes_sector;
		// read the fat sector
		read_sec((uchar far*)next_fat_sec_buf, next_fat_sector,1);
		// get the value of the cluster
		next_cluster = *(uint*)&next_fat_sec_buf[(uint)next_fat_offset];
		}  // when finished - num_clusters has the number of clusters in the directory

	// now reserve memory large enough to contain the cluster numbers
	// and assign it to the pointer
	cluster_chain_begin = (uint far*)farcalloc( num_clusters, sizeof(uint) );
	cluster_chain_ptr = cluster_chain_begin;
	*cluster_chain_ptr++ = cluster; // save the first cluster and increment the ptr

	// restore the 'value' of the starting cluster which is the next cluster #
	next_cluster = *(uint*)&fat_sec_buf[(uint)fat_offset];
	// now save the cluster values
	while( next_cluster != 0xffff )
		{
		*cluster_chain_ptr++ = next_cluster; // not the last so save the next cluster number and increment the ptr
		next_fat_sector =  (ulong)((next_cluster * 2)/hdb.bytes_sector)
				+ (ulong)hdb.reserved_sectors;  // use the first fat so add in the reserved sectors
		next_fat_offset = (next_cluster * 2) % hdb.bytes_sector;
		read_sec((uchar far*)next_fat_sec_buf, next_fat_sector,1);  // read the fat sector
		next_cluster = *(uint*)&next_fat_sec_buf[(uint)next_fat_offset];
		}

	//==============================================================
	// here I know all the cluster chain for this directory with the following data
	// cluster = first cluster number (not its value)
	// num_clusters = number of clusters in the directory
	// cluster_chain_begin = pointer to first location of cluster number storage
	// cluster_chain_ptr = floating pointer to cluster chain
	// the values of the cluster pointers are stored in cluster chain starting at cluster_chain_begin
	//===============================================================

	flag = 1; // set all entries valid for now
	for( i = 0 ; i < (uint)num_clusters ; i++ )
		{
		calc_cluster_sectors( *(cluster_chain_begin + (uint)i),  &first_sector,  &last_sector );
//		for(n = 0 ; n < hdb.sectors_cluster ; n++ )
//			read_sec( (uchar far*)(sec_buf+n*hdb.bytes_sector), first_sector+(ulong)n, 1 );
		rd_multi( (uchar far*)(sec_buf), first_sector, 1 , hdb.sectors_cluster);
		for( j = 0 ; j < hdb.sectors_cluster ; j++ )
			{
			for( k = 0 ; k < hdb.bytes_sector/32 ; k++ )
				{
				if( *(sec_buf + j*hdb.bytes_sector + k*32) != 0x2e ) // skip the first two entries
					{
					if( flag == 1 )
						{
						if( *(sec_buf +j*hdb.bytes_sector + k*32) == 0xe5 )
							{
							for( m = 1 ; m < 32 ; m++ )
								*(sec_buf + j*hdb.bytes_sector + k*32 + m) = 0x00;
							}
						if ( *(sec_buf + j*hdb.bytes_sector + k*32) == 0 )
							{
							for( m = 0 ; m < 32 ; m++ )
								*(sec_buf + j*hdb.bytes_sector + k*32 + m) = 0x00;
							flag = 0;
							}
						}
					else
						{
						for( m = 0 ; m < 32 ; m++ )
							*(sec_buf + j*hdb.bytes_sector + k*32 + m) = 0x00;
						}
					}
				}
			}
		wt_multi( (uchar far*)(sec_buf), first_sector, 1, hdb.sectors_cluster );
		}
	// completed cleaning so now go thru it and clean any other sub directories
	for( i = 0 ; i < (uint)num_clusters ; i++ )
		{
		calc_cluster_sectors( *(cluster_chain_begin + (uint)i),  &first_sector,  &last_sector );
		rd_multi( (uchar far*)(sec_buf), first_sector, 1 , hdb.sectors_cluster);
		for( j = 0 ; j < hdb.sectors_cluster ; j++ )
			{
			for( k = 0 ; k < hdb.bytes_sector/32 ; k++ )
				{
				if( *(sec_buf+j*hdb.bytes_sector+k*32+11) & 0x10 ) // check if directory
					{
					ch = *(sec_buf+j*hdb.bytes_sector+k*32);
					if( (ch != 0x2e) && (ch != 0x00) && (ch != 0xe5) ) // check for first two entries
						{
						dircount += 1;
						cprintf("\n\rCleaning %u %s\/", dircount,dirstring);
						for( m = 0 ; m < 8 ; m++ )
							cprintf("%c", *(sec_buf+j*hdb.bytes_sector+k*32+m));
						for( m = 0 ; m < 256 ; m++ )
							temp[m] = 0x00;
						for( m = 0 ; m < 9 ; m++ )
							temp1[m] = 0x00;
						strcat(temp, dirstring);
						strcat(temp,"\/");
						for (m = 0 ; m < 8 ; m++)
							{
							if( *(sec_buf+j*hdb.bytes_sector+k*32+m) != 0x20 )
								temp1[m] = *(sec_buf+j*hdb.bytes_sector+k*32+m);
							}
						strcat(temp, temp1);
						clean_dir(*(uint far*)(sec_buf+j*hdb.bytes_sector+k*32+26), temp);
						}
					}
				}
			}
		}
	farfree(sec_buf);
	free(fat_sec_buf);
	free(next_fat_sec_buf);
	farfree(cluster_chain_begin);
	}


