%title 'An ix86 disassembler by me, (c) 1998 Henrik Nebrin'

        ideal
        p386
        nowarn  brk

op1isfirst      equ     1               ;defined if opcode.op1 ofs = 0000h

ifdef Clib
        include 'C.inc'
else
_wordsize       equ     2
        include 'proc.inc'
endif
        include '__dislib.inc'
        include 'dislib.inc'

signed          equ     0001h           ;eax is a signed number
showsign        equ     0002h           ;always show '+' or '-'
bighex          equ     0004h           ;big hex characters (A-F) (ntoa:proc)

macro   checkoperand
ifdef Clib
        call    near ptr dis_checkoperand
else
        call    (dis_input_t ptr __dis_gs:si).checkoperand
endif
endm    checkoperand

ifdef Clib
        extrn   ___dis:procptr
else
        extrn   ntoa:procptr
endif

        startcode
ifdef Clib
        ;
        ;   dis_checkoperand:near
        ;
        ;   check an operand
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          _es:di string
        ;   output: cf=1=nothing changed
        ;           cf=0=printed something in the string and advanced it
        ;   registers: cf=1=none,cf=0=di
        ;
proc    dis_checkoperand near
        ;NOTE: the upper word of all registers (except eax) might
        ;have been changed by the C++ procedure!!!
        push    es
if @datasize
        push    gs
endif
        push    eax cx dx bx
if @datasize
        push    es di
        mov     ax,sp
        push    ss ax gs bx gs si
        call    (dis_input_t ptr __dis_gs:si).checkoperand
        add     sp,000Ch
        pop     di cx
else
  ifdef stackfar
    err
  endif
        push    di sp bx si
        call    (dis_input_t ptr __dis_gs:si).checkoperand
        pop     cx dx cx di
endif
        cmp     ax,0001h
@@666:
        pop     bx dx cx eax
if @datasize
        pop     gs
endif
        pop     es
        retn
endp    dis_checkoperand

        ;
        ;   ntoa:proc
        ;
        ;   convert a number to ascii
        ;
        ;   input: eax  number to convert to ascii
        ;          cx   minimum # of digits to print
        ;          bl   flags (see equates)
        ;          bh   base (10b=binary,10o=octal,10d=decimal,10h=hex)
        ;          es:di string to convert it to
        ;   output: es:di string with number in (zero terminated)
        ;           eax zero
        ;           cx  # of digits the string has (incl. '+' or '-')
        ;   registers: eax,cx
        ;
proc    ntoa near
        public  ntoa
        call    near ptr __ntoa
        push    di
        add     di,cx
        mov     [byte ptr _es:di],00h
        pop     di
        retn
endp    ntoa

        ;
        ;   __ntoa:proc
        ;
        ;   convert a number to ascii
        ;
        ;   input: eax  number to convert to ascii
        ;          cx   minimum # of digits to print
        ;          bl   flags (see equates)
        ;          bh   base (10b=binary,10o=octal,10d=decimal,10h=hex)
        ;          es:di string to convert it to
        ;   output: es:di string with number in (NOT zero terminated!!!)
        ;           eax zero
        ;           cx  # of digits the string has (incl. '+' or '-')
        ;   registers: eax,cx
        ;
proc    __ntoa near
if @datasize
        push    ds
endif
        push    edx ebp si di
if @datasize
        push    es
        pop     ds
        assume  ds:nothing
endif
        test    bl,signed
        jz      short @@10
        test    eax,eax
        jns     short @@10
        neg     eax
        mov     byte ptr ds:[di],'-'
        jmp     short @@incdi
@@10:
        test    bl,showsign
        jz      short @@20
        mov     byte ptr ds:[di],'+'
@@incdi:
        inc     di
@@20:
        test    cx,cx
        jnz     short @@30
        inc     cx
@@30:
        xor     si,si
        movzx   ebp,bh
        db      66h
@@pushloop:
        xor     dx,dx
        div     ebp
        push    dx
        inc     si
        test    eax,eax
        jnz     short @@pushloop

        mov     dx,si
        mov     bp,cx
        sub     cx,si
        jbe     short @@40
        mov     dx,bp
        mov     al,'0'
        rep stosb
@@40:
        mov     cx,dx
        mov     dx,('0' shl 8) or ('a'-('0'+10))
        test    bl,bighex
        jz      short @@no
        mov     dl,'A'-('0'+10)
@@no:
@@poploop:
        pop     ax
        add     al,dh
        cmp     al,'9'
        jbe     short @@50
        add     al,dl
@@50:
        mov     [di],al
        inc     di
        dec     si
        jg      short @@poploop
@@666:
        pop     di si ebp edx
        mov     al,[di]
        cmp     al,'-'
        je      short @@60
        cmp     al,'+'
        jne     short @@70
@@60:
        inc     cx
@@70:
        xor     eax,eax
if @datasize
        pop     ds
        assume  ds:@data
endif
        retn
        assume  ds:@data
endp    __ntoa

proc    _dis_printinstruction procptr
        public  _dis_printinstruction
        arg     dis_input:dataptr,deststring:dataptr
        push    bp
        mov     bp,sp
        jmp     short _dis_jmphere
endp    _dis_printinstruction
endif

        ;
        ;   dis:proc
        ;
        ;   disassemble one instruction and print it in a string (reentrant)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          _es:di string to print the finished result
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: none
        ;
proc    __ret procptr
ifdef Clib
        xor     ax,ax
        pop     bp
endif
        ret
endp    __ret
ifdef Clib
proc    _dis procptr
        public  _dis
else
proc    dis procptr
endif
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
ifdef Clib
        arg     dis_input:dataptr,deststring:dataptr
        push    bp
        mov     bp,sp
        push    dis_input
        call    ___dis
  if @datasize
        db      66h
  endif
        pop     cx
        test    ax,ax
        jz      short __ret
_dis_jmphere:
if @datasize eq 2
        push    ds @data
        pop     ds
        assume  ds:@data
endif
        push    si di
  if @datasize
        lgs     si,dis_input
        les     di,deststring
  else
        mov     si,dis_input
        mov     di,deststring
        push    ds
        pop     es
  endif
  if @datasize eq 2
        local   savedds:word,savedsi:word,saveddi:word,op1ptr:word,op2ptr:word,op3ptr:word=localsize
  else
        local   savedsi:word,saveddi:word,op1ptr:word,op2ptr:word,op3ptr:word=localsize
  endif
        cld
else
        call    __dis
        jc      short __ret
label   dis_printinstruction procptr
        local   deststring:word,op1ptr:word,op2ptr:word,op3ptr:word=localsize
        push    eax cx dx bx si di bp
        mov     bp,sp
        push    di
endif
ifdef op1isfirst
        push    si
else
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op1
        push    ax
endif
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op2
        push    ax
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op3
        push    ax

        cmp     (dis_input_t ptr __dis_gs:si).__dis_input.opcode.prefixes,00h
        je      short @@skipprefixes
        mov     cl,20h
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jz      short @@noitisnt
        mov     cl,';'
@@noitisnt:
macro   p x,y
        local   @@10
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.prefixes,x
        jz      short @@10
        mov     bx,offset y
        call    near ptr copyopname
        mov     al,cl                   ;;" "=intel,";"=at&t
        stosb
@@10:
endm    p
        p       __dis_lockprefix,@lock
        p       __dis_repprefix,@rep
        p       __dis_repnzprefix,@repne
purge   p
        testflag (dis_input_t ptr __dis_gs:si).flags,df_tabafterrep
        jz      short @@notabafterrep
        test    (dis_input_t ptr __dis_gs:si).__dis_input.opcode.prefixes,__dis_repprefix or __dis_repnzprefix
        jz      short @@notabafterrep
        dec     di                      ;the space we printed
        call    near ptr @@printtabspaces
@@notabafterrep:
@@skipprefixes:
        mov     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.opcodeid
        movzx   bx,ah
        add     bx,bx
        xor     ah,ah
        mov     cx,offset opcodeidsatt
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jnz     short @@att1
        mov     cx,offset opcodeids
@@att1:
        add     bx,cx
        add     ax,ax
        mov     bx,[bx]
        add     bx,ax
        mov     bx,[bx]
        call    near ptr copyopname
        ;All fields in opcode are undefined if noperands=00h!!! Check it first
        movzx   cx,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.noperands
        jcxz    @@666
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_dontprintops
        jnz     short @@666             ;mostly for string instr. + xlat
        push    cx
        call    near ptr @@printtabspaces
        pop     cx
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jz      short @@notatt
        cmp     (dis_input_t ptr __dis_gs:si).__dis_input.opcode.opcodeword,opid_opnames1+00C8h
        je      short @@notatt          ;enter instruction is not reversed
        cmp     (dis_input_t ptr __dis_gs:si).__dis_input.opcode.opcodeid,opid_db
        je      short @@notatt          ;if it's "db XX,XX,XX"
        cmp     cx,0002h
        jb      short @@notatt
        ja      short @@three
@@two:
ifdef op1isfirst
        mov     op2ptr,si
else
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op1
        mov     op2ptr,ax
endif
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op2
        jmp     short @@movop1ptrax
@@three:
ifdef op1isfirst
        mov     op3ptr,si
else
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op1
        mov     op3ptr,ax
endif
        lea     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op3
@@movop1ptrax:
        mov     op1ptr,ax
@@notatt:
        lea     bx,op1ptr
        jmp     short @@starthere
@@operandsloop:
        call    near ptr printcomma
@@starthere:
        push    cx bx
ifdef stackfar
        segss
endif
        mov     bx,[bx]
        push    bx
        mov     bx,word ptr (dis_operand_t ptr __dis_gs:bx).flags
        and     bx,dop_typemask
        add     bx,bx
        mov     ax,offset operandcallatt
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jnz     short @@attyes
        mov     ax,offset operandcall
@@attyes:
        add     bx,ax
        mov     ax,[bx]
        pop     bx
        call    ax
        pop     bx cx
        dec     bx
        dec     bx
        loop    @@operandsloop
@@666:
ifdef Clib
        xor     ax,ax
else
        xor     al,al
endif
        stosb
ifdef Clib
        inc     ax
        mov     si,savedsi
        mov     di,saveddi
  if @datasize eq 2
        mov     ds,savedds
  endif
        leave
else
        leave
        pop     di si bx dx cx eax
endif
@@retn:
        ret

        ;
        ;   @@printtabspaces:near
        ;
        ;   print spaces in deststring (at least one space)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          es:di >= deststring (offset)
        ;   output: es:di after the last spaces printed
        ;   registers: ax,cx,di
        ;
@@printtabspaces:
        mov     cx,di
        xor     ah,ah
        sub     cx,word ptr deststring
        mov     al,(dis_input_t ptr __dis_gs:si).tabsize
        sub     ax,cx
        ja      short @@lok
        mov     ax,0001h
@@lok:
        xchg    cx,ax
        mov     al,20h
        rep stosb
printtabspacesretn:
        retn
ifdef Clib
endp    _dis
else
endp    dis
endif

        ;
        ;   printcomma:near
        ;
        ;   print a comma and a space if necessary
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          es:di string
        ;   output: es:di after the comma (and space if we printed it)
        ;   registers: al,di
        ;
proc    printcomma near
        mov     al,','
        stosb
        testflag (dis_input_t ptr __dis_gs:si).flags,df_commaspace
        jz      short @@666
        mov     al,' '
        stosb
@@666:
        retn
endp    printcomma

        ;
        ;   convertdop_sizeequ:near
        ;
        ;   convert a dop_sizebyte/word/dword equate to something in ch
        ;
        ;   input: al   euqate (00h=byte,01h=word or 02h=dword)
        ;   output: ch  01h=byte/02h=word/04h=dword
        ;   registers: ch
        ;
proc    convertdop_sizeequ near
        ;NOTE: Assumes byte=0,word=1,dword=2 !!!!!
        mov     ch,al
        and     ch,03h
        add     ch,ch
        jnz     short @@666
        inc     ch
@@666:
        retn
endp    convertdop_sizeequ

        ;
        ;   dis_regatt:near
        ;
        ;   print a register (at&t syntax)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed
        ;   registers:
        ;
proc    dis_regatt near
        call    near ptr checkindirectcalljmp
        jmp     short dis_regcontinue
endp    dis_regatt

        ;
        ;   dis_reg:near
        ;
        ;   print a register
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_reg near
        call    near ptr printsmallorlarge
dis_regcontinue:
        checkoperand
        jnc     short printregisterretn
dis_regprintregister:
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.reg.register
endp    dis_reg

        ;
        ;   printregister:near
        ;
        ;   print a register name
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          al   register name equate (dr_ax/dr_ecx/dr_etc)
        ;          es:di string to print it in
        ;   output: es:di after the register name we just printed in it
        ;   registers: ax,di
        ;
proc    printregister near
        push    bx
        movzx   bx,al
        add     bx,bx
        mov     ax,offset regsatt
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jnz     short @@10
        mov     ax,offset regs
@@10:
        add     bx,ax
        mov     bx,[bx]
        call    near ptr copyregstring
        pop     bx
printregisterretn:
        retn
endp    printregister

        ;
        ;   dis_farofs:near
        ;
        ;   print a far ptr seg:ofs
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_farofs near
        call    near ptr printsmallorlarge
        testflag (dis_input_t ptr __dis_gs:si).flags,df_farptr
        jz      short @@10
        push    bx
        mov     bx,offset @far
        call    near ptr copyptrstringandspaceandprintptr
        pop     bx
@@10:
        checkoperand
        jnc     short printregisterretn
        movzx   eax,(dis_operand_t ptr __dis_gs:bx).ops.farptr.seg
        mov     ch,02h
        push    bx
        call    near ptr xorblblprintnumber
        pop     bx
        mov     al,':'
        stosb
        jmp     short dis_nearofs_printofs
endp    dis_farofs

        ;
        ;   dis_farofsatt:near
        ;
        ;   print a far ptr seg:ofs (at&t syntax)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_farofsatt near
        checkoperand
        jnc     short printregisterretn
        mov     al,'$'
        stosb
        movzx   eax,(dis_operand_t ptr __dis_gs:bx).ops.farptr.seg
        mov     ch,02h
        push    bx
        call    near ptr xorblblprintnumber
        pop     bx
        call    near ptr printcomma
        jmp     short dis_nearofs_printofsatt
endp    dis_farofsatt

        ;
        ;   dis_nearofsatt:near
        ;
        ;   print a near offset (at&t syntax)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_nearofsatt near
        checkoperand
        jnc     short dis_nearofsretn
dis_nearofs_printofsatt:
        mov     al,'$'
        stosb
        jmp     short dis_nearofs_printofs
endp    dis_nearofsatt

        ;
        ;   dis_nearofs:near
        ;
        ;   print a near offset
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_nearofs near
        call    near ptr printsmallorlarge
        testflag (dis_operand_t ptr __dis_gs:bx).ops.nearptr.__flags,dn_short
        jz      short @@notshort
        testflag (dis_input_t ptr __dis_gs:si).flags,df_noshort
        jnz     short @@10
        mov     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.opcodeword
        cmp     ax,00E0h
        jb      short @@not
        cmp     ax,00E3h
        jbe     short @@10
@@not:
        push    bx
        mov     bx,offset @short
        call    near ptr copyptrstringandspace
        pop     bx
        jmp     short @@10
@@notshort:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_nearptr
        jz      short @@10
        push    bx
        mov     bx,offset @near
        call    near ptr copyptrstringandspaceandprintptr
        pop     bx
@@10:
        checkoperand
        jnc     short dis_nearofsretn
dis_nearofs_printofs:
        mov     eax,(dis_operand_t ptr __dis_gs:bx).ops.nearptr.ofs
        mov     ch,02h
        cmp     (dis_operand_t ptr __dis_gs:bx).size,dop_sizeword
        je      short xorblblprintnumber
        mov     ch,04h
xorblblprintnumber:
        xor     bl,bl
        call    near ptr printnumber
dis_nearofsretn:
        retn
endp    dis_nearofs

        ;
        ;   dis_imm:near
        ;
        ;   print an immediate value operand
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_imm near
        call    near ptr printsmallorlarge
dis_immcheckoperand:
        checkoperand
        jnc     short dis_nearofsretn
        mov     al,(dis_operand_t ptr __dis_gs:bx).size
        call    near ptr convertdop_sizeequ
        mov     eax,(dis_operand_t ptr __dis_gs:bx).ops.imm.immediate
        jmp     short xorblblprintnumber
endp    dis_imm

        ;
        ;   dis_immatt:near
        ;
        ;   print an immediate value operand (at&t syntax)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_immatt near
        mov     al,'$'
        stosb
        jmp     short dis_immcheckoperand
endp    dis_immatt

        ;
        ;   checkindirectcalljmp:near
        ;
        ;   check if the instruction is a call/jmp reg/mem
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the * we printed
        ;   registers: ax,di
        ;
proc    checkindirectcalljmp near
        mov     ax,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.opcodeid
        cmp     ah,opid_grp5 shr 8
        jne     short @@666
        cmp     al,02h
        jb      short @@666
        cmp     al,05h
        ja      short @@666
        mov     al,'*'
        stosb
@@666:
        retn
endp    checkindirectcalljmp

        ;
        ;   dis_mematt:near
        ;
        ;   print a memory operand (at&t syntax)
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_mematt near
        call    near ptr checkindirectcalljmp
        call    near ptr printsegoverrides
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      dis_memonlydisplacement
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasdispl
        jz      short @@nodispl
        checkoperand
        jnc     short @@nodispl
        call    near ptr printdisplacement
@@nodispl:
        mov     al,'('
        call    near ptr @@printbracket
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase
        jz      short @@nobase
        call    near ptr printbaseregister
@@nobase:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasindex
        jz      short @@noscale
        call    near ptr printcomma
        call    near ptr printindexregister
@@noindex:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasscale
        jz      short @@noscale
        mov     cl,(dis_operand_t ptr __dis_gs:bx).ops.mem.scale
        test    cl,cl
        jnz     short @@scalene0
        testflag (dis_input_t ptr __dis_gs:si).flags,df_usescale1
        jz      short @@noscale
@@scalene0:
        call    near ptr printcomma
        mov     al,01h
        shl     al,cl
        xor     al,30h
        stosb
@@noscale:
@@printlastbracket:
        mov     al,')'
@@printbracket:
        testflag (dis_operand_t ptr __dis_gs:si).flags,df_nobracketsmem
        jnz     short @@retn
        stosb
@@retn:
        retn
endp    dis_mematt

        ;
        ;   printbaseregister:near
        ;
        ;   print a memory base register
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the last character
        ;   registers:
        ;
proc    printbaseregister near
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.mem.baseindex
        and     al,0Fh
        jmp     printregister
endp    printbaseregister

        ;
        ;   printindexregister:near
        ;
        ;   print a memory index register
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the last character
        ;   registers:
        ;
proc    printindexregister near
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.mem.baseindex
        shr     al,04h
        jmp     printregister
endp    printindexregister

        ;
        ;   printsegoverrides?:near
        ;
        ;   should we print segment overrides?
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=No
        ;           cf=0=Yes=al[2:0]=segment override equate (dm_segXX)
        ;   registers: al
        ;
proc    printsegoverrides? near
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.mem.segoverride
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_segoverride
        jnz     short @@666
        shr     al,04h
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      short @@10              ;if it's only a displacement
        testflag (dis_input_t ptr __dis_gs:si).flags,df_memsegoverride
        jmp     short @@20
@@10:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_dsdispl
@@20:
        jz      short @@cmc
@@666:
        retn
@@cmc:
        cmc
        retn
endp    printsegoverrides?

        ;
        ;   printsegoverrides:near
        ;
        ;   print segment overrides
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the last character we printed
        ;   registers: ax,di
        ;
proc    printsegoverrides near
        call    near ptr printsegoverrides?
        jc      short printsegoverridesretn
        push    bx
        and     ax,0007h
        xchg    bx,ax
        add     bx,bx
        mov     bx,[bx+segregs]
        call    near ptr copyregstring
        pop     bx
        mov     al,':'
        stosb
printsegoverridesretn:
        retn
endp    printsegoverrides

        ;
        ;   printdisplacement:near
        ;
        ;   print a displacement
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the displacement printed
        ;   registers: eax,cx,di
        ;
proc    printdisplacement near
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.mem.__flags
        call    near ptr convertdop_sizeequ
        and     al,03h
        cmp     al,dop_sizedword
        mov     eax,(dis_operand_t ptr __dis_gs:bx).ops.mem.displ
        je      short @@dontsignextend
        cwde
@@dontsignextend:
        test    eax,eax
        jnz     short @@notzero
        testflag (dis_input_t ptr __dis_gs:si).flags,df_nozerodispl
        jnz     short @@666
@@notzero:
        push    bx
        mov     bl,signed or showsign
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jz      short @@notatt
        mov     bl,signed               ;"+0x12(%ebx)" -> "0x12(%ebx)"
@@notatt:
        call    near ptr printnumber
        pop     bx
@@666:
        retn
endp    printdisplacement

        ;
        ;   dis_mem:near
        ;
        ;   print a memory operand
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed in it
        ;   registers:
        ;
proc    dis_mem near
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jnz     short @@10              ;jmp if it's not just a displacement
        testflag (dis_input_t ptr __dis_gs:si).flags,df_nobracketsdispl
        jmp     short @@jnzshortnobrackets
@@10:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_nobracketsmem
@@jnzshortnobrackets:
        jnz     short @@nobrackets
        testflag (dis_input_t ptr __dis_gs:si).flags,df_seginsidebrack
        setnz   al
        testflag (dis_input_t ptr __dis_gs:si).flags,df_ptrinsidebrack
        jz      short @@20
        add     al,02h
@@20:
        cmp     al,01h
        jb      short @@alzero
        je      short @@alone
        cmp     al,02h
        je      short @@altwo

@@althree:      ;al=3=  push    [word ptr small es:mem]
        mov     al,'['
        stosb
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
        jmp     short @@printmemandendbracket

@@alzero:       ;al=0=  push    word ptr es:[small mem]
        call    near ptr @@printptrstring
        call    near ptr printsegoverrides
        mov     al,'['
        stosb
        call    near ptr printsmallorlarge
        jmp     short @@printmemandendbracket

@@alone:        ;al=1=  push    word ptr [small es:mem]
        call    near ptr @@printptrstring
        mov     al,'['
        stosb
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
        jmp     short @@printmemandendbracket

@@altwo:        ;al=2=  push    es:[word ptr small mem]
        call    near ptr printsegoverrides
        mov     al,'['
        stosb
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
@@printmemandendbracket:
        call    near ptr @@dismem_printmemory
        mov     al,']'
        stosb
@@__retn:
        retn
@@dismem_printmemory_onlydispl:
dis_memonlydisplacement:
        checkoperand
        jnc     short @@__retn
        mov     al,(dis_operand_t ptr __dis_gs:bx).ops.mem.__flags
        call    near ptr convertdop_sizeequ
        mov     eax,(dis_operand_t ptr __dis_gs:bx).ops.mem.displ
        jmp     xorblblprintnumber
@@nobrackets:
        ;print: push    word ptr small es:mem
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
@@dismem_printmemory:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      short @@dismem_printmemory_onlydispl
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasbase
        jz      short @@dismem_printmemory_nobase
        call    near ptr printbaseregister
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasindex
        jz      short @@dismem_printmemory_noindex
        mov     al,'+'
        stosb
@@dismem_printmemory_nobase:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasindex
        jz      short @@dismem_printmemory_noindex
        call    near ptr printindexregister
@@dismem_printmemory_noindex:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasscale
        jz      short @@dismem_printmemory_noscale
        mov     cl,(dis_operand_t ptr __dis_gs:bx).ops.mem.scale
        test    cl,cl
        jnz     short @@scalene0
        testflag (dis_input_t ptr __dis_gs:si).flags,df_usescale1
        jz      short @@dismem_printmemory_noscale
@@scalene0:
        mov     ax,0100h
        shl     ah,cl
        xor     ax,'0*'
        stosw
@@dismem_printmemory_noscale:
        testflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasdispl
        jz      short @@dismemretn
        mov     al,'+'
        stosb
        checkoperand
        jnc     short @@dismemretn
        dec     di
        jmp     printdisplacement
@@dismemretn:
        retn

@@printptrstring:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_nomemsize
        jnz     short @@dismemretn
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_showmemsize
        jnz     short printptrstring
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_dontshowmemsize
        jnz     short @@dismemretn
        testflag (dis_input_t ptr __dis_gs:si).flags,df_showsizemem
        jnz     short printptrstring
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_hassegreg
        jz      short @@printptrstring10
        testflag (dis_input_t ptr __dis_gs:si).flags,df_showsegmemsize
        jnz     short printptrstring
        mov     cl,(dis_input_t ptr __dis_gs:si).__dis_input.codesize
        cmp     (dis_input_t ptr __dis_gs:si).__dis_input.opcode.opsize,cl ;66h?
        jne     short printptrstring    ;yes
@@printptrstring10:
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_hasreg
        jnz     short @@dismemretn
printptrstring:
        push    bx
        movzx   bx,(dis_operand_t ptr __dis_gs:bx).size
        add     bx,bx
        mov     bx,[bx+sizestrings]
        call    near ptr copyptrstringandspaceandprintptr
        pop     bx
        retn
endp    dis_mem

copyptrstringandspaceandprintptr:
        call    near ptr copyptrstringandspace

        ;
        ;   printptrandspace:near
        ;
        ;   print 'ptr '
        ;
        ;   input: es:di string
        ;          __dis_gs:si dis_input_t struc
        ;   output: es:di after the space
        ;   registers: ax,bx,di
        ;
proc    printptrandspace near
        testflag (dis_input_t ptr __dis_gs:si).flags,df_noptr
        jnz     short @@666
        mov     bx,offset @ptr
copyptrstringandspace:
        call    near ptr copyptrstring
printspace:
        mov     al,20h
        stosb
@@666:
        retn
endp    printptrandspace

        ;
        ;   printsmallorlarge:near
        ;
        ;   print small or large in a string
        ;
        ;   input: __dis_gs:bx dis_operand_t struc
        ;          es:di string
        ;   output: es:di after the stuff we printed
        ;   registers: al,di
        ;
proc    printsmallorlarge near
        push    bx
        mov     al,byte ptr (dis_operand_t ptr __dis_gs:bx).flags
        test    al,dop_small
        mov     bx,offset @small
        jnz     short @@10
        test    al,dop_large
        jz      short @@666
        mov     bx,offset @large
@@10:
        call    near ptr copyptrstringandspace
@@666:
        pop     bx
        retn
endp    printsmallorlarge

        ;
        ;   copyregstring:near
        ;
        ;   copy a register string 'eax','ecx','es',etc
        ;
        ;   input: ds:bx source string
        ;          es:di dest string
        ;   output: es:di advanced past the last character
        ;           al  zero
        ;   registers: ax,bx,di
        ;
proc    copyregstring near
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jz      short @@notatt
        mov     al,'%'
        stosb
@@notatt:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_uppercasereg
        jmp     short copystring
endp    copyregstring

        ;
        ;   copyptrstring:near
        ;
        ;   copy a 'byte','word','ptr',etc string
        ;
        ;   input: ds:bx source string
        ;          es:di dest string
        ;   output: es:di advanced past the last character
        ;           al  zero
        ;   registers: ax,bx,di
        ;
proc    copyptrstring near
        testflag (dis_input_t ptr __dis_gs:si).flags,df_uppercaseptr
        jmp     short copystring
endp    copyptrstring

        ;
        ;   copyopname:near
        ;
        ;   copy the mnemonic name to a string (might uppercase it)
        ;
        ;   input: ds:bx name of the mnemonic
        ;          es:di string to put the result
        ;   output: es:di advanced past the last character (might be uppercased)
        ;           al  zero
        ;   registers: ax,bx,di
        ;
proc    copyopname near
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jnz     short copyopnameatt
        testflag (dis_input_t ptr __dis_gs:si).flags,df_uppercasemnemonic
endp    copyopname

        ;
        ;   copystring:near
        ;
        ;   copy a string and uppercase it if zf=0
        ;
        ;   input: ds:bx source string
        ;          es:di dest string
        ;          zf=1=don't change the string (AND it with FF)
        ;          zf=0=change the string (AND it with NOT 20h)
        ;   output: es:di advanced past the last character
        ;           al  zero
        ;   registers: ax,bx,di
        ;
proc    copystring near
        assume  es:nothing,cs:@code,ss:@stack,ds:nothing,fs:nothing,gs:nothing
        mov     ah,0FFh
        jz      short @@loop
        mov     ah,not 20h
@@loop:
        mov     al,[bx]
        inc     bx
        cmp     al,'a'
        jb      short @@10
        ;There're only characters or ascii numbers in the strings. '9' < 'a'
;        cmp     al,'z'
;        ja      short @@10
        and     al,ah
@@10:
        stosb
        test    al,al
        jnz     short @@loop
        dec     di
        retn
endp    copystring

        ;
        ;   copyopnameatt:near
        ;
        ;   copy the mnemonic name to a string (might uppercase it) (at&t)
        ;
        ;   input: ds:bx name of the mnemonic
        ;          es:di string to put the result
        ;   output: es:di advanced past the last character (might be uppercased)
        ;           al  zero
        ;   registers: ax,bx,di
        ;
proc    copyopnameatt near
attsizebyte     equ     01h             ;Add a 'b'
attsizeworddword equ    02h             ;Add a 'w' or 'l' (depends on opsize)
attdontshowsizeworddword equ 03h        ;attsizeworddword if 66h prefix
attshowsizeworddword equ 04h            ;attsizeworddword (always a 'w' or 'l')
attstringsize   equ     05h             ;all strings (b/w/l always)
attmaxspecial   equ     05h
        testflag (dis_input_t ptr __dis_gs:si).flags,df_uppercasemnemonic
        mov     ah,0FFh
        jz      short @@loop
        mov     ah,not 20h
@@loop:
        mov     al,[bx]
        inc     bx
        cmp     al,attmaxspecial
        jbe     short @@checkit
@@printchar:
        cmp     al,'a'
        jb      short @@10
        ;There're only characters or ascii numbers in the strings. '9' < 'a'
;        cmp     al,'z'
;        ja      short @@10
        and     al,ah
@@10:
        stosb
        test    al,al
        jnz     short @@loop
        dec     di
        retn
@@checkit:
        cmp     al,attsizebyte
        je      short @@attsizebyte
        cmp     al,attsizeworddword
        je      short @@attsizeworddword
        cmp     al,attdontshowsizeworddword
        je      short @@attdontshowsizeworddword
        cmp     al,attshowsizeworddword
        je      short @@attshowsizeworddword
        cmp     al,attstringsize
        jne     short @@printchar
@@attstringsize:
        call    near ptr @@getstringchar
        jmp     short @@printchar
@@attshowsizeworddword:
        call    near ptr @@worl
        jmp     short @@printchar
@@attdontshowsizeworddword:     ;print 'w' or 'l' if no 66h prefix
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.prefixes,__dis_opprefix
        jz      short @@loop
@@attsizeworddword:             ;print 'w' or 'l' (depending on operand size)
        call    near ptr @@worl
@@printchar?:
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_showmemsize
        jnz     short @@printchar       ;shrb %cl,(%esp) (or similar)
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_dontshowmemsize
        jnz     short @@loop
        testflag (dis_input_t ptr __dis_gs:si).__dis_input.opcode.flags,do_hasreg
        jz      short @@printchar
        testflag (dis_input_t ptr __dis_gs:si).flags,df_noopnamesizeatt
        jz      short @@printchar
        jmp     short @@loop
@@attsizebyte:                  ;print 'b'
        mov     al,'b'
        jmp     short @@printchar?
@@worl:
        mov     al,'w'
        cmp     (dis_input_t ptr __dis_gs:si).__dis_input.opcode.opsize,10h
        je      short @@worl666
        mov     al,'l'
@@worl666:
        retn
@@getstringchar:
        mov     al,byte ptr (dis_input_t ptr __dis_gs:si).__dis_input.opcode.op1.flags
        and     al,dop_typemask
if dop_mem ne 0
        cmp     al,dop_mem
endif
        mov     al,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op1.size
        je      short @@getstringchar10
        mov     al,(dis_input_t ptr __dis_gs:si).__dis_input.opcode.op2.size
@@getstringchar10:
        cmp     al,01h
        mov     al,'b'
        jb      short @@getstringchar666
        mov     al,'w'
        je      short @@getstringchar666
        mov     al,'l'
@@getstringchar666:
        retn
endp    copyopnameatt

        ;
        ;   dis_changenumberbase:procptr
        ;
        ;   change the number base
        ;
        ;   input: __dis_gs:si dis_input_t struc
        ;          bh   new number base (02h-FFh)
        ;   output: none
        ;   registers: none
        ;
ifdef Clib
proc    _dis_changenumberbase procptr
        public  _dis_changenumberbase
else
proc    dis_changenumberbase procptr
endif
ifdef Clib
        arg     dis_input:dataptr,nbase:byte:2
        push    bp
        mov     bp,sp
        push    si
  if @datasize
        lgs     si,dis_input
  else
        mov     si,dis_input
  endif
        mov     bh,nbase
if @datasize eq 2
  if 0  ;this proc never read/write any global variables
        push    @data
        pop     ds
        assume  ds:@data
  endif
endif
endif
        mov     (dis_input_t ptr __dis_gs:si).numberbase,bh
ifndef Clib
        push    eax edx
endif
        or      eax,0FFFFFFFFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:si).maxdigitsdword,al
        or      ax,0FFFFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:si).maxdigitsword,al
        or      al,0FFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:si).maxdigitsbyte,al
ifdef Clib
        pop     si bp
else
        pop     edx eax
endif
        ret
ifdef Clib
endp    _dis_changenumberbase
else
endp    dis_changenumberbase
endif

        ;
        ;   getmaxdigits:near
        ;
        ;   get max # of digits in an unsigned number base in a byte/word/dword
        ;
        ;   input: eax  FFh=byte,FFFFh=word,FFFFFFFFh=dword
        ;          bh   number base
        ;   output: eax max # of digits
        ;           edx msd (in=eax=1234h,out=edx=1h)
        ;   registers: eax,edx
        ;
proc    getmaxdigits near
        push    cx ebx
        xor     cx,cx
        movzx   ebx,bh
        db      66h
@@loop:
        xor     dx,dx
        div     ebx
        inc     cx
        test    eax,eax
        jnz     short @@loop
        xchg    cx,ax
        pop     ebx cx
        retn
endp    getmaxdigits

        ;
        ;   printnumber:near
        ;
        ;   print a number in a string
        ;
        ;   input: eax  # to convert to ascii (sign/zero extended)
        ;          ch   type of number to print (byte=1,word=2,dword=4)
        ;          bl   flags (for ntoa:proc) (bighex shouldn't be set!)
        ;          _es:di string
        ;   output: di  asciiz string (after the number we printed)
        ;   registers: eax,cx,edx,bx
        ;
proc    printnumber near
        assume  es:@data,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        mov     bh,(dis_input_t ptr __dis_gs:si).numberbase
        testflag (dis_input_t ptr __dis_gs:si).flags,df_fewdigits
        jz      short @@15
        push    eax
        test    bl,signed
        jz      short @@12
        test    eax,eax
        jns     short @@12
        neg     eax
@@12:
        call    near ptr getmaxdigits
        xchg    cx,ax
        pop     eax
        jmp     short @@20
@@15:
        mov     cl,(dis_input_t ptr __dis_gs:si).maxdigitsbyte
        cmp     ch,02h
        jb      short @@20
        mov     cl,(dis_input_t ptr __dis_gs:si).maxdigitsword
        je      short @@20
        mov     cl,(dis_input_t ptr __dis_gs:si).maxdigitsdword
@@20:
        xor     ch,ch                   ;cx=# of digits to print in es:di
        testflag (dis_input_t ptr __dis_gs:si).flags,df_msd0always
        jnz     short @@yesmsd0
        testflag (dis_input_t ptr __dis_gs:si).flags,df_msd0
        jz      short @@nomsd0
        test    bl,signed
        jnz     short @@nomsd0          ;a signed # can't have a char as msd
        push    eax                     ; (it can if base is much > 10h...)
        call    near ptr getmaxdigits
        cmp     al,cl
        pop     eax
        jne     short @@nomsd0
        cmp     dx,0009h                ;is msd a digit-character?
        jbe     short @@nomsd0
@@yesmsd0:
        inc     cx
@@nomsd0:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_lowercasedigitchar
        jnz     short @@40
        or      bl,bighex
@@40:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_Cnumbers
        jz      short @@50
        testflag (dis_input_t ptr __dis_gs:si).flags,df_usebasechar
        jz      short @@50
        test    bl,signed or showsign
        jz      short @@Cnothing
        mov     dx,('-' shl 8) or '+'
        test    bl,showsign
        jnz     short @@Cshowsign
        xor     dl,dl                   ;mov     dx,'-' shl 8
@@Cshowsign:
        test    eax,eax
        jns     short @@Cok
        neg     eax
        mov     dl,dh
@@Cok:
        test    dl,dl
        jz      short @@maskit
        mov     _es:[di],dl
        inc     di
@@maskit:
        and     bl,not (signed or showsign)
@@Cnothing:
        push    ax
        mov     al,'x'
        call    near ptr @@getbasechar
        jc      short @@dontstosb
        mov     ah,al
        mov     al,'0'
        stosb
        cmp     bh,10o
        je      short @@dontstosb
        mov     al,ah
        stosb
@@dontstosb:
        pop     ax
@@50:
        push    eax
        call    ntoa
        pop     eax
        add     di,cx
        testflag (dis_input_t ptr __dis_gs:si).flags,df_usebasechar
        jnz     short @@usebasechar
        testflag (dis_input_t ptr __dis_gs:si).flags,df_attsyntax
        jnz     short @@666
        testflag (dis_input_t ptr __dis_gs:si).flags,df_basecharifneeded
        jz      short @@666
        cmp     bh,0Ah                  ;base must be > 10 or it can't be a char
        jbe     short @@666
        push    ebx
        test    bl,signed
        movzx   ebx,bh
        jz      short @@42
        cdq
        idiv    ebx
        test    dx,dx
        jns     short @@45
        neg     dx
        jmp     short @@45
@@42:
        xor     edx,edx
        div     ebx
@@45:
        xchg    dx,ax
        pop     ebx
        cmp     al,0Bh
        je      short @@usebasechar
        cmp     al,0Dh
        jne     short @@666
@@usebasechar:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_Cnumbers
        jnz     short @@666
        mov     al,'h'
        call    near ptr @@getbasechar
        jc      short @@666
        xor     ah,ah
        mov     _es:[di],ax
        inc     di
@@666:
        retn
@@getbasechar:
        cmp     bh,10h
        je      short @@yes
        mov     al,'d'
        cmp     bh,10d
        je      short @@yes
        mov     al,(dis_input_t ptr __dis_gs:si).octalbasechar
        cmp     bh,10o
        je      short @@yes
        cmp     bh,10b
        jne     short @@no
        mov     al,'b'
@@yes:
        testflag (dis_input_t ptr __dis_gs:si).flags,df_uppercasebasechar
        jz      short @@yes10
        and     al,not 20h
@@yes10:
        retn
@@no:
        stc
        retn
endp    printnumber
        endcode

        startconst
        align   word
label   opnames1 word
  dw    @add,@add,@add,@add,@add,@add,@push,@pop                ;00
  dw    @or,@or,@or,@or,@or,@or,@push,@db                       ;08
  dw    @adc,@adc,@adc,@adc,@adc,@adc,@push,@pop                ;10
  dw    @sbb,@sbb,@sbb,@sbb,@sbb,@sbb,@push,@pop                ;18
  dw    @and,@and,@and,@and,@and,@and,@seges,@daa               ;20
  dw    @sub,@sub,@sub,@sub,@sub,@sub,@segcs,@das               ;28
  dw    @xor,@xor,@xor,@xor,@xor,@xor,@segss,@aaa               ;30
  dw    @cmp,@cmp,@cmp,@cmp,@cmp,@cmp,@segds,@aas               ;38
  dw    @inc,@inc,@inc,@inc,@inc,@inc,@inc,@inc                 ;40
  dw    @dec,@dec,@dec,@dec,@dec,@dec,@dec,@dec                 ;48
  dw    @push,@push,@push,@push,@push,@push,@push,@push         ;50
  dw    @pop,@pop,@pop,@pop,@pop,@pop,@pop,@pop                 ;58
  dw    @pusha,@popa,@bound,@arpl,@segfs,@seggs,@db,@db         ;60
  dw    @push,@imul,@push,@imul,@insb,@insw,@outsb,@outsw       ;68
  dw    @jo,@jno,@jb,@jae,@je,@jne,@jbe,@ja                     ;70
  dw    @js,@jns,@jp,@jnp,@jl,@jge,@jle,@jg                     ;78
  dw    @db,@db,@db,@db,@test,@test,@xchg,@xchg                 ;80
  dw    @mov,@mov,@mov,@mov,@mov,@lea,@mov,@pop                 ;88
  dw    @nop,@xchg,@xchg,@xchg,@xchg,@xchg,@xchg,@xchg          ;90
  dw    @cbw,@cwd,@call,@wait,@pushf,@popf,@sahf,@lahf          ;98
  dw    @mov,@mov,@mov,@mov,@movsb,@movsw,@cmpsb,@cmpsw         ;A0
  dw    @test,@test,@stosb,@stosw,@lodsb,@lodsw,@scasb,@scasw   ;A8
  dw    @mov,@mov,@mov,@mov,@mov,@mov,@mov,@mov                 ;B0
  dw    @mov,@mov,@mov,@mov,@mov,@mov,@mov,@mov                 ;B8
  dw    @db,@db,@retn,@retn,@les,@lds,@mov,@mov                 ;C0
  dw    @enter,@leave,@retf,@retf,@int,@int,@into,@iret         ;C8
  dw    @db,@db,@db,@db,@aam,@aad,@salc,@xlatb                  ;D0
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;D8
  dw    @loopne,@loope,@loop,@jcxz,@in,@in,@out,@out            ;E0
  dw    @call,@jmp,@jmp,@jmp,@in,@in,@out,@out                  ;E8
  dw    @lock,@int01,@repne,@rep,@hlt,@cmc,@db,@db              ;F0
  dw    @clc,@stc,@cli,@sti,@cld,@std,@db,@db                   ;F8
label   opnames2 word
  dw    @db,@db,@lar,@lsl,@loadall,@loadall,@clts,@loadall      ;00
  dw    @invd,@wbinvd,@db,@ud2,@db,@db,@db,@db                  ;08
  dw    @umov,@umov,@umov,@umov,@db,@db,@db,@db                 ;10
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;18
  dw    @mov,@mov,@mov,@mov,@mov,@db,@mov,@db                   ;20
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;28
  dw    @wrmsr,@rdtsc,@rdmsr,@rdpmc,@sysenter,@sysexit,@db,@db  ;30
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;38
  dw    @cmovo,@cmovno,@cmovb,@cmovae,@cmove,@cmovne,@cmovbe,@cmova ;40
  dw    @cmovs,@cmovns,@cmovp,@cmovnp,@cmovl,@cmovge,@cmovle,@cmovg ;48
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;50
  dw    @db,@db,@db,@db,@db,@db,@db,@db                         ;58
  dw    @punpcklbw,@punpcklwd,@punpckldq,@packsswb,@pcmpgtb,@pcmpgtw,@pcmpgtd,@packuswb ;60
  dw    @punpckhbw,@punpckhwd,@punpckhdq,@packssdw,@db,@db,@movd,@movq ;68
  dw    @db,@db,@db,@db,@pcmpeqb,@pcmpeqw,@pcmpeqd,@emms        ;70
  dw    @db,@db,@db,@db,@db,@db,@movd,@movq                     ;78
  dw    @jo,@jno,@jb,@jae,@je,@jne,@jbe,@ja                     ;80
  dw    @js,@jns,@jp,@jnp,@jl,@jge,@jle,@jg                     ;88
  dw    @seto,@setno,@setb,@setae,@sete,@setne,@setbe,@seta     ;90
  dw    @sets,@setns,@setp,@setnp,@setl,@setge,@setle,@setg     ;98
  dw    @push,@pop,@cpuid,@bt,@shld,@shld,@db,@db               ;A0
  dw    @push,@pop,@rsm,@bts,@shrd,@shrd,@db,@imul              ;A8
  dw    @cmpxchg,@cmpxchg,@lss,@btr,@lfs,@lgs,@movzx,@movzx     ;B0
  dw    @db,@ud,@db,@btc,@bsf,@bsr,@movsx,@movsx                ;B8
  dw    @xadd,@xadd,@db,@db,@db,@db,@db,@db                     ;C0
  dw    @bswap,@bswap,@bswap,@bswap,@bswap,@bswap,@bswap,@bswap ;C8
  dw    @db,@psrlw,@psrld,@psrlq,@db,@pmullw,@db,@db            ;D0
  dw    @psubusb,@psubusw,@db,@pand,@paddusb,@paddusw,@db,@pandn;D8
  dw    @db,@psraw,@psrad,@db,@db,@pmulhw,@db,@db               ;E0
  dw    @psubsb,@psubsw,@db,@por,@paddsb,@paddsw,@db,@pxor      ;E8
  dw    @db,@psllw,@pslld,@psllq,@db,@pmaddwd,@db,@db           ;F0
  dw    @psubb,@psubw,@psubd,@db,@paddb,@paddw,@paddd,@db       ;F8
label   amdk3dopcodes word
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;00
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pi2fd,@k3d?,@k3d?        ;08
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;10
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pf2id,@k3d?,@k3d?        ;18
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;20
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;28
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;30
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;38
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;40
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;48
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;50
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;58
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;60
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;68
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;70
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;78
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;80
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;88
  dw    @pfcmpge,@k3d?,@k3d?,@k3d?,@pfmin,@k3d?,@pfrcp,@pfrsqrt ;90
  dw    @k3d?,@k3d?,@pfsub,@k3d?,@k3d?,@k3d?,@pfadd,@k3d?       ;98
  dw    @pfcmpgt,@k3d?,@k3d?,@k3d?,@pfmax,@k3d?,@pfrcpit1,@pfrsqit1 ;A0
  dw    @k3d?,@k3d?,@pfsubr,@k3d?,@k3d?,@k3d?,@pfacc,@k3d?      ;A8
  dw    @pfcmpeq,@k3d?,@k3d?,@k3d?,@pfmul,@k3d?,@pfrcpit2,@pmulhrw ;B0
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pavgusb      ;B8
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;C0
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;C8
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;D0
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;D8
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;E0
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;E8
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;F0
  dw    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;F8
label   grp1EvIv word
label   grp1EbIbB word
label   grp1EvIb word
grp1EbIbA       dw      @add,@or,@adc,@sbb,@and,@sub,@xor,@cmp
label   grp2EvIb word
label   grp2Eb1 word
label   grp2Ev1 word
label   grp2EbCL word
label   grp2EvCL word
grp2EbIb        dw      @rol,@ror,@rcl,@rcr,@shl,@shr,@shl,@sar
label   grp3Ev word
grp3Eb          dw      @test,@test,@not,@neg,@mul,@imul,@div,@idiv
grp4            dw      @inc,@dec,@db,@db,@db,@db,@db,@db
grp5            dw      @inc,@dec,@call,@call,@jmp,@jmp,@push,@db
grp6            dw      @sldt,@str,@lldt,@ltr,@verr,@verw,@db,@db
grp7            dw      @sgdt,@sidt,@lgdt,@lidt,@smsw,@db,@lmsw,@invlpg
grp8            dw      @db,@db,@db,@db,@bt,@bts,@btr,@btc
grp9            dw      @db,@cmpxchg8b,@db,@db,@db,@db,@db,@db
grpA0F71        dw      @db,@db,@psrlw,@db,@psraw,@db,@psllw,@db
grpA0F72        dw      @db,@db,@psrld,@db,@psrad,@db,@pslld,@db
grpA0F73        dw      @db,@db,@psrlq,@db,@db,@db,@psllq,@db
label   grpBatt word
grpB            dw      @fxsave,@fxrstor,@db,@db,@db,@db,@db,@db
label   special word
  dw    @db
  dw    @enterd
  dw    @enterw
  dw    @enter
  dw    @sgdtd
  dw    @sgdtw
  dw    @sgdt
  dw    @sidtd
  dw    @sidtw
  dw    @sidt
  dw    @lgdtd
  dw    @lgdtw
  dw    @lgdt
  dw    @lidtd
  dw    @lidtw
  dw    @lidt
  dw    @loopdne
  dw    @loopwne
  dw    @loopne
  dw    @loopde
  dw    @loopwe
  dw    @loope
  dw    @loopd
  dw    @loopw
  dw    @loop
  dw    @jcxz
  dw    @jecxz
  dw    @cbw
  dw    @cwde
  dw    @cwd
  dw    @cdq
  dw    @pushad
  dw    @pushaw
  dw    @pusha
  dw    @popad
  dw    @popaw
  dw    @popa
  dw    @pushfd
  dw    @pushfw
  dw    @pushf
  dw    @popfd
  dw    @popfw
  dw    @popf
  dw    @leaved
  dw    @leavew
  dw    @leave
  dw    @iretd
  dw    @iretw
  dw    @iret
  dw    @retnd
  dw    @retnw
  dw    @retn
  dw    @retfd
  dw    @retfw
  dw    @retf
  dw    @xlat
  dw    @xlatb
  dw    @ins
  dw    @insb
  dw    @insw
  dw    @insd
  dw    @outs
  dw    @outsb
  dw    @outsw
  dw    @outsd
  dw    @scas
  dw    @scasb
  dw    @scasw
  dw    @scasd
  dw    @stos
  dw    @stosb
  dw    @stosw
  dw    @stosd
  dw    @lods
  dw    @lodsb
  dw    @lodsw
  dw    @lodsd
  dw    @cmps
  dw    @cmpsb
  dw    @cmpsw
  dw    @cmpsd
  dw    @movs
  dw    @movsb
  dw    @movsw
  dw    @movsd
  dw    @esc
  dw    @xchg
label   floatDCreg word
floatD8reg      dw      @fadd,@fmul,@fcom,@fcomp,@fsub,@fsubr,@fdiv,@fdivr
floatD9reg      dw      @fld,@esc,@fst,@fstp,@fldenv,@fldcw,@fnstenv,@fnstcw
label   floatDEreg word
label   floatDEregatt word
floatDAreg      dw      @fiadd,@fimul,@ficom,@ficomp,@fisub,@fisubr,@fidiv,@fidivr
floatDBreg      dw      @fild,@esc,@fist,@fistp,@esc,@fld,@esc,@fstp
floatDDreg      dw      @fld,@esc,@fst,@fstp,@frstor,@esc,@fnsave,@fnstsw
floatDFreg      dw      @fild,@esc,@fist,@fistp,@fbld,@fild,@fbstp,@fistp
label   floatD8 word
  dw    @fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd                 ;C0
  dw    @fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul                 ;C8
  dw    @fcom,@fcom,@fcom,@fcom,@fcom,@fcom,@fcom,@fcom                 ;D0
  dw    @fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp         ;D8
  dw    @fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub                 ;E0
  dw    @fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr         ;E8
  dw    @fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv                 ;F0
  dw    @fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr         ;F8
label   floatD9 word
  dw    @fld,@fld,@fld,@fld,@fld,@fld,@fld,@fld                         ;C0
  dw    @fxch,@fxch,@fxch,@fxch,@fxch,@fxch,@fxch,@fxch                 ;C8
  dw    @fnop,@esc,@esc,@esc,@esc,@esc,@esc,@esc                        ;D0
  dw    @fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1         ;D8
  dw    @fchs,@fabs,@esc,@esc,@ftst,@fxam,@esc,@esc                     ;E0
  dw    @fld1,@fldl2t,@fldl2e,@fldpi,@fldlg2,@fldln2,@fldz,@esc         ;E8
  dw    @f2xm1,@fyl2x,@fptan,@fpatan,@fxtract,@fprem1,@fdecstp,@fincstp ;F0
  dw    @fprem,@fyl2xp1,@fsqrt,@fsincos,@frndint,@fscale,@fsin,@fcos    ;F8
label   floatDA word
  dw    @fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb ;C0
  dw    @fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove ;C8
  dw    @fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe ;D0
  dw    @fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu ;D8
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;E0
  dw    @esc,@fucompp,@esc,@esc,@esc,@esc,@esc,@esc                     ;E8
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F0
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDB word
  dw    @fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb ;C0
  dw    @fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne ;C8
  dw    @fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe ;D0
  dw    @fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu ;D8
  dw    @fneni,@fndisi,@fnclex,@fninit,@fnsetpm,@fnrstpm,@esc,@esc      ;E0
  dw    @fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi ;E8
  dw    @fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi         ;F0
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDC word
  dw    @fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd                 ;C0
  dw    @fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul                 ;C8
  dw    @fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2         ;D0
  dw    @fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3 ;D8
  dw    @fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub                 ;E0
  dw    @fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr         ;E8
  dw    @fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv                 ;F0
  dw    @fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr         ;F8
label   floatDD word
  dw    @ffree,@ffree,@ffree,@ffree,@ffree,@ffree,@ffree,@ffree         ;C0
  dw    @fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4         ;C8
  dw    @fst,@fst,@fst,@fst,@fst,@fst,@fst,@fst                         ;D0
  dw    @fstp,@fstp,@fstp,@fstp,@fstp,@fstp,@fstp,@fstp                 ;D8
  dw    @fucom,@fucom,@fucom,@fucom,@fucom,@fucom,@fucom,@fucom         ;E0
  dw    @fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp ;E8
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F0
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDE word
  dw    @faddp,@faddp,@faddp,@faddp,@faddp,@faddp,@faddp,@faddp         ;C0
  dw    @fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp         ;C8
  dw    @fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5 ;D0
  dw    @esc,@fcompp,@esc,@esc,@esc,@esc,@esc,@esc                      ;D8
  dw    @fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp ;E0
  dw    @fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp         ;E8
  dw    @fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp ;F0
  dw    @fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp         ;F8
label   floatDF word
  dw    @fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep ;C0
  dw    @fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7         ;C8
  dw    @fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8         ;D0
  dw    @fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9         ;D8
  dw    @fnstsw,@fnstdw,@fnstsg,@esc,@esc,@esc,@esc,@esc                ;E0
  dw    @fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip ;E8
  dw    @fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip ;F0
  dw    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   opnames1att word
  dw    @addb,@addv,@addb,@addv,@addb,@addv,@pushv,@popv        ;00
  dw    @orb,@orv,@orb,@orv,@orb,@orv,@pushv,@dbatt             ;08
  dw    @adcb,@adcv,@adcb,@adcv,@adcb,@adcv,@pushv,@popv        ;10
  dw    @sbbb,@sbbv,@sbbb,@sbbv,@sbbb,@sbbv,@pushv,@popv        ;18
  dw    @andb,@andv,@andb,@andv,@andb,@andv,@es,@daa            ;20
  dw    @subb,@subv,@subb,@subv,@subb,@subv,@cs,@das            ;28
  dw    @xorb,@xorv,@xorb,@xorv,@xorb,@xorv,@ss,@aaa            ;30
  dw    @cmpb,@cmpv,@cmpb,@cmpv,@cmpb,@cmpv,@ds,@aas            ;38
  dw    @incv,@incv,@incv,@incv,@incv,@incv,@incv,@incv         ;40
  dw    @decv,@decv,@decv,@decv,@decv,@decv,@decv,@decv         ;48
  dw    @pushv,@pushv,@pushv,@pushv,@pushv,@pushv,@pushv,@pushv ;50
  dw    @popv,@popv,@popv,@popv,@popv,@popv,@popv,@popv         ;58
  dw    @pusha,@popa,@boundv,@arplv,@fs,@gs,@dbatt,@dbatt       ;60
  dw    @pushv,@imulv,@pushv,@imulv,@insb,@insw,@outsb,@outsw   ;68
  dw    @jov,@jnov,@jbv,@jaev,@jev,@jnev,@jbev,@jav             ;70
  dw    @jsv,@jnsv,@jpv,@jnpv,@jlv,@jgev,@jlev,@jgv             ;78
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@testb,@testv,@xchgb,@xchgv ;80
  dw    @movb,@movv,@movb,@movv,@movv,@leav,@movv,@popv         ;88
  dw    @nop,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv   ;90
  dw    @cbw,@cwd,@lcallv,@wait,@pushf,@popf,@sahf,@lahf        ;98
  dw    @movb,@movv,@movb,@movv,@movsb,@movsw,@cmpsb,@cmpsw     ;A0
  dw    @testb,@testv,@stosb,@stosw,@lodsb,@lodsw,@scasb,@scasw ;A8
  dw    @movb,@movb,@movb,@movb,@movb,@movb,@movb,@movb         ;B0
  dw    @movv,@movv,@movv,@movv,@movv,@movv,@movv,@movv         ;B8
  dw    @dbatt,@dbatt,@ret,@ret,@lesv,@ldsv,@movb,@movv         ;C0
  dw    @enter,@leave,@lret,@lret,@int,@int,@into,@iret         ;C8
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@aam,@aad,@salc,@xlatb      ;D0
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt ;D8
  dw    @loopne,@loope,@loop,@jcxz,@inb,@inv,@outb,@outv        ;E0
  dw    @callv,@jmpv,@ljmpv,@jmpv,@inb,@inv,@outb,@outv         ;E8
  dw    @lock,@int01,@repne,@rep,@hlt,@cmc,@dbatt,@dbatt        ;F0
  dw    @clc,@stc,@cli,@sti,@cld,@std,@dbatt,@dbatt             ;F8
label   opnames2att word
  dw    @dbatt,@dbatt,@larv,@lslv,@loadall,@loadall,@clts,@loadall      ;00
  dw    @invd,@wbinvd,@dbatt,@ud2,@dbatt,@dbatt,@dbatt,@dbatt           ;08
  dw    @umovb,@umovv,@umovb,@umovv,@dbatt,@dbatt,@dbatt,@dbatt         ;10
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;18
  dw    @movl,@movl,@movl,@movl,@movl,@dbatt,@movl,@dbatt               ;20
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;28
  dw    @wrmsr,@rdtsc,@rdmsr,@rdpmc,@sysenter,@sysexit,@dbatt,@dbatt    ;30
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;38
  dw    @cmovo,@cmovno,@cmovb,@cmovae,@cmove,@cmovne,@cmovbe,@cmova     ;40
  dw    @cmovs,@cmovns,@cmovp,@cmovnp,@cmovl,@cmovge,@cmovle,@cmovg     ;48
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;50
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;58
  dw    @punpcklbw,@punpcklwd,@punpckldq,@packsswb,@pcmpgtb,@pcmpgtw,@pcmpgtd,@packuswb ;60
  dw    @punpckhbw,@punpckhwd,@punpckhdq,@packssdw,@dbatt,@dbatt,@movd,@movq ;68
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@pcmpeqb,@pcmpeqw,@pcmpeqd,@emms    ;70
  dw    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@movd,@movq           ;78
  dw    @jov,@jnov,@jbv,@jaev,@jev,@jnev,@jbev,@jav                     ;80
  dw    @jsv,@jnsv,@jpv,@jnpv,@jlv,@jgev,@jlev,@jgv                     ;88
  dw    @seto,@setno,@setb,@setae,@sete,@setne,@setbe,@seta             ;90
  dw    @sets,@setns,@setp,@setnp,@setl,@setge,@setle,@setg             ;98
  dw    @pushv,@popv,@cpuid,@btv,@shldv,@shldv,@dbatt,@dbatt            ;A0
  dw    @pushv,@popv,@rsm,@btsv,@shrdv,@shrdv,@dbatt,@imulv             ;A8
  dw    @cmpxchgb,@cmpxchgv,@lssv,@btrv,@lfsv,@lgsv,@movzbv,@movzwv     ;B0
  dw    @dbatt,@ud,@dbatt,@btcv,@bsfv,@bsrv,@movsbv,@movswv             ;B8
  dw    @xaddb,@xaddv,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;C0
  dw    @bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv ;C8
  dw    @dbatt,@psrlw,@psrld,@psrlq,@dbatt,@pmullw,@dbatt,@dbatt        ;D0
  dw    @psubusb,@psubusw,@dbatt,@pand,@paddusb,@paddusw,@dbatt,@pandn  ;D8 *
  dw    @dbatt,@psraw,@psrad,@dbatt,@dbatt,@pmulhw,@dbatt,@dbatt        ;E0
  dw    @psubsb,@psubsw,@dbatt,@por,@paddsb,@paddsw,@dbatt,@pxor        ;E8
  dw    @dbatt,@psllw,@pslld,@psllq,@dbatt,@pmaddwd,@dbatt,@dbatt       ;F0
  dw    @psubb,@psubw,@psubd,@dbatt,@paddb,@paddw,@paddd,@dbatt         ;F8
label   amdspecial word
  dw    @syscall
  dw    @sysret
  dw    @ud
label   amdk3dspecial word
  dw    @prefetch
  dw    @prefetchw
  dw    @prefetch
  dw    @prefetch
  dw    @prefetch
  dw    @prefetch
  dw    @prefetch
  dw    @prefetch
  dw    @femms
label   cyrixspecial word
  dw    @svdc
  dw    @rsdc
  dw    @svldt
  dw    @rsldt
  dw    @svts
  dw    @rsts
  dw    @rdshr
  dw    @wrshr
  dw    @smint
  dw    @paveb
  dw    @paddsiw
  dw    @pmagw
  dw    @pdistib
  dw    @psubsiw
  dw    @pmvzb
  dw    @pmulhrw
  dw    @pmvnzb
  dw    @pmvlzb
  dw    @pmvgezb
  dw    @pmulhriw
  dw    @pmachriw
label   grp1EbIbBatt word
grp1EbIbAatt    dw      @addb,@orb,@adcb,@sbbb,@andb,@subb,@xorb,@cmpb
label   grp1EvIbatt word
grp1EvIvatt     dw      @addv,@orv,@adcv,@sbbv,@andv,@subv,@xorv,@cmpv
label   grp2EbCLatt word
label   grp2Eb1att word
grp2EbIbatt     dw      @rolb,@rorb,@rclb,@rcrb,@shlb,@shrb,@shlb,@sarb
label   grp2EvCLatt word
label   grp2Ev1att word
grp2EvIbatt     dw      @rolv,@rorv,@rclv,@rcrv,@shlv,@shrv,@shlv,@sarv
grp3Ebatt       dw      @testb,@testb,@notb,@negb,@mulb,@imulb,@divb,@idivb
grp3Evatt       dw      @testv,@testv,@notv,@negv,@mulv,@imulv,@divv,@idivv
grp4att         dw      @incb,@decb,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt
grp5att         dw      @incv,@decv,@callv,@lcallv,@jmpv,@ljmpv,@pushv,@dbatt
grp6att         dw      @sldt,@str,@lldt,@ltr,@verrv,@verwv,@dbatt,@dbatt
grp7att         dw      @sgdt,@sidt,@lgdt,@lidt,@smswv,@dbatt,@lmswv,@invlpg
grp8att         dw      @dbatt,@dbatt,@dbatt,@dbatt,@btv,@btsv,@btrv,@btcv
grp9att         dw      @dbatt,@cmpxchg8b,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt
grpA0F71att     dw      @dbatt,@dbatt,@psrlw,@dbatt,@psraw,@dbatt,@psllw,@dbatt
grpA0F72att     dw      @dbatt,@dbatt,@psrld,@dbatt,@psrad,@dbatt,@pslld,@dbatt
grpA0F73att     dw      @dbatt,@dbatt,@psrlq,@dbatt,@dbatt,@dbatt,@psllq,@dbatt
label   specialatt word
  dw    @dbatt
  dw    @enterl
  dw    @enterw
  dw    @enter
  dw    @sgdtl
  dw    @sgdtw
  dw    @sgdt
  dw    @sidtl
  dw    @sidtw
  dw    @sidt
  dw    @lgdtl
  dw    @lgdtw
  dw    @lgdt
  dw    @lidtl
  dw    @lidtw
  dw    @lidt
  dw    @looplnev
  dw    @loopwnev
  dw    @loopnev
  dw    @looplev
  dw    @loopwev
  dw    @loopev
  dw    @looplv
  dw    @loopwv
  dw    @loopv
  dw    @jcxzv
  dw    @jecxzv
  dw    @cbtw
  dw    @cwtl
  dw    @cwtd
  dw    @cltd
  dw    @pushal
  dw    @pushaw
  dw    @pusha
  dw    @popal
  dw    @popaw
  dw    @popa
  dw    @pushfl
  dw    @pushfw
  dw    @pushf
  dw    @popfl
  dw    @popfw
  dw    @popf
  dw    @leavel
  dw    @leavew
  dw    @leave
  dw    @iretl
  dw    @iretw
  dw    @iret
  dw    @retl
  dw    @retw
  dw    @ret
  dw    @lretl
  dw    @lretw
  dw    @lret
  dw    @xlat
  dw    @xlatb
  dw    @insatt
  dw    @insatt
  dw    @insatt
  dw    @insatt
  dw    @outsatt
  dw    @outsatt
  dw    @outsatt
  dw    @outsatt
  dw    @scasatt
  dw    @scasatt
  dw    @scasatt
  dw    @scasatt
  dw    @stosatt
  dw    @stosatt
  dw    @stosatt
  dw    @stosatt
  dw    @lodsatt
  dw    @lodsatt
  dw    @lodsatt
  dw    @lodsatt
  dw    @cmpsatt
  dw    @cmpsatt
  dw    @cmpsatt
  dw    @cmpsatt
  dw    @movsatt
  dw    @movsatt
  dw    @movsatt
  dw    @movsatt
  dw    @esc
floatD8regatt   dw      @fadds,@fmuls,@fcoms,@fcomps,@fsubs,@fsubrs,@fdivs,@fdivrs
floatD9regatt   dw      @flds,@esc,@fsts,@fstps,@fldenv,@fldcw,@fnstenv,@fnstcw
floatDAregatt   dw      @fiaddl,@fimull,@ficoml,@ficompl,@fisubl,@fisubrl,@fidivl,@fidivrl
floatDBregatt   dw      @fildl,@esc,@fistl,@fistpl,@esc,@fldt,@esc,@fstpt
floatDCregatt   dw      @faddl,@fmull,@fcoml,@fcompl,@fsubl,@fsubrl,@fdivl,@fdivrl
floatDDregatt   dw      @fldl,@esc,@fstl,@fstpl,@frstor,@esc,@fnsave,@fnstsw
floatDFregatt   dw      @fild,@esc,@fist,@fistp,@fbld,@fildll,@fbstp,@fistpll

opcodeids       dw      opnames1,opnames2,\
                        grp1EbIbA,grp1EvIv,grp1EbIbB,grp1EvIb,\
                        grp2EbIb,grp2EvIb,grp2Eb1,grp2Ev1,\
                        grp2EbCL,grp2EvCL,grp3Eb,grp3Ev,\
                        grp4,grp5,grp6,grp7,grp8,\
                        grp9,grpA0F71,grpA0F72,grpA0F73,\
                        grpB,\
                        special,\
                        floatD8reg,floatD9reg,\
                        floatDAreg,floatDBreg,\
                        floatDCreg,floatDDreg,\
                        floatDEreg,floatDFreg,\
                        floatD8,floatD9,\
                        floatDA,floatDB,\
                        floatDC,floatDD,\
                        floatDE,floatDF,\
                        amdk3dopcodes,amdk3dspecial,amdspecial,\
                        cyrixspecial

opcodeidsatt    dw      opnames1att,opnames2att,\
                        grp1EbIbAatt,grp1EvIvatt,grp1EbIbBatt,grp1EvIbatt,\
                        grp2EbIbatt,grp2EvIbatt,grp2Eb1att,grp2Ev1att,\
                        grp2EbCLatt,grp2EvCLatt,grp3Ebatt,grp3Evatt,\
                        grp4att,grp5att,grp6att,grp7att,grp8att,\
                        grp9att,grpA0F71att,grpA0F72att,grpA0F73att,\
                        grpBatt,\
                        specialatt,\
                        floatD8regatt,floatD9regatt,\
                        floatDAregatt,floatDBregatt,\
                        floatDCregatt,floatDDregatt,\
                        floatDEregatt,floatDFregatt,\
                        floatD8,floatD9,\
                        floatDA,floatDB,\
                        floatDC,floatDD,\
                        floatDE,floatDF,\
                        amdk3dopcodes,amdk3dspecial,amdspecial,\
                        cyrixspecial

operandcall     dw      dis_mem,dis_imm,dis_reg,dis_nearofs,dis_farofs
operandcallatt  dw      dis_mematt,dis_immatt,dis_regatt,dis_nearofsatt,dis_farofsatt

label   regs word
  dw    @eax,@ecx,@edx,@ebx,@esp,@ebp,@esi,@edi
  dw    @ax,@cx,@dx,@bx,@sp,@bp,@si,@di
  dw    @al,@cl,@dl,@bl,@ah,@ch,@dh,@bh
label   segregs word
  dw    @es,@cs,@ss,@ds,@fs,@gs,@?1,@?2
  dw    @cr0,@cr1,@cr2,@cr3,@cr4,@cr5,@cr6,@cr7
  dw    @dr0,@dr1,@dr2,@dr3,@dr4,@dr5,@dr6,@dr7
  dw    @tr0,@tr1,@tr2,@tr3,@tr4,@tr5,@tr6,@tr7
  dw    @mm0,@mm1,@mm2,@mm3,@mm4,@mm5,@mm6,@mm7
  dw    @st0,@st1,@st2,@st3,@st4,@st5,@st6,@st7
  dw    @st

label   regsatt word
  dw    @eax,@ecx,@edx,@ebx,@esp,@ebp,@esi,@edi
  dw    @ax,@cx,@dx,@bx,@sp,@bp,@si,@di
  dw    @al,@cl,@dl,@bl,@ah,@ch,@dh,@bh
  dw    @es,@cs,@ss,@ds,@fs,@gs,@?1,@?2
  dw    @cr0,@cr1,@cr2,@cr3,@cr4,@cr5,@cr6,@cr7
  dw    @db0,@db1,@db2,@db3,@db4,@db5,@db6,@db7
  dw    @tr0,@tr1,@tr2,@tr3,@tr4,@tr5,@tr6,@tr7
  dw    @mm0,@mm1,@mm2,@mm3,@mm4,@mm5,@mm6,@mm7
  dw    @st0,@st1,@st2,@st3,@st4,@st5,@st6,@st7
  dw    @st

;from dis_operand_t.size equates
label   sizestrings word
  dw    @byte,@word,@dword,@pword
  dw    @qword,@tbyte,@word,@dword
  dw    @dword,@fword,@word,@dword

macro   op n
@&n&    db      '&n&',0
endm    op
macro   op2 n
@&n&    db      '&n&',0
@&n&d   db      '&n&d',0
@&n&w   db      '&n&w',0
endm    op2
op      aaa
op      aad
op      aam
op      aas
op      adc
op      add
op      and
op      arpl
op      bound
op      bsf
op      bsr
op      bswap
op      bt
op      btc
op      btr
op      bts
op      call
op      cbw
op      cdq
op      clc
op      cld
op      cli
op      clts
op      cmc
op      cmp
op      cmps
op      cmpsb
op      cmpsd
op      cmpsw
op      cmpxchg
op      cmpxchg8b
op      cpuid
op      cwd
op      cwde
op      daa
op      das
op      dec
op      div
op2     enter
op      esc
op      f2xm1
op      fabs
op      fadd
op      faddp
op      fiadd
op      fbld
op      fbstp
op      fchs
op      fnclex
op      fneni
op      fndisi
op      fnsetpm
op      fcom
op      fcomp
op      fcompp
op      fcos
op      fdecstp
op      fdiv
op      fdivp
op      fidiv
op      fdivr
op      fdivrp
op      fidivr
op      ffree
op      ficom
op      ficomp
op      fild
op      fincstp
op      fninit
op      fist
op      fistp
op      fld
op      fld1
op      fldl2t
op      fldl2e
op      fldpi
op      fldlg2
op      fldln2
op      fldz
op      fldcw
op      fldenv
op      fmul
op      fmulp
op      fimul
op      fnop
op      fpatan
op      fprem
op      fprem1
op      fptan
op      frndint
op      frstor
op      fnsave
op      fscale
op      fsin
op      fsincos
op      fsqrt
op      fst
op      fstp
op      fnstcw
op      fnstenv
op      fnstsw
op      fsub
op      fsubp
op      fisub
op      fsubr
op      fsubrp
op      fisubr
op      ftst
op      fucom
op      fucomp
op      fucompp
op      fxam
op      fxch
op      fxtract
op      fyl2x
op      fyl2xp1
op      hlt
op      idiv
op      imul
op      in
op      inc
op      ins
op      insb
op      insw
op      insd
op      int
op      int01
op      into
op      invd
op      invlpg
op2     iret
op      jcxz
op      jecxz
op      jo
op      jno
op      jb
op      jae
op      je
op      jne
op      jbe
op      ja
op      js
op      jns
op      jp
op      jnp
op      jl
op      jge
op      jle
op      jg
op      jmp
op      lahf
op      lar
op      lds
op      lea
op2     leave
op      les
op      lfs
op2     lgdt
op      lgs
op      lldt
op2     lidt
op      lmsw
op      loadall
op      lock
op      lods
op      lodsb
op      lodsd
op      lodsw
op      loop
op      loopd
op      loopw
op      loope
op      loopde
op      loopwe
op      loopne
op      loopdne
op      loopwne
op      lsl
op      lss
op      ltr
op      mov
op      movs
op      movsb
op      movsd
op      movsw
op      movsx
op      movzx
op      mul
op      neg
op      nop
op      not
op      or
op      out
op      outs
op      outsb
op      outsd
op      outsw
op      pop
op2     popa
op2     popf
op      push
op2     pusha
op2     pushf
op      rcl
op      rcr
op      rdmsr
op      rdtsc
op      rep
op      repne
op2     retn
op2     retf
op      rol
op      ror
op      rsm
op      sahf
op      salc
op      sar
op      sbb
op      scas
op      scasb
op      scasd
op      scasw
op      seges
op      segcs
op      segss
op      segds
op      segfs
op      seggs
op      seto
op      setno
op      setb
op      setae
op      sete
op      setne
op      setbe
op      seta
op      sets
op      setns
op      setp
op      setnp
op      setl
op      setge
op      setle
op      setg
op2     sgdt
op      shl
op      shr
op      shld
op      shrd
op2     sidt
op      sldt
op      smsw
op      stc
op      std
op      sti
op      stos
op      stosb
op      stosd
op      stosw
op      str
op      sub
op      sysenter
op      sysexit
op      test
op      ud2
op      verr
op      verw
op      wait
op      wbinvd
op      wrmsr
op      xadd
op      xchg
op      xlat
op      xlatb
op      xor

op      psrlw
op      psraw
op      psllw
op      psrld
op      psrad
op      pslld
op      psrlq
op      psllq
op      umov
op      rdpmc
op      cmovo
op      cmovs
op      punpcklbw
op      punpckhbw
op      pcmpeqb
op      movd
op      pmullw
op      psubusb
op      pmulhw
op      psubsb
op      pmaddwd
op      psubb
op      cmovno
op      cmovns
op      punpcklwd
op      punpckhwd
op      pcmpeqw
op      movq
op      psubusw
op      psubsw
op      psubw
op      cmovb
op      cmovp
op      punpckldq
op      punpckhdq
op      pcmpeqd
op      pand
op      por
op      psubd
op      cmovae
op      cmovnp
op      packsswb
op      packssdw
op      emms
op      paddusb
op      paddsb
op      paddb
op      cmove
op      cmovl
op      pcmpgtb
op      paddusw
op      paddsw
op      paddw
op      cmovne
op      cmovge
op      pcmpgtw
op      pandn
op      pxor
op      paddd
op      cmovbe
op      cmovle
op      pcmpgtd
op      cmova
op      cmovg
op      packuswb

op      fstp1
op      fcmovb
op      fcmove
op      fcmovbe
op      fcmovu
op      fcmovnb
op      fcmovne
op      fcmovnbe
op      fcmovnu
op      fnrstpm
op      fucomi
op      fcomi
op      fcom2
op      fcomp3
op      fxch4
op      fcomp5
op      ffreep
op      fxch7
op      fstp8
op      fstp9
op      fnstdw
op      fnstsg
op      fucomip
op      fcomip
op      fpreep

;AMD K3D instruction mnemonics
op      k3d?            ;invalid or not known K3D instruction
op      pfcmpge
op      pfmin
op      pfrcp
op      pfrsqrt
op      pfcmpgt
op      pfmax
op      pfrcpit1
op      pfrsqit1
op      pfcmpeq
op      pfmul
op      pfrcpit2
op      pmulhrw
op      pi2fd
op      pf2id
op      pfsub
op      pfadd
op      pfsubr
op      pfacc
op      pavgusb
op      syscall
op      sysret
op      ud
op      prefetch
op      prefetchw
op      femms

;Cyrix instruction mnemonics
op      svdc
op      rsdc
op      svldt
op      rsldt
op      svts
op      rsts
op      rdshr
op      wrshr
op      smint
op      paveb
op      paddsiw
op      pmagw
op      pdistib
op      psubsiw
op      pmvzb
;op      pmulhrw
op      pmvnzb
op      pmvlzb
op      pmvgezb
op      pmulhriw
op      pmachriw

op      fxsave
op      fxrstor

macro   att n
@&n&    db      '&n&',0
endm    att
macro   att2 n
@&n&v   db      '&n&',attdontshowsizeworddword,0
endm    att2

macro   attb n
@&n&b   db      '&n&',attsizebyte,0
endm    attb
macro   attv n
@&n&v   db      '&n&',attsizeworddword,0
endm    attv
macro   attbv n
  attb  n
  attv  n
endm    attbv
macro   atts n
@&n&att db      '&n&',attstringsize,0
endm    atts

attbv   adc
attbv   add
attbv   and
att2    arpl
attv    bound
attv    bsf
attv    bsr
attv    bswap
attv    bt
attv    btc
attv    btr
attv    bts
att2    call
att2    lcall
attbv   cmp
attbv   cmpxchg
attbv   dec
attbv   div
attbv   idiv
attbv   imul
attbv   in
attbv   inc
att2    iret
att2    jcxz
att2    jecxz
att2    jo
att2    jno
att2    jb
att2    jae
att2    je
att2    jne
att2    jbe
att2    ja
att2    js
att2    jns
att2    jp
att2    jnp
att2    jl
att2    jge
att2    jle
att2    jg
att2    jmp
att2    ljmp
attv    lar
attv    lds
attv    lea
attv    les
attv    lfs
attv    lgs
att2    lmsw
attv    lsl
attv    lss
attv    ltr
attbv   mov
@movsbv db      'movsb',attshowsizeworddword,0
@movswv db      'movsw',attshowsizeworddword,0
@movzbv db      'movzb',attshowsizeworddword,0
@movzwv db      'movzw',attshowsizeworddword,0
attbv   mul
attbv   neg
attbv   not
attbv   or
attbv   out
attv    pop
attv    push
attbv   rcl
attbv   rcr
attbv   rol
attbv   ror
attbv   sar
attbv   sbb
attbv   shl
attbv   shr
attbv   shld
attbv   shrd
att2    smsw
attbv   sub
attbv   test
att2    verr
att2    verw
attbv   xadd
attbv   xchg
attbv   xor

att     enterl
att     sgdtl
att     sidtl
att     lgdtl
att     lidtl
att2    looplne
att2    loopwne
att2    loopne
att2    loople
att2    loopwe
att2    loope
att2    loopl
att2    loopw
att2    loop
att     pushal
att     popal
att     pushfl
att     popfl
att     leavel
att     iretl
atts    ins
atts    outs
atts    scas
atts    stos
atts    lods
atts    cmps
atts    movs
att     ret
att     retw
att     retl
att     lret
att     lretw
att     lretl
att     cbtw
att     cwtl
att     cwtd
att     cltd
att     movl

op      fadds
op      fmuls
op      fcoms
op      fcomps
op      fsubs
op      fsubrs
op      fdivs
op      fdivrs
op      flds
op      fsts
op      fstps
op      fiaddl
op      fimull
op      ficoml
op      ficompl
op      fisubl
op      fisubrl
op      fidivl
op      fidivrl
op      fildl
op      fistl
op      fistpl
op      fldt
op      fstpt
op      faddl
op      fmull
op      fcoml
op      fcompl
op      fsubl
op      fsubrl
op      fdivl
op      fdivrl
op      fldl
op      fstl
op      fstpl
op      fildll
op      fistpll

attbv   umov

op      db
op      small
op      large
op      byte
op      word
op      dword
op      fword
op      pword
op      qword
op      tbyte
op      short
op      near
op      far
op      ptr
@dbatt  db      '.byte',0

op      al
op      cl
op      dl
op      bl
op      ah
op      ch
op      dh
op      bh
op      ax
op      cx
op      dx
op      bx
op      sp
op      bp
op      si
op      di
op      eax
op      ecx
op      edx
op      ebx
op      esp
op      ebp
op      esi
op      edi
op      es
op      cs
op      ss
op      ds
op      fs
op      gs
op      ?1
op      ?2
@cr0    db      'cr0',0
@cr1    db      'cr1',0
@cr2    db      'cr2',0
@cr3    db      'cr3',0
@cr4    db      'cr4',0
@cr5    db      'cr5',0
@cr6    db      'cr6',0
@cr7    db      'cr7',0
@dr0    db      'dr0',0
@dr1    db      'dr1',0
@dr2    db      'dr2',0
@dr3    db      'dr3',0
@dr4    db      'dr4',0
@dr5    db      'dr5',0
@dr6    db      'dr6',0
@dr7    db      'dr7',0
@db0    db      'db0',0
@db1    db      'db1',0
@db2    db      'db2',0
@db3    db      'db3',0
@db4    db      'db4',0
@db5    db      'db5',0
@db6    db      'db6',0
@db7    db      'db7',0
@tr0    db      'tr0',0
@tr1    db      'tr1',0
@tr2    db      'tr2',0
@tr3    db      'tr3',0
@tr4    db      'tr4',0
@tr5    db      'tr5',0
@tr6    db      'tr6',0
@tr7    db      'tr7',0
@mm0    db      'mm0',0
@mm1    db      'mm1',0
@mm2    db      'mm2',0
@mm3    db      'mm3',0
@mm4    db      'mm4',0
@mm5    db      'mm5',0
@mm6    db      'mm6',0
@mm7    db      'mm7',0
@st0    db      'st(0)',0
@st1    db      'st(1)',0
@st2    db      'st(2)',0
@st3    db      'st(3)',0
@st4    db      'st(4)',0
@st5    db      'st(5)',0
@st6    db      'st(6)',0
@st7    db      'st(7)',0
op      st
purge   op
        endconst
        end
