	NAME	DVINT
	TITLE	DESQview Interfaces
	PAGE	66,132

DVINT_SEG SEGMENT 'CODE'
	ASSUME	CS:DVINT_SEG

	PUBLIC  DVGETVER
	PUBLIC  DVPAUSE
	PUBLIC  DVLOCK
	PUBLIC  DVNORMAL
	PUBLIC  DVGETVID

IN_DV	DB 1

GET_VERSION PROC
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AX,2B01H		; DV get version request
	MOV	CX,'DE'
	MOV	DX,'SQ'
	INT	21H
	CMP	AL,0FFH			; Are we in DV?
	JE	NO_DV			; Jump if not
	MOV	AX,BX			; We are; put the version number in AX
	MOV	CS:IN_DV,1		; Set the local IN_DV flag
	JMP	SHORT DVGV_EXIT
NO_DV:	SUB	AX,AX			; Clear AX
	MOV	CS:IN_DV,AL		; And the local flag
DVGV_EXIT:
	POP	DX
	POP	CX
	POP	BX
	RET
GET_VERSION ENDP

; DVGETVER returns the DV version number in AX, or 0 if not in
; DV.  This should be called before any other DV functions
DVGETVER PROC FAR
	CALL	GET_VERSION
	RET
DVGETVER ENDP

; API_CALL is a local routine that goes on stack, does whatever call is
; passed it in BX, and then goes off stack
API_CALL PROC
	PUSH	AX
	MOV	AX,101AH
	INT	15H			; OSTACK
	MOV	AX,BX
	INT	15H			; Parameter
	MOV	AX,1025H
	INT	15H			; USTACK
	POP	AX
	RET
API_CALL ENDP

; DVPAUSE gives up the rest of its time slice when called
DVPAUSE PROC FAR
	CMP	CS:IN_DV,1		; Are we in DV?
	JNE	DVP_END			; Jump if not
	PUSH	BX
	MOV	BX,1000H		; PAUSE function call
	CALL	API_CALL
	POP	BX
DVP_END:
	RET
DVPAUSE ENDP

; Begins a critical region.  This is a section of code which DV will not
; slice out of.  It MUST be ended with a DVNORMAL call.
DVLOCK PROC FAR
	CMP	CS:IN_DV,1		; Are we in DV?
	JNE	DVBC_END		; Jump if not
	PUSH	BX
	MOV	BX,101BH		; BEGINC
	CALL	API_CALL
	POP	BX
DVBC_END:
	RET
DVLOCK ENDP

; Ends a critical region.
DVNORMAL PROC FAR
	CMP	CS:IN_DV,1		; Are we in DV?
	JNE	DVEC_END		; Jump if not
	PUSH	BX
	MOV	BX,101CH		; ENDC
	CALL	API_CALL
	POP	BX
DVEC_END:
	RET
DVNORMAL ENDP

; Passed on the stack the video buffer address to use outside of DV.
; Returns the video buffer address to use instead.
; If what it returns is different, then video synching is not necessary.
; Also, this call does a DVGETVER call itself, so if you get
; the video buffer, it is not required that you get the version.
DVGETVID PROC FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	BX
	PUSH	DI
	PUSH	ES
	MOV	ES,[BP+6]		; Put the starting segment in ES
	CALL	GET_VERSION
	TEST	AX,AX			; Are we in DESQview?
	JZ	DVGVB_END		; Jump if not
	SUB	DI,DI			; Clear DI
	MOV	AH,0FEH			; Get video buffer function call
	INT	10H
DVGVB_END:
	MOV	AX,ES
	POP	ES
	POP	DI
	POP	BX
	POP	BP
	RET	2
DVGETVID ENDP

DVINT_SEG ENDS

	END
on call
	INT	10H
DVGVB_END:
	MOV	AX,ES
	POP	ES
	POP	DI
	POP	BX
	POP	BP
	RET	2
D                                                                                                                               