Quarterdeck Technical Note
by Stan Young

Patching the DESQview Printer Contention driver to remove the 
automatic formfeed:

Background:  One of the features of DESQview 2.+ is the ability 
to manage printer contention.  What this means is that if you are 
in one window outputing something to the printer and then switch 
windows and accidentally start a print to the same printer,  
DESQview Printer Contention will step in and interrupt the second 
task until the first has finished. Some users will want to have 
this option on, others will find it not too useful.  However, if 
you have it on, you may notice that you sometimes get extra 
formfeeds.  This is because Printer Contention tries to be sure 
an application that has done a print has moved the printer to the 
top of form before allowing another print to occur.  Otherwise, 
you could end up with the second print starting at the bottom of 
the last page of the previous print.  Therefore, Printer 
Contention sends a formfeed to be sure the printer is a top of 
form.  Since many programs do not close out the printer in a way 
that Printer Contention can detect that the printer is a top of 
form, you can end up with a lot of blank, ejected sheets when you 
use DESQview Printer Contention.  Eventually, we may offer some 
sort of switch to allow the users to select the formfeed option 
or not, but at present, it is possible to patch the driver to 
eliminate the formfeed.

                           THE PATCH

First, make sure you have a PATH set to your DEBUG.COM file which 
is part of your DOS files and is usually located in your DOS 
directory.  Switch to the DESQview directory and type in the 
following to start DEBUG and load the DESQview Printer Contention 
driver.

C:\DV>debug rmgrdv.dvr

After loading, DEBUG returns a minus sign (-) as a prompt.

First we will find the spot where the Printer Contention driver 
outputs the formfeed.  Type in the following:

-s0 1000 50 b8 0c 00        <--- Hit Enter

Debug will display something like the following.  The part that 
is shown as xxxx will be some hex number that we are not 
concerned with.  The number after the colon is the one we are 
concerned with and may or may not be the "03E2" figure that is 
shown below.  What ever is returned on your machine after the 
colon on your machine is the number to use.  If no such number is 
returned and you are returned to the "-" prompt, you probably 
entered some-thing incorrectly (type q to quit and start again).

xxxx:03E2

Type in the following.  If the number your machine returned after 
the colon was different than 03E2, substitute the number returned 
where it says 03e2 below...

-e03e2

You will get a display similar to the one below except the 
display will be paused after the "50." and will be waiting for 
input.  Type in the "EB" and hit the space bar.  Debug will then 
tab over and display "B8" and again pause for input.  Type in 
"0A" and hit the Enter key.

413C:03E2  50.EB   B8.0A
              ^       ^     <--Type hex numbers starting at carets

The "-" prompt will be returned by Debug.  Type "w" to write out 
the change and hit Enter. -w            

Debug will indicate that it is writing out the change.

Writing xxx bytes

Type "q" to quit out of Debug.

-q

You will get the DOS prompt and you are done.  Now restart 
DESQview and you should not get formfeeds.

             * * *   E N D   O F   F I L E    * * * 
