/********************************************************************
**  YRCLSCHD.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**
**  Produces <M>onthly, <W>eekly, and <D>aily schedules for YEARCAL.
**
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fclose, fopen, fp, fprintf, fputs, */
			/* gets, printf, rename, sprintf, stderr */
#include <stdlib.h>	/* exit */
#include <string.h>	/* strcat, strcmp, strcpy, strlen */

#include "yearcal.def"

/* External variables and structures declared in YEARCAL.C */
extern struct options Opt;		/* User definable options */
extern struct LineDraw bcs[];		/* border character sets array */
extern struct month mon[];		/* Month's lengths array */
extern char *lingo[];			/* Names of languages array */
extern char *mnam[][12];		/* Names of months array */
extern char *wkday[][7];		/* Names of days array */
extern int yr[][12][6][7];		/* Array for 3 yrs, 4-D, */
					/* 3 years,      12 months/year, */
					/* 6 weeks/month, 7 days/week */
extern char *new_file;
extern char *file;
extern FILE *fp;



void sched_printer(int year,        char out,
		   int bm,          int bd,
		   int bh,          int nh,
		   int pl,          int pw,
		   char sched_type, char title[][LIN],
		   char base,       int lang,
		   char pause,      int indent,    int lds)
/* int year;		Year for calendar */
/* char out;		Output goes where? View, Printer, File */
/* int bm;		Month (beginning) for schedule */
/* int bd;		Day (beginning) for schedule */
/* int bh;		Hour (beginning) for schedule */
/* int nh;		number of hours to schedule (1-24) */
/* int pl;		Page Length in lines */
/* int pw;		Page Width in columns */
/* char sched_type;	Schedule type M(onthly), W(eekly), D(aily) */
/* char title[][LIN];   User-modifiable title line array */
/* char base;		Number base used, 0 = Decimal, H = Hex, O = Octal */
/* int lang;		Language used 1=Danish, 2=Dutch, 3=English etc. */
/* char pause;		Page pause flag True/False */
/* int indent;		Left margin indent (# of spaces) */
/* int lds; 		Line draw char set used 0 = Ascii Characters */
			/* 1 = 1-line top, sides, inside */
			/* 2 = 2-line top, sides, inside */
			/* 3 = 1-line top, double sides, inside */
			/* 4 = 2-line top, single sides, inside */
{
    int bw,				/* Box width */
	day,
	first_day,
	i, j,
	month,
	stat,
	w,				/* Week number for printing top */
					/* calendars */
	wk_day,
	y;
    char  linbuf  [BUF],
	  temp    [BUF],
	  temp1   [BUF],
	  temp2   [BUF],
	  temp3   [BUF],
	  temp4   [BUF],
	  top     [BUF],		/* Top line of schedule */
	  top2    [BUF],		/* Top line of daily schedule */
					/* under day headers. */
	  botm    [BUF],		/* Bottom line of schedule */
	  sep     [BUF],		/* Separator line between hours */
	  hoursw  [BUF],		/* Spacer line for daily schedule */
	  spacerw [BUF],		/* Spacer line for weekly schedule */
	  dates   [BUF];

    char *off = ( (out == 'V') ?
			   " " :	/* Offset for screen */
    "                                        ");
    /* 40 spaces-----------------------------| Max Offset for printing */

    if (out != 'V')			/* For <F>ile or <P>rinter output */
	off[indent] = '\0';		/* Clip offset to proper length */

    y = 1;				/* Make year this year */

    if (out == 'V')			/* Gonna <V>iew it, so. . . */
	  pw = 80  ;			/* pw is screen width */

    if (out == 'F')			/* Setup for <F>ile output */
    {
	(sched_type == 'M') ?
	    sprintf(file, "%d%3.3s%c", year, mnam[lang - 1][bm], base):
	    sprintf(file, "%d%02d%02d", year, bm + 1, bd);
	strcpy(new_file, file);
	strcat(file, ".$$$");
	sprintf(temp, ".%3.3s", lingo[lang - 1]);
	strcat(new_file, temp);
	fp = fopen(file, "w");
/*      printf("\nOpened %s for write\n", file);*/
    }

    first_day = weekday(year, bm + 1, 1);	/* 1st day of month */

    if (sched_type == 'M')		/* <M>onthly schedule */
	wk_day = 0;			/* Month starts on first */
    else				/* <W>eekly|<D>aily schedules */
	wk_day = ( (first_day + bd - 1) % 7);	/* Gives us weekday */

    /* Lines 3, 4 & 5:  prepare text for center of titles */
    if (sched_type == 'M')		/* <M>onthly schedule */
	sprintf(title[3], "%s %d",
			   mnam[lang - 1][bm],
			       year );
    else				/* <W>eekly|<D>aily schedules */
	sprintf(title[3], "%d %s, %d",
			   bd,
			      mnam[lang - 1][bm],
				  year );

    sprintf(title[4], sched_type == 'W' ? "Week begins on %s" :
		      sched_type == 'D' ? "%s" :
					   ""  ,
		       wkday[lang - 1][wk_day]);

    sprintf(title[5], "%s",
		   sched_type == 'M' ?	"Monthly Calendar" :
		   sched_type == 'W' ? 	"Weekly Schedule"  :
					"Daily Schedule"   );

    /* Begin building calendar body lines with offset spaces */
    strcpy(hoursw,  off);		/* Put offset into hoursw */
    strcpy(spacerw, off);		/* Put offset into spacerw */
    strcpy(top,     off);		/* Put offset into top boundary */
    strcpy(top2,    off);		/* Put offset into top2 line */
    strcpy(botm,    off);		/* Put offset into bottom boundary */
    strcpy(sep,     off);		/* Put offset into separator */

    /* Add time box to calendar lines for <D>aily|<W>eekly Schedules */
    if (sched_type != 'M')		/* Need Time if <D>aily|<W>eekly */
    {
	sprintf(temp, Opt.mil ?		/* 24 hr time selected? */
	     "%c %s00 %c"     :		/* 24 hr time format */
	     "%c %s:00%%s %c" ,		/* am/pm time format */
	      bcs[lds].side,		/* West side frame line */
		 base 	     ?		/* Programmer's calendar */
		 base == 'O' ?		/* Octal requested */
		 "%02o"      :		/* Octal numbering */
		 "%02X"      :		/* Hexadecimal numbering */
		 "%02d"      ,		/* Decimal numbering */
		     bcs[lds].ns);
	strcat(hoursw, temp);		/* Add header info to hoursw */

	sprintf(temp, Opt.mil ? "%c      %c"    :       /* 24 hr time */
				"%c         %c" ,	/* am/pm time */
				bcs[lds].side,
					 bcs[lds].ns);
	strcat(spacerw, temp);		/* Add header info to spacerw */

	for (i =  0;
	     i < 12;
	     i++   )
	{
	    temp1[i] = bcs[lds].ew;
	    temp2[i] = bcs[lds].line;
	}

	temp1[i] = '\0';		/* Terminate temp1 */
	temp2[i] = '\0';		/* Terminate temp2 */

	sprintf(temp, Opt.mil ? "%c%6.6s%c" :	/* 24 hr time */
				"%c%9.9s%c" ,	/* am/pm time */
				 bcs[lds].nw,
				   temp2,
					 bcs[lds].ni);
	strcat(top, temp);		/* Add header info to top */

	sprintf(temp, Opt.mil ?		/* 24 hr time selected? */
		  "%c%6.6s%c" :		/* 24 hr time format */
		  "%c%9.9s%c" ,		/* am/pm time format */
		   bcs[lds].sw,		/* South West corner */
		     temp2,
			  bcs[lds].si);	/* South Intersection */
	strcat(botm, temp);		/* Add header info to botm */

	sprintf(temp, Opt.mil ?		/* 24 hr time selected? */
		  "%c%6.6s%c" :		/* 24 hr time format */
		  "%c%9.9s%c" ,		/* am/pm time format */
		   bcs[lds].wi,		/* West Intersection */
		     temp1,
			  bcs[lds].cross);	/* Interior Cross */
	strcat(sep, temp);		/* Add header info to sep */
	strcat(top2, temp);		/* Add header info to top2 */
    }
    else				/* Monthly Calendar, so. . . */
    /* Add East Side to calendar lines for <M>onthly schedule */
    {
	sprintf(temp, "%c", bcs[lds].side);
	strcat(hoursw,	temp);		/* Add header info to hoursw */
	strcat(spacerw, temp);		/* Add header info to spacerw */
	sprintf(temp, "%c", bcs[lds].wi);
	strcat(sep, 	temp);		/* Add header info to sep */
	strcat(top2, 	temp);		/* Add header info to top2 */
	sprintf(temp, "%c", bcs[lds].nw);
	strcat(top,	temp);		/* Add header info to top */
	sprintf(temp, "%c", bcs[lds].sw);
	strcat(botm, 	temp);		/* Add header info to botm */
    }

    bw = (((pw - strlen(hoursw) ) / 7) - 1);  /* Calculate Box Width */

    for (i = 0;				/* Form strings for each day */
	 i < bw;			/* As wide as Box Width */
	 i++)
    {
	temp [i] = ' ';			/* Using spaces */
	temp1[i] = bcs[lds].line;	/* Using outer horizontal lines */
	temp2[i] = bcs[lds].line;	/* Using outer horizontal lines */
	temp3[i] = bcs[lds].ew;		/* Using inner horizontal lines */
	temp4[i] = bcs[lds].ew;		/* Using inner horizontal lines */
    }

    if (sched_type == 'M')		/* Monthly Calendar */
    {
	temp[i] = '\0';			/* Terminate temp string */
	strcpy(dates, temp);		/* Copy temp to dates for length */
	dates[i - 2] = '\0';		/* Cut dates to length */
    }

    /* Build temp strings that will be multiply added to necessary strings */
    /* Spacer line uses temp */
    temp [i] = (sched_type == 'D')  ?	/* If Daily */
				 ' ':	/* Add ' ' */
			 bcs[lds].ns;	/* Otherwise add '|' */

    /* Top line uses temp1 */
    temp1[i] = bcs[lds].ni;		/* Add North Intersect */
					/* temp1 = "-------|" */

    /* Bottom line uses temp2 */
    temp2[i] = (sched_type == 'D')  ?	/* If Daily */
		      bcs[lds].line :	/* Add outer line */
		      bcs[lds].si   ;	/* Add South Intersect */

    /* Separator line(s) uses temp3 */
    temp3[i] = (sched_type == 'D')  ?	/* If Daily */
		      bcs[lds].ew   :	/* Add inner line */
		      bcs[lds].cross;	/* Otherwise add Cross */

    /* Top2 line uses temp4 */
    temp4[i] = (sched_type == 'D')  ?	/* If Daily */
		      bcs[lds].isi  :	/* Add Inner South Intersection */
		      bcs[lds].cross;	/* Otherwise add Cross */
    ++i;

    temp [i] = '\0';			/* Terminate temp  string */
    temp1[i] = '\0';			/* Terminate temp1 string */
    temp2[i] = '\0';			/* Terminate temp2 string */
    temp3[i] = '\0';			/* Terminate temp3 string */
    temp4[i] = '\0';			/* Terminate temp3 string */
					/* temp1 = "-------|" */

    for (i = 0;				/* Add multiple temps to hoursw, */
	 i < 7;				/* spacerw, top, botm, sep, top2 */
	 i++)
    {
	if (sched_type != 'M')		/* Weekly and Daily schedules */
	    strcat(hoursw, temp);	/* Add temp to hoursw */

	strcat(top,     temp1);		/* Add temp1 to top */
	strcat(botm,    temp2);		/* Add temp2 to botm */
	strcat(sep,     temp3);		/* Add temp3 to sep */
	strcat(top2,    temp4);		/* Add temp4 to top2 */
	strcat(spacerw, temp);		/* Add temp to spacerw */
    }

    hoursw [strlen(hoursw)  - 1] = bcs[lds].side;	/* Side */
    spacerw[strlen(spacerw) - 1] = bcs[lds].side;	/* Side */
    top    [strlen(top)     - 1] = bcs[lds].ne;		/* NE corner */
    botm   [strlen(botm)    - 1] = bcs[lds].se;		/* SE corner */
    sep    [strlen(sep)     - 1] = bcs[lds].ei;		/* East Intersect */
    top2   [strlen(top2)    - 1] = bcs[lds].ei;		/* East Intersect */

    strcat(spacerw, "\n");		/* Add '\n' */
    strcat(hoursw,  "\n");		/* Add '\n' */
    strcat(top,     "\n");		/* Add '\n' */
    strcat(botm,    "\n");		/* Add '\n' */
    strcat(sep,     "\n");		/* Add '\n' */
    strcat(top2,    "\n");		/* Add '\n' */
    /* All calendar body lines have been fully formed */

    pw = strlen(sep) - 1;		/* Adjust Page Width */

    if (pause     &&			/* User wants time after each page */
	out == 'P' )			/* gets printed to add paper etc... */
	hold();				/* Wait for keystroke */

    fputs("\n\n", fp);			/* Print two blank lines */

    /* Line One:  Last and Next Month's names */
    sprintf(temp, "%s %d",		/* Last month's name and year */
		   mnam[lang - 1]	/* Use selected language */
		       [sched_type == 'M' ?	/* <M>onthly selected */
			   (bm + 11) % 12 :	/* Use previous month */
				       bm ],	/* Use beginning month */
			sched_type == 'M' ?	/* <M>onthly selected */
				  bm == 0 ?	/* Started in Jan ? */
				  year - 1 :	/* Use previous year */
				  year    :	/* Otherwise use year */
				  year     );

    sprintf(temp2,"%s %d",		/* Next month's name and year */
		   mnam[lang - 1 ]	/* Use selected language */
		       [(bm + 1) % 12],
		      bm == 11 ?	/* Month is December */
		      year + 1 :	/* Use next year */
		      year      );	/* Otherwise use year */
    strcpy(linbuf, off);
    strcat(linbuf, center(temp, 21));
    strcat(linbuf, center(title[0], (pw - 42 - strlen(off)) ) );
    strcat(linbuf, center(temp2, 21) );
    strcat(linbuf, "\n");
    fputs (linbuf, fp);			/* Write Line One */

    /* Line Two:  Weekday headers like: " SU MO TU WE TH FR SA" */
    temp[0] = '\0';			/* Init temp */

    for (i = 0;				/* From Sunday (0) */
	 i < 7 ;			/* Through Saturday (6) */
	 i++)
    {
	sprintf(temp2, " %2.2s",	/* For each day name */
			 wkday[lang - 1][i] );	/* Use selected language */
	strcat(temp, temp2);		/* Add it to temp */
    }  /* Temp is now formed like:  " SU MO TU WE TH FR SA" */

    /* Start forming Line Two in linbuf */
    strcpy(linbuf, off);		/* Add offset spaces */
    strcat(linbuf, center(temp, 21));	/* Add prev month weekday headers */
					/* Add title text centered */
    strcat(linbuf, center(title[1], (pw - 42 - strlen(off)) ) );
    strcat(linbuf, center(temp, 21));	/* Add next month weekday headers */
    strcat(linbuf, "\n");		/* Add newline (CR/LF) */
    fputs(linbuf, fp);			/* Write Line Two */

    /* Lines 3-8:  Prev/Next Month's dates like: " 26 27 28 29 30 31   " */
    for (w = 0;
	 w < 6;         		/* Each month can have six weeks */
	 w++)
    {
	temp [0] = '\0';		/* For Prev month's dates */
	temp2[0] = '\0';		/* For Next month's dates */

	for (day = 0;
	     day < 7;			/* 7 days/week */
	     day++)
	{
	    /* Form prev month's week day number in linbuf */
	    sprintf(linbuf,
	    /* Check for valid date in the calendar array */
	    /*   to determine whether to print date or spaces */
		yr[sched_type == 'M' ?	/* <M>onthly selected ? */
			     bm == 0 ?	/* January selected? */
			       y - 1 : 	/* Use prev year */
				   y :	/* Use this year */
				   y  ]	/* Use this year */
		  [sched_type == 'M' ?	/* <M>onthly selected ? */
		      (bm + 11) % 12 :	/* Prev month normalized */
				 bm   ]	/* Use beginning month */
		  [w][day]	     ?	/* Non-zero date in array? */
		    base	     ?	/* Programmer's calendar? */
		    base == 'O'	     ?	/* Octal numbering selected? */
			"%3o" 	     :	/* Octal number format */
			"%3X"	     :	/* Hexadecimal number format */
			"%3d"	     :	/* Decimal number format */
			"   "	      ,	/* No date, so no number */
		yr[sched_type == 'M' ?	/* <M>onthly selected ? */
			     bm == 0 ?	/* January selected? */
			       y - 1 :	/* Use prev year */
				   y :	/* Use this year */
				   y  ]	/* Use this year */
		  [sched_type == 'M' ?	/* <M>onthly selected ? */
		      (bm + 11) % 12 :	/* Prev month normalized */
				  bm  ]	/* Use beginning month */
		   [w] [day] );
	    /* linbuf has Prev Month's week date like: " 26" or "   " */

	    /* Form next month's week day number in temp1 */
	    sprintf(temp1,
	    /* Check for valid date in the calendar array */
	    /*   to determine whether to print date or spaces */
		yr[bm == 11 ?		/* Beginning month is December? */
		      y + 1 :		/* So next month bumps year */
		      y      ]		/* Else use year */
		  [(bm + 1) % 12]	/* Next month normalized */
		  [w][day]	?	/* Non-zero date in array? */
		      base	?	/* Programmer's calendar? */
		      base == 'O' ?	/* Octal numbering selected? */
			"%3o"     :	/* Octal number format */
			"%3X"     :	/* Hexadecimal number format */
			"%3d"     :	/* Decimal number format */
			"   "      ,	/* No date, so no number */
		 yr[bm == 11 ?		/* Beg Month is December? */
		       y + 1 :		/* Bump year by one */
			   y  ]		/* Else same year */
		   [(bm + 1) % 12]	/* Next month normalized */
		   [w][day]);
	    /* temp1 has Next Month's week date like: " 26" or "   " */

	    strcat(temp, linbuf);	/* Add prev month's dates to temp */
	    strcat(temp2, temp1);	/* Add next month's dates to temp */
	} /* end for (day = 0 to 6) */

	/* temp  has Prev Month's week dates like: " 24 25 26 27 28 29 30" */
	/* temp2 has Next Month's week dates like: " 26 27 28 29 30      " */

	strcpy(linbuf, off);		/* Copy offset spaces to linbuf */

	/* Add prev month's weekdays */
	strcat(linbuf, center(temp, 21));

	/* Add title text centered in remaining space */
	strcat(linbuf, center(title[w + 2], (pw - 42 - strlen(off)) ) );

	/* Add next month's week days centered */
	strcat(linbuf, center(temp2, 21) );

	strcat(linbuf, "\n");		/* Add newline */
	fputs(linbuf, fp);		/* Write Line Three-Eight */
    }

    /* All eight title lines at the top of the page have been written. */
    /* We are now ready to form and output the schedule itself. */

    fputs(top, fp);			/* Print Top boundary */

    /* <W>eekly|<D>aily schedules have a present week's Date Line */
    /*"   |      | 1 OCT | 2 OCT | 3 OCT | 4 OCT | 5 OCT | 6 OCT | 7 OCT |" */
    if (sched_type != 'M')		/* <W>eekly|<D>aily schedule */
    {
	sprintf(linbuf, Opt.mil ?	/* 24 hour time selected */
			"%s%c      %c" :	/* 24 hr format */
			"%s%c         %c",	/* am/pm format */
			 off,			/* Spaces offset */
			   bcs[lds].side,	/* Side '|' */
				    bcs[lds].ns);	/* Inner '|' */

	for (i = day = bd, month = bm;
	     i < (bd + 7);
	     i++, day++)
	{
	    if (day >  mon[month].length)	/* Past this month */
	    {
		day -= mon[month].length;	/* So make it proper day... */
		month++;			/* Of following month. . . */
		month = month % 12; 	/* And then normalise it. . . */
	    }

	    sprintf(temp1, "%d %3.3s", day, mnam[lang - 1][month]);
	    sprintf(temp, "%s%c", center(temp1, bw), bcs[lds].ns );
	    strcat(linbuf, temp);
	}

	linbuf[strlen(linbuf) - 1] = bcs[lds].side;	/* Last ns to side */
	strcat(linbuf, "\n");		/* Add newline */
	fputs(linbuf, fp);		/* Write Date line */
    }

    /* All schedules have a present week's Day of the Week Line */
    /*"    |      | SUNDAY | MONDAY | TUESDAY|. . . |SATURDAY|" */
    sprintf(linbuf, sched_type != 'M' ?	/* Add time box */
			      Opt.mil ?	/* 24 hr time selected */
		    "%s%c      %c"    :	/* 24 hr format */
		    "%s%c         %c" :	/* am/pm format */
		    "%s%c",		/* <M>onthly has no time box */
			 off,		/* Spaces offset */
			   bcs[lds].side,	/* Left Side */
				      bcs[lds].ns);	/* Vertical */

    /* Now add names of the days of the week */
    for (i = wk_day;
	 i < (wk_day + 7);
	 i++)
    {
	sprintf(temp1, "%3.13s", wkday[lang - 1][i % 7]);
	sprintf(temp, "%s%c", center(temp1, bw), bcs[lds].ns );
	strcat(linbuf, temp);		/* Add day's name */
    }

    linbuf[strlen(linbuf) - 1] = bcs[lds].side;		/* Right Side */
    strcat(linbuf, "\n");		/* Add newline */
    fputs(linbuf, fp);			/* Write Day of Week Line */

    if (sched_type == 'M')		/* Monthly calendar */
    {					/* Months have 5 or 6 weeks */
	bh = 0;
	nh = (yr[y][bm][5][0])?		/* Sixth week, Sunday? */
			   6:		/* Six weeks/month */
			   5;		/* Five weeks/month */
    }

    for (i = bh;			/* Start at beginning hour */
	 i < (bh + nh);			/* Continue to number of hours */
	 i++)				/* Print the hourly lines */
    {
	if (i == bh)			/* First Sep is Top2 */
	    fputs(top2, fp);		/* Print Top2 Separator line */
	else
	    fputs(sep, fp);		/* Print Separator lines */

	if (sched_type == 'M')
	{
            /* Initialize hoursw */
	    sprintf(hoursw, "%s%c",
			     off,	/* Spaces offset */
			       bcs[lds].side);	/* Side '|' */

	    for (j = 0;
		 j < 7;			/* For seven days */
		 j++)
	    {
		sprintf(temp,
			yr[y][bm][i][j] ?	/* Non-zero date? */
			base ?		/* Programmer's calendar */
			base == 'O' ?   /* Octal selected? */
			  "%s%2o%c" :	/* Octal number format */
			  "%s%2X%c" :	/* Hexadecimal number format */
			  "%s%2d%c" :	/* Decimal number format */
			  "%s  %c"   ,	/* Not good date */
			   dates,
			     yr[y][bm][i][j] ?	/* Non-zero date? */
			     yr[y][bm][i][j] :	/* Use it */
			       bcs[lds].ns    ,	/* Else outer '|' */
				bcs[lds].ns   );/* Outer bar */
		strcat(hoursw, temp);
	    }

	    hoursw[strlen(hoursw) - 1] = bcs[lds].side;	/* Side */
	    strcat(hoursw, "\n");
	}

	fprintf(fp, hoursw,		/* Write hour/week line */
		    Opt.mil ?		/* 24 hr time selected? */
		   (i % 24) :		/* 24 hr time */
		   (i % 12) ?		/* If after 1 pm */
		   (i % 12) :		/*   use hour % 12 */
			12  ,		/*   else 12 */
		    (i % 24 < 12) ?	/* Before noon? */
			     "am" :	/* Add am */
			     "pm" );	/* Add pm */

	for (j = 2;
	     j < ((pl - 18) / nh);
	     j++)
	    fputs(spacerw, fp);		/* Write Spacer Line(s) */
    }

    fputs(botm, fp);			/* Write Bottom Line */

    if (out != 'V')			/* No FF for screen */
	fputs("\f\r", fp);

    if (out == 'F')			/* Setup for file output */
	if ((stat = fclose(fp)) == ERROR)
	    printf("\nCan't close %s.\n", file);

    if (out == 'F')
	if ((stat = rename(file, new_file)) == ERROR)
	    printf(
	    "\nCan't rename %s to %s.  %s may already exist.\n",
			    file, new_file,
				       new_file);
}
