#define MAX_NAMESIZE 32

#define SCAN 1
#define RESOLVE 2

#define LIB_CASE_SENSITIVE 0x01

/* Values returned by the record load function */
#define MODERR -1	/* Error this record */
#define MODQUIT -2	/* Never encountered */
#define MODIGNORE -3	/* Record was ignored */

/* Flags for the execution list */
#define TE_REPORT 1	/* Report what record was encountered */
#define TE_IGNORE 2	/* Ignore the record */
#define TE_ERROR  4	/* Generate an error for the record */

/* OMF record handling functions will have this format */
typedef void (*EXECFUNC)(uint mode);

/* Descriptor for an OMF record type */
typedef struct _typexec_ {
	char	select[2];	/* OMF record ID */
	ushort  flags;	/* FLAGS, as above */
	EXECFUNC	run;	/* Routine to run to parse the record */
} TYPEXEC;

#include "module.p"