//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.
#include "btree.h"
#include <iostream.h>

void btree_gencode()
{
   bt_C< stack_C<u_long_B> >();
}

int btree_item_C::compare_k(btree_item_C btree_item, int key_opt)
{
	if (key_opt==1) return key().compare_k(btree_item.key(),1);
   if (key_opt==2) return key().compare_k(btree_item.key(),2);
   //key==3
   if(p()==btree_item.p())  return 0;
   if(p()> btree_item.p())  return 1;
   return -1;
}


void btree_item_C::clear(void)
{
   key().clear();
   p()=0;
}

btree_item_C::btree_item_C(void)
{
  key.create();
  p.create();
  clear();
}


void btree_page_C::clear(void)
{
   p0()=0;
   items.create();
}

btree_page_C::btree_page_C(void)
{
   p0.create();
   items.create();
   clear();
}

void btree_C::init(int data_size,int orden,int level)
{
	 init_storage(data_size);
	 init_btree(orden,level);
}

void btree_C::init_storage(int data_size,int default_level,int levels,
									int trans)
{
	storage_C::init(data_size,default_level,levels,trans);
}									


void btree_C::init_btree(int orden_param, int level_param)
{
   orden.create();
   level.create();
   orden()=orden_param;
   level()=level_param;
}


int btree_C::is_leaf(btree_page_B& btree_page)
{
   return !btree_page().p0();
}


int btree_C::find(key_B& key,
                  btree_page_B &page_a,
                  u_long_B& l_page_a,
						int key_opt,
						int aprox)
{
	if (!root_page(level())) return 0;

	btree_item_B paso;
	u_long_B l_page;
	paso.create();
	paso().key=key;
	stack.create();
	page_a.create();
	l_page_a.create();
	l_page_a()=root_page(level());
#ifdef DEBUG_BTREE_FIND
	cout<<"root page:"<<root_page(level())<<"\n";
#endif
	get(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_FIND
	disp(page_a,l_page_a);
#endif
  for(;;) {
		if(page_a().items().find_o(paso,key_opt)){
			 key=page_a().items().item()().key;
			 return 1;
		}
		if (is_leaf(page_a)){
			 if (aprox) {
				 while(page_a().items().is_out() &&
						 l_page_a()!=root_page(level())){
					 l_page_a()=stack().top()();
					 stack().pop();
					 get(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_FIND
					 disp(page_a,l_page_a);
#endif
					 page_a().items().find_o(paso,key_opt);
				 }
				 if(!page_a().items().is_out()) {
					 key=page_a().items().item()().key;
					 return 2; //find greater key
				 }
				 else return 0;
			 }
			 else return 0;
		}
		l_page.clone(l_page_a);
		stack().push(l_page);

		if (page_a().items().position()==1)
			l_page_a()=page_a().p0();
		else {
			if (page_a().items().is_out())
				page_a().items().last();
			else
				page_a().items().prev();
			l_page_a()=page_a().items().item()().p();
		}
		get(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_FIND
		disp(page_a,l_page_a);
#endif
  }
}

int btree_C::findb(key_B& key,
						btree_page_B &page_a,
						u_long_B& l_page_a,
						int key_opt,
						int aprox)
{
	if (!root_page(level())) return 0;

	btree_item_B paso;
	u_long_B l_page;
	paso.create();
	paso().key=key;
	stack.create();
	page_a.create();
	l_page_a.create();
	l_page_a()=root_page(level());
	get(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_FINDB
	disp(page_a,l_page_a);
#endif

  for(;;) {
		if(page_a().items().findb_o(paso,key_opt)){
			 key=page_a().items().item()().key;
			 return 1;
		}
		if (is_leaf(page_a)){
			 if (aprox) {
				 while(page_a().items().is_out() &&
						 l_page_a()!=root_page(level())){
					 l_page_a()=stack().top()();
					 stack().pop();
					 get(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_FINDB
					 disp(page_a,l_page_a);
#endif
					 page_a().items().findb_o(paso,key_opt);
				 }
				 if(!page_a().items().is_out() ) {
					 key=page_a().items().item()().key;
					 return 2; //find smaller key
				 }
				 else return 0;
			 }
			 else return 0;
		}
		l_page.clone(l_page_a);
		stack().push(l_page);

		if (page_a().items().is_out())
			l_page_a()=page_a().p0();
		else
			l_page_a()=page_a().items().item()().p();
		get(&page_a,l_page_a,level());
		#ifdef DEBUG_BTREE_FINDB
		disp(page_a,l_page_a);
		#endif
  }
}



int btree_C::add_key_nt(key_B& key)
{
   int n;

   btree_item_B item,centro;
   item.create();
	key_B key_paso;
	key_paso.clone(key);
	item().key=key_paso;

	btree_page_B page_a,page_b,page_c;
	u_long_B     l_page_a,l_page_b,l_page_c;

#ifdef DEBUG_BTREE_ADD
	disp(item().key);
#endif

   if(find(key_paso,page_a,l_page_a,2)==1) return 0;

	if (!root_page(level())) {
      page_a.create();
      l_page_a.create();
		put(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_ADD
      disp(page_a,l_page_a);
#endif
		set_root(l_page_a,level());
   }

   for(;;) {

      if (page_a().items().n_elements()<orden()*2) {
         page_a().items().insert_o(item,2);
			modify(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_ADD
         disp(page_a,l_page_a);
#endif
         stack.forget();
         return 1;
      }
		page_b.create();
      page_a().items().insert_o(item);
      for (n=0;n<orden();n++) {
          page_a().items().last();
          page_b().items().insert_r(page_a().items().item());
          page_a().items().del();
      }
      page_a().items().last();
      centro.clone(page_a().items().item());
#ifdef DEBUG_BTREE_ADD
      disp(page_a,l_page_a);
#endif
      page_a().items().del();

      page_b().p0()=centro().p();
      l_page_b.create();
		put(&page_b,l_page_b,level());
#ifdef DEBUG_BTREE_ADD
      disp(page_b,l_page_b);
#endif
		modify(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_ADD
      disp(page_a,l_page_a);
#endif
      centro().p()=l_page_b();

		if (l_page_a()==root_page(level())) {
         l_page_c.create();
         page_c.create();
         page_c().p0()=l_page_a();
         page_c().items().insert_o(centro);
			put(&page_c,l_page_c,level());
#ifdef DEBUG_BTREE_ADD
      disp(page_c,l_page_c);
#endif
			set_root(l_page_c,level());
         stack.forget();
         return 1;
      }
      l_page_a()=stack().top()();
#ifdef DEBUG_BTREE_ADD
      cout<<"stack:"<<stack().top()()<<":"<<stack().n_elements()<<"\n";
#endif
      stack().pop();
		get(&page_a,l_page_a,level());

#ifdef DEBUG_BTREE_ADD
      disp(page_a,l_page_a);
#endif
      item=centro;
#ifdef DEBUG_BTREE_ADD
      disp(item().key);
#endif
   }
}

int btree_C::del_key_nt(key_B& key)
{
   btree_page_B page_a,page_b,page_c,page_p;
   u_long_B  l_page_a,l_page_b,l_page_c,l_page_p,l_page;
   btree_item_B item;

   int n,num;
   key_B key_paso;
   key_paso.clone(key);

#ifdef DEBUG_BTREE_DEL
      disp(key);
#endif
	if(!find(key_paso,page_a,l_page_a,2)) return 0;
#ifdef DEBUG_BTREE_DEL
      disp(page_a,l_page_a);
#endif
   if (!is_leaf(page_a)) {
      page_b.create();
      l_page_b.create();
      l_page_b()=page_a().items().item()().p();
		get(&page_b,l_page_b,level());
		stack().push(l_page_a.dup());
#ifdef DEBUG_BTREE_DEL
		disp(page_b,l_page_b);
#endif
		while(!is_leaf(page_b)) {
			stack().push(l_page_b.dup());
			l_page_b()=page_b().p0();
			get(&page_b,l_page_b,level());
#ifdef DEBUG_BTREE_DEL
		disp(page_b,l_page_b);
#endif
		}
		page_b().items().first();
		page_a().items().item()().key=page_b().items().item()().key;
		modify(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_DEL
		disp(page_a,l_page_a);
#endif
		page_a.clone(page_b);
		l_page_a()=l_page_b();
	}
	page_a().items().del();
	modify(&page_a,l_page_a,level());
#ifdef DEBUG_BTREE_DEL
		disp(page_a,l_page_a);
#endif

	item.create();
	char flag_i;
	char flag_d;
	char flag_cl;

	while( page_a().items().n_elements()<orden() &&
			 l_page_a()!=root_page(level()))            {
		l_page_b.create();
		l_page_c.create();
		l_page_b.clone(stack().top());
		get(&page_b,l_page_b,level());
		item().p()=l_page_a();
		page_b().items().find(item,3);
#ifdef DEBUG_BTREE_DEL
      disp(page_b,l_page_b);
#endif
      flag_i=flag_d=1;
      flag_cl=0;
      if (page_b().items().is_out()) flag_i=0;
      if (page_b().items().position()==page_b().items().n_elements()) flag_d=0;

      if (flag_i) {  //balanceo con el hermano izquierdo
#ifdef DEBUG_BTREE_DEL
      cout<<"Balanceo Izquierdo IIIIIIIIIIIIIIIIIIIIIII\n";
#endif
        if (page_b().items().position()==1)
           l_page_c()=page_b().p0();
        else {
           page_b().items().prev();
           l_page_c()=page_b().items().item()().p();
           page_b().items().next();
        }
		  get(&page_c,l_page_c,level());
#ifdef DEBUG_BTREE_DEL
      disp(page_c,l_page_c);
#endif

        flag_cl=1;
        l_page_p.create();
        if (page_c().items().n_elements()>orden()) {
           num=(page_c().items().n_elements()-orden())/2+1;
           for (n=0;n<num;n++) {
              page_c().items().last();
              l_page_p()=page_c().items().item()().p();
				  page_c().items().item()().p()=l_page_a();
              page_b().items().item()().p()=page_a().p0();
              page_a().p0()=l_page_p();

              page_a().items().out();
              page_a().items().insert_r(page_b().items().item());
              page_b().items().item()=page_c().items().item();
              page_c().items().del();
           }
			  modify(&page_a,l_page_a,level());
			  modify(&page_b,l_page_b,level());
			  modify(&page_c,l_page_c,level());
#ifdef DEBUG_BTREE_DEL
      disp(page_a,l_page_a);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_b,l_page_b);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_c,l_page_c);
#endif

           return 1;
        }
		}

      if (flag_d) { //balanceo con el hermano derecho
#ifdef DEBUG_BTREE_DEL
            cout<<"Balanceo Derecho   DDDDDDDDDDDDDDDDDDDDDDD\n";
#endif
        if (page_b().items().is_out())
           page_b().items().first();
        else
           page_b().items().next();
        l_page_c()=page_b().items().item()().p();

#ifdef DEBUG_BTREE_DEL
		disp(page_b,l_page_b);
#endif
		  get(&page_c,l_page_c,level());
#ifdef DEBUG_BTREE_DEL
      disp(page_c,l_page_c);
#endif
        flag_cl=0;
        l_page_p.create();
        if (page_c().items().n_elements()>orden()) {
           num=(page_c().items().n_elements()-orden())/2+1;
           for (n=0;n<num;n++) {

              page_c().items().first();

              l_page_p()=page_c().p0();
              page_c().p0()=page_c().items().item()().p();
              page_c().items().item()().p()=l_page_c();
              page_b().items().item()().p()=l_page_p();

              page_a().items().out();
              page_a().items().insert_l(page_b().items().item());
              page_b().items().item()=page_c().items().item();
              page_c().items().del();
           }
			  modify(&page_a,l_page_a,level());
			  modify(&page_b,l_page_b,level());
			  modify(&page_c,l_page_c,level());
#ifdef DEBUG_BTREE_DEL
      disp(page_a,l_page_a);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_b,l_page_b);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_c,l_page_c);
#endif
           return 1;
        }
      }


      // union de las paginas
#ifdef DEBUG_BTREE_DEL
            cout<<"Union de Paginas   UUUUUUUUUUUUUUUUUUUUUUU\n";
#endif

      if (flag_cl) {
          page_p=page_a;
          page_a=page_c;
          page_c=page_p;
          l_page_p=l_page_a;
          l_page_a=l_page_c;
          l_page_c=l_page_p;
      }
      page_b().items().item()().p()=page_c().p0();
      page_a().items().out();
      page_a().items().insert_l(page_b().items().item());
      page_b().items().del();
      while(page_c().items().first()) {
			page_a().items().insert_l(page_c().items().item());
         page_c().items().del();
      }
#ifdef DEBUG_BTREE_DEL
      disp(page_a,l_page_a);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_b,l_page_b);
#endif
#ifdef DEBUG_BTREE_DEL
      disp(page_c,l_page_c);
#endif
		storage_C::del(l_page_c,level());
		modify(&page_a,l_page_a,level());
      l_page_a()=l_page_b();
      page_a=page_b;
      stack().pop();
   }

   if (page_a().items().n_elements()==0) {
#ifdef DEBUG_BTREE_DEL
      disp(page_a,l_page_a);
#endif
		set_root(page_a().p0,level());
		storage_C::del(l_page_a,level());
   }
   else
      modify(&page_a,l_page_a,level());
   return 1;
}


int btree_C::find_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	btree_page_B page_a;
	u_long_B     l_page_a;

	char flag=0;

	flag=find(key_paso,page_a,l_page_a,1);
	if (!flag) {
		flag=find(key_paso,page_a,l_page_a,1);
		if (flag) flag=3;
	}
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
	if (flag) key=key_paso;
	return flag;
}

int btree_C::find_exact_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	btree_page_B page_a;
	u_long_B     l_page_a;

	char flag=0;

	flag=find(key_paso,page_a,l_page_a,2);
	if (!flag) {
		flag=find(key_paso,page_a,l_page_a,1);
		if (flag) flag=3;
	}
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
	if (flag) key=key_paso;
	return flag;
}

int btree_C::first_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	key_paso().key()="";
	btree_page_B page_a;
	u_long_B     l_page_a;

	char flag=0;

	flag=find(key_paso,page_a,l_page_a,1,1);
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
	if (flag) key=key_paso;
	return flag;
}

int btree_C::next_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	key_paso().recpos()++;
	btree_page_B page_a;
	u_long_B     l_page_a;

	char flag=0;

	flag=find(key_paso,page_a,l_page_a,2,1);
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
	if (flag) key=key_paso;
	return flag;
}

int btree_C::last_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	key_paso().key()="";
	key_paso().prefix()+=" ";
	btree_page_B page_a;
	u_long_B     l_page_a;

	char flag=0;

	flag=findb(key_paso,page_a,l_page_a,2,1);
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
	if (flag) key=key_paso;
	return flag;
}

int btree_C::prev_key(key_B& key)
{
	key_B key_paso;
	key_paso.clone(key);
	key_paso().recpos()--;
#ifdef DEBUG_BTREE_PREV
	disp(key);
	disp(key_paso);
#endif
	btree_page_B page_a;
	u_long_B     l_page_a;
	char flag=0;
	flag=findb(key_paso,page_a,l_page_a,2,1);
	if (!flag) return 0;
	if (key_paso().prefix().compare(key().prefix())) flag=0;
#ifdef DEBUG_BTREE_PREV
	disp(key);
	disp(key_paso);
	cout<<(int)flag<<"\n";
#endif
	if (flag) key=key_paso;
	return flag;
}


void btree_C::disp(btree_page_B& page, u_long_B& l_page)
{
	int location=page().items().get_location();;
	cout <<"\npage:"<<l_page()<<":"<<location<<":"
	     <<page().items().n_elements()<<"\n";
	cout <<page().p0()<<"\n";
	if (page().items().first())
	do {
	  disp(page().items().item()().key);
	  cout<<page().items().item()().p()<<"\n";
	} while (page().items().next());
	page().items().set_location(location);
}

void btree_C::disp(key_B& key)
{
	cout<<(char*)key().prefix()<<":"<<(char*)key().key()<<":"
		 <<key().recpos()<<"\n";
}


int btree_C::add_key(key_B& key,int trans_param)
{
	 storage_trans_control_B trans_var;
	 set_active_trans(trans_param);
	 if (find_exact_key(key)) return 0;
	 if(!active_trans()) return add_key_nt(key);
	 trans_var.create();
	 trans_var().level()=btree_C::level();
	 key.encode(&trans_var().data);
	 add_trans(trans_var,ADDKEY_TRANS);
	 int trans_resp=active_trans();
	 begin_trans();
	 btree_C::add_key_nt(key);
	 end_trans();
	 set_active_trans(trans_resp);
	 return 1;
}

int btree_C::del_key(key_B& key,int trans_param)
{
	 storage_trans_control_B trans_var;
	 set_active_trans(trans_param);
	 if (!find_exact_key(key)) return 0;
	 if(!active_trans()) return del_key_nt(key);
	 trans_var.create();
	 trans_var().level()=btree_C::level();
	 key.encode(&trans_var().data);
	 add_trans(trans_var,DELKEY_TRANS);
	 int trans_resp=active_trans();
	 begin_trans();
	 btree_C::del_key_nt(key);
	 end_trans();
	 set_active_trans(trans_resp);
	 return 1;
}

int btree_C::undo(storage_trans_control_B& trans_param)
{
	  key_B key;
	  int trans_resp;
	  switch(trans_param().operation()) {
		  case  ADDKEY_TRANS:
				  btree_C::level()=trans_param().level();
				  key.decode(&trans_param().data);
				  trans_resp=active_trans();
				  begin_trans();
				  btree_C::del_key_nt(key);
				  end_trans();
				  set_active_trans(trans_resp);
				  return 1;
		  case  DELKEY_TRANS:
				  btree_C::level()=trans_param().level();
				  key.decode(&trans_param().data);
				  trans_resp=active_trans();
				  begin_trans();
				  btree_C::add_key_nt(key);
				  end_trans();
				  set_active_trans(trans_resp);
				  return 1;
	  }
	  return  storage_C::undo(trans_param);


}

int btree_C::commit(storage_trans_control_B& trans_param)
{
	 switch(trans_param().operation()) {
		 case ADDKEY_TRANS:
		 case DELKEY_TRANS:
			 return 1;
	 }
	 return storage_C::commit(trans_param);
}



