#ifndef _SPRLIBE_H_
#define _SPRLIBE_H_

#include "common.h"

class zSprHeader
{
private:
    WORD Size;
    char Name[MAXFILE+MAXEXT];
public:
    friend class zSprLib;
    _pascal_ zSprHeader( char *name = 0, WORD size=0 );
    _pascal_ ~zSprHeader() {}
};


class zSprData
{
private:
    zSprHeader SprHeader;
    char _FAR_ *Buf;
    zSprData *next;
public:
    friend class zSprLib;
    _pascal_ zSprData( void ):Buf(0),next(0) {}
    _pascal_ ~zSprData() { delete Buf; }
};


#define APPEND      1
#define REPLACE     2
#define INSERT      3

class zSprLib
{
private:
    int CurIdx;   // Index of cur pointer down the list
    zSprData *head, *cur, *tail;    // Link list important pointers
    char LibName[MAXPATH];  // Name of the Library using
    int  SpriteCount;  // Total number of sprites in the lib

    int  opened;  // File handle if the lib is open

    // Find the sprite in the list with sname, return 0 if not found.
    // store the found sprite's index in i
    zSprData * _pascal_ FindSpr( char *sname, int &i );

public:
    _pascal_ zSprLib( char *name = 0 );
    _pascal_ ~zSprLib();


    void _pascal_ SetName( char *name ) { strncpy( LibName, name, MAXPATH);}

    int _pascal_ Init( void );    // Open a new library.

    //
    // Add a sprite to end of list and return that sprite's number.
    // Returns -1 if failed and affects nothing.
    //
    int _pascal_ AddSpr( char _FAR_ *buf, WORD size, char *sname );
    //
    // Insert a sprite before the sprite with name insName.
    // Returns the index of the new sprite if suceed.
    // Else returns -1 without inserting the sprite and affects nothing.
    //
    int _pascal_ InsertSpr( char _FAR_ *buf, WORD size, char *sname,
                            char *insName );
    //
    // Swap sprite of sname1 with sprite of sname2 only if
    // both are found.
    // Return 0 if suceed.
    // Else returns -1 and affects nothing.
    //
    int _pascal_ SwapSpr( char *sname1, char *sname2 );

    //
    // Return index of the sprite if exist
    // Also sets 'cur' pointer to the sprite found.
    // otherwise affects nothing and returns -1
    //
    int _pascal_ SprExist( char *sname );

    //
    // Idx must equal to CurIdx, which is set by SprExist above.
    // Will return -1 if failed.  Otherwise returns Idx back.
    // These two act like replacing.
    //
    int _pascal_ PutCurSpr( int Idx, char _FAR_ *buf, WORD size );
    int _pascal_ PutSpr( char _FAR_ *buf, WORD size, char *sname );

    //
    // Returns the data to a sprite of sname and store its size in
    // 'size'.
    // Returns 0 and sets size to 0 if failed
    //
    const char _FAR_ * _pascal_ GetSpr( char *sname, WORD &size );

    //
    // Remove Sprite with name sname from memory.
    // Returns index of sprite remove.  If cur is the sprite removed,
    // then it's set to head.
    // Otherwise returns -1 on failure and affects nothing.
    //
    int _pascal_ DelSpr( char *sname );

    //
    // Returns the total number of sprites in the lib.
    //
    int _pascal_ HowMany( void ) { return SpriteCount; }

    //
    // Write the whole lib to file.
    // returns -1 if failed or total number of sprites saved to lib
    //
    int _pascal_ WriteLib( void );
    //
    // Read a Sprite Lib file.
    // Returns the total number of sprites read.
    // Otherwise returns -1 if failure.
    // If Type is:(Only implements APPEND.)
    //     APPEND -> Ignore BeforeWhich and add all sprites in the lib to
    //               tail.
    //     REPLACE ->Replace all sprites after and including sprite
    //               BeforeWhich - 1
    //     INSERT -> Insert before BeforeWhich
    //
    int _pascal_ ReadLib( int Type = APPEND, int BeforeWhich = 0 );

    //
    // Read a single sprite into the lib.
    // Returns the index of the sprite read down the list.
    // Otherwise returns -1 and affects nothing.
    // Type & Bwhich similar to above.(NOT IMPLEMENTED)
    //
    int _pascal_ ReadSpr( char *sname, int Type = APPEND, int BWhich = 0 );

    //
    // Write a single sprite from lib to a file as fname.
    // Return the Index of the sprite written.
    // Otherwise returns -1.
    //
    int _pascal_ WriteSpr( char *sname, char *fname );

    //
    // Get name of first sprite
    // Returns a char pointer to the name and sets 'cur' pointer
    // to head->next pointer and CurIdx to 1.
    // Otherwise returns 0 and affects nothing.
    //
    char * _pascal_ GetFirst( void );
    //
    // Get name of Current Pointer and advance the cur pointer to cur->next,
    // also increase CurIdx by 1.
    // Returns a char pointer to the name
    // Otherwise return 0 and affects nothing.
    //
    char * _pascal_ GetNext( void );

    //
    // Get the name of sprite with index 'i' down the list.
    // cur pointer and CurIdx will become that of the sprite found.
    // Returns a char pointer to the name.
    // Otherwise returns 0 and affects nothing.
    //
    char * _pascal_ GetNth( int i );
};

#endif
