/****************************************************************************/
/* TSCRBAR                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TScrollBar (Barre de dplacement)                                  */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 27/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <dos.h>
#include <stdlib.h>

#include "Const.h"

#include "JPAppli.h"

#include "Callback.h"
#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"

#include "TWindow.h"
#include "TScrBar.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y     : Coordonnes de la ScrollBar p/r au groupe             */
/* width,height     : Dimensions de la ScrollBar                            */
/* enabled          : ENABLED si la ScrollBar est activable (DISABLED sinon)*/
/****************************************************************************/

TScrollBar::TScrollBar(PObject parent,
                       TSbOrientation orientation,
		       int rel_x,int rel_y,
		       int length,
                       boolean enabled)
           :TObject(parent,
		    OBJ_SCROLL_BAR,
 		    rel_x,rel_y,
		    (orientation==SB_HORIZONTAL)?length:2,
                    (orientation==SB_HORIZONTAL)?1:length,
                    BLACK,
		    "",
		    enabled,
		    FALSE, // NOT_FOCUS_DEPENDING_ASPECT
		    TRUE,  // CAN_BE_ENABLED
		    TRUE)  // SIMPLE
{
  // Orientation de l'ascenseur

  f_orientation=orientation;

  // Valeur courante, et valeurs minimale et maximale de la ScrollBar

  f_value=0;
  f_min_value=0;
  f_max_value=100;

  // Diffrence entre f_max_value et f_min_value
  // Taille de la cage d'ascenseur moins celle de l'ascenseur

  f_values_range=f_max_value-f_min_value;
  f_empty_size  =(f_orientation==SB_HORIZONTAL)?(f_width-6):(f_height-3);

  // Incrments de f_value

  f_little_change=1;
  f_big_change=10;

  // Callback : Fonction appele quand la valeur de l'ascenseur change

  InitCallback(f_value_changed_action,f_value_changed_argument);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TScrollBar::~TScrollBar()
{
  // Destruction des variables dynamiques

  DestroyCallback(f_value_changed_action,f_value_changed_argument);
}

/*****************************************************************/
/* m_set_value : Modifie la valeur de la ScrollBar               */
/* -----------   (la restreint si besoin aux limites autorises) */
/*****************************************************************/

void TScrollBar::m_set_value(long value)
{
  if (value<f_min_value)
    value=f_min_value;
  else
    if (value>f_max_value)
      value=f_max_value;

  if (value!=f_value)
    {
      f_value=value;
      m_display_slider();

      CallCallback(this,f_value_changed_action,f_value_changed_argument);
    }
}

/****************************************************/
/* m_set_min_max_value : Modifie les valeurs min et */
/* -------------------   max de l'ascenseur         */
/****************************************************/

void TScrollBar::m_set_min_max_values(long min_value,long max_value)
{
  long old_value=f_value;

  if (max_value<min_value)
    max_value=min_value;

  f_min_value=min_value;
  f_max_value=max_value;

  f_values_range=f_max_value-f_min_value;

  // Pour que l'ascenseur soit raffich, il faut que la valeur
  // affecte soit diffrente de f_value

  f_value++;
  m_set_value(old_value);
}

/***************************************************************************/
/* m_set_value_changed_callback : Dfinition du callback associ  la      */
/* ----------------------------   modification de la valeur de la ScrollBar*/
/***************************************************************************/

void TScrollBar::m_set_value_changed_callback(void (*value_changed_action)(PObject,char *),
					      char *value_changed_argument)
{
  SetCallback(f_value_changed_action,f_value_changed_argument,
              value_changed_action,value_changed_argument);
}


/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TScrollBar::m_display()
{
  if (!f_open)
    return;

  m_display_arrows();
  m_display_slider();
}


/****************************************/
/* m_take_focus : Appele quand l'objet */
/* ------------   prend le focus        */
/****************************************/

void TScrollBar::m_take_focus()
{
  // Ne fait rien : la scrollbar ne prend jamais le focus

  return;
}

/***************************************************************************/
/* m_value_to_position : Convertit la valeur de l'ascenseur en sa position */
/* -------------------   cran (0 pour l'extrmit de la cage)             */
/***************************************************************************/

int TScrollBar::m_value_to_position(long value)
{
  return ((f_values_range==0)?(int) f_min_value
			     :(int)( ((value-f_min_value)*f_empty_size ) / f_values_range));
}

/**********************************************************************/
/* m_position_to_value : Convertit la position cran de l'ascenseur   */
/* -------------------   (0 pour l'extrmit de la cage) en sa valeur */
/**********************************************************************/

long TScrollBar::m_position_to_value(int position)
{
  long long_var,value;

  if (f_empty_size==0)
    return(f_min_value);

  long_var=(position*f_values_range)+f_empty_size-1;
  value=f_min_value+(long_var/f_empty_size);

  if (value<f_min_value)
    value=f_min_value;
  else
    if (value>f_max_value)
      value=f_max_value;

  return(value);
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/***********************************************/
/* m_display_slider : Affichage de l'ascenseur */
/* ----------------                            */
/***********************************************/


void TScrollBar::m_display_slider()
{
  register int i;
  int x,y;
  int slider_pos;
  char *vshaft_string,*vslider_string;
  char hshaft_char,hslider_char;

  int shaft_begin,shaft_end;

  if (!f_open)
    return;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  if (f_orientation==SB_HORIZONTAL)
    {
      shaft_begin=x+2;
      shaft_end=x+f_width-3;
      hshaft_char =SPECIAL_CHAR(SCH_SHAFT_HORIZONTAL);
      hslider_char=SPECIAL_CHAR(SCH_SLIDER_HORIZONTAL);
      vshaft_string = NULL;
      vslider_string= NULL;
    }
  else
    {
      shaft_begin=y+1;
      shaft_end=y+f_height-2;
      hshaft_char   = 0;
      hslider_char  = 0;
      vshaft_string =SPECIAL_STRING(SST_SHAFT_VERTICAL);
      vslider_string=SPECIAL_STRING(SST_SLIDER_VERTICAL);
    }

  if (!f_enabled)
    {
      f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);

      if (f_orientation==SB_HORIZONTAL)
	{
	  f_window->m_gotoxy(shaft_begin,y);
	  f_window->m_putnch(shaft_end-shaft_begin+1,hshaft_char);
	}
      else
	{
	  for (i=shaft_begin;i<=shaft_end;i++)
	    {
	      f_window->m_gotoxy(x,i);
	      f_window->m_puts(vshaft_string);
	    };
	}
    }

  else
    {
      slider_pos=shaft_begin+m_value_to_position(f_value);
      f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);

      if (f_orientation==SB_HORIZONTAL)
	{
	  f_window->m_gotoxy(shaft_begin,y);
	  f_window->m_putnch(slider_pos-shaft_begin,hshaft_char);
	  f_window->m_gotoxy(slider_pos+2,y);
	  f_window->m_putnch(shaft_end-slider_pos-1,hshaft_char);
	}
      else
	{
	  for (i=shaft_begin;i<slider_pos;i++)
	    {
	      f_window->m_gotoxy(x,i);
	      f_window->m_puts(vshaft_string);
	    };
	  for (i=slider_pos+1;i<=shaft_end;i++)
	    {
	      f_window->m_gotoxy(x,i);
	      f_window->m_puts(vshaft_string);
	    };
	}

      f_window->m_textattr((WHITE<<4)+(unsigned)BLACK);

      if (f_orientation==SB_HORIZONTAL)
	{
	  f_window->m_gotoxy(slider_pos,y);
	  f_window->m_putnch(2,hslider_char);
	}
      else
	{
	  f_window->m_gotoxy(x,slider_pos);
	  f_window->m_puts(vslider_string);
	}
    }
}

/*************************************************/
/* m_display_arrows : Affichage des flches aux  */
/* ----------------   extrmits de la ScrollBar */
/*************************************************/

void TScrollBar::m_display_arrows()
{
  int x,y;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  if (f_enabled)
    f_window->m_textattr((WHITE<<4)+(unsigned)BLACK);
  else
    f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);

  f_window->m_gotoxy(x,y);

  if (f_orientation==SB_HORIZONTAL)
    {
      f_window->m_display_arrow(ARROW_LEFT);
      f_window->m_gotoxy(x+f_width-2,y);
      f_window->m_display_arrow(ARROW_RIGHT);
    }
  else
    {
      f_window->m_display_arrow(ARROW_UP);
      f_window->m_gotoxy(x,y+f_height-1);
      f_window->m_display_arrow(ARROW_DOWN);
    }
}

/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable.           */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TScrollBar::m_left_button_pressed_event(int x,int y)
{
  int  button_state;
  int  x1,x2,
       y1,y2;

  int  *pos;

  int  shaft_begin;
  int  slider_pos;

  long new_value;
  boolean need_refresh=FALSE;

  if (!f_focused)
    {
      if (!m_set_focus())
        return(FALSE);
    }

  if (f_orientation==SB_HORIZONTAL)
    {
      x1=m_get_x();
      x2=x1+f_width-1;

      if ((x==x1) || (x==(x1+1)))
        return(m_arrow_pressed_event(x,y,LEFT));

      if ((x==x2) || (x==(x2-1)))
        return(m_arrow_pressed_event(x,y,RIGHT));

      shaft_begin=x1+2;
      slider_pos=shaft_begin+m_value_to_position(f_value);

      if (x<slider_pos)
	return(m_shaft_pressed_event(x,y,LEFT));
      if (x>(slider_pos+1))
        return(m_shaft_pressed_event(x,y,RIGHT));

      pos=&x;
    }

  else

    {
      y1=m_get_y();
      y2=y1+f_height-1;

      if (y==y1)
        return(m_arrow_pressed_event(x,y,UP));

      if (y==y2)
        return(m_arrow_pressed_event(x,y,DOWN));

      shaft_begin=y1+1;

      slider_pos=shaft_begin+m_value_to_position(f_value);

      if (y<slider_pos)
        return(m_shaft_pressed_event(x,y,UP));
      if (y>slider_pos)
        return(m_shaft_pressed_event(x,y,DOWN));

      pos=&y;
    }

  // On a vraiment cliqu sur l'ascenseur

  button_state=LEFT_BUTTON_PRESSED;
  need_refresh=TRUE;
  while (button_state==LEFT_BUTTON_PRESSED)
    {
      new_value=m_position_to_value((*pos)-shaft_begin);

      if (new_value!=f_value)
	{
	  m_set_value(new_value);
	  need_refresh=TRUE;
	}

      if (need_refresh)
	{
	  JPRefresh();
	  need_refresh=FALSE;
	}

      GetMouseState(x,y,button_state);

    }

  return(TRUE);
}

/*****************************************************************/
/* m_arrow_pressed_event : Evnement de clic sur une des flches */
/* ---------------------   aux extrmits de la ScrollBar        */
/*****************************************************************/

boolean TScrollBar::m_arrow_pressed_event(int x,int y,int direction)
{
  int  button_state;
  int  x1,x2,
       y1,y2;
  boolean first_scroll=TRUE;
  boolean need_refresh=FALSE;

  long new_value=0;

  x1=m_get_x();
  x2=x1+f_width-1;
  y1=m_get_y();
  y2=y1+f_height-1;

  button_state=LEFT_BUTTON_PRESSED;
  need_refresh=TRUE;
  while (button_state==LEFT_BUTTON_PRESSED)
    {
      switch (direction)
        {
          case LEFT : if (x<=(x1+1))
			new_value=f_value-f_little_change;
                      break;
          case RIGHT: if (x>=(x2-1))
                        new_value=f_value+f_little_change;
                      break;
	  case UP   : if (y<=y1)
                        new_value=f_value-f_little_change;
		      break;
          case DOWN : if (y>=y2)
			new_value=f_value+f_little_change;
                      break;
	}

      if (new_value!=f_value)
	{
	  m_set_value(new_value);
	  need_refresh=TRUE;
	}

      if (need_refresh)
	{
	  JPRefresh();
	  need_refresh=FALSE;
	}

      if (first_scroll)
	{
	  delay(SCROLLBAR_FIRST_SCROLL_SPEED);
	  first_scroll=FALSE;
	}
      else
	delay(SCROLLBAR_SCROLL_SPEED);

      GetMouseState(x,y,button_state);
    }

  return(TRUE);
}

/********************************************************************/
/* m_shaft_pressed_event : Evnement de clic                        */
/* ---------------------   dans la cage d'ascenseur de la ScrollBar */
/********************************************************************/

boolean TScrollBar::m_shaft_pressed_event(int x,int y,int direction)
{
  int *pos;
  int  button_state;
  int  shaft_begin;

  long new_value=0;
  long mouse_value;

  if (f_orientation==SB_HORIZONTAL)
    {
      shaft_begin=m_get_x()+2;
      pos=&x;
    }
  else
    {
      shaft_begin=m_get_y()+1;
      pos=&y;
    }


  // Au moins un dplacement

  switch (direction)
    {
      case LEFT  :
      case UP    : new_value=f_value-f_big_change;
		   break;
      case RIGHT :
      case DOWN  : new_value=f_value+f_big_change;
		   break;
    }
  m_set_value(new_value);
  JPRefresh();

  // Autres dplacements

  delay(SCROLLBAR_FIRST_SCROLL_SPEED);
  GetMouseState(x,y,button_state);

  while (button_state==LEFT_BUTTON_PRESSED)
    {
      mouse_value=m_position_to_value((*pos)-shaft_begin);

      switch (direction)
        {
          case LEFT :
          case UP   : if (mouse_value<f_value)
                        new_value=f_value-f_big_change;
                      break;
          case RIGHT:
          case DOWN : if (mouse_value>f_value)
                        new_value=f_value+f_big_change;
                      break;
        }

      if (new_value!=f_value)
	{
	  m_set_value(new_value);
	  JPRefresh();
	}

      delay(SCROLLBAR_SCROLL_SPEED);
      GetMouseState(x,y,button_state);
    }

  return(TRUE);
}

