//--------------------------------------------------------------------------
//
//      EXAMPLE1.CPP: example program 1 for DOS coroutine library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------

#include <iostream.h>
#include "coroutine.h"

//--------------------------------------------------------------------------
//
//      Class Example1.
//
//      This class is a coroutine which displays a message three times
//      before terminating.
//
class Example1 : public Coroutine
{
  public:
    Example1 (int n)        { num = n; }

  protected:
    virtual void main ();   // code to be executed by coroutine

  private:
    int num;                // coroutine identification number
};

//--------------------------------------------------------------------------
//
//      Example1::main.
//
//      This is the code executed by each instance of class Example1.
//      It displays a startup message, executes a loop three times to
//      display a progress message, then finally displays a termination
//      message.
//
void Example1::main ()
{
    cout << "Coroutine E" << num << " started\n";

    for (int i = 1; i <= 3; i++)
    {   cout << "Coroutine E" << num << ", iteration " << i << "\n";
        pause ();
    }

    cout << "Coroutine E" << num << " finished\n";
}

//--------------------------------------------------------------------------
//
//      The main program.
//
//      This just demonstrates creating and executing a set of coroutines.
//      Three instances of class Example1 are created and started.  The main
//      program then terminates.  Termination of the main program will not
//      complete until the coroutines it declares have also completed.
//
void main ()
{
    Example1 e1 (1), e2 (2), e3 (3);

    if (!e1.run ())
        cout << "Couldn't start e1\n";
    if (!e2.run ())
        cout << "Couldn't start e2\n";
    if (!e3.run ())
        cout << "Couldn't start e3\n";

}   //--- destructors called here: wait for coroutines to finish, then exit
