//------------------------------------------------------
// browse.cpp
//------------
//
// extern "C" function used
// area
// SetCursor
//
//------------------------------------------------------
//#include <iostream.h>
//#include <dos.h>
//#include <stdio.h>
//#include <string.h>

#include <conio.h>

#include "jobcode.h"
#include "browse.hpp"

extern helpscr();

static void cleararea(int StartRow, int StartCol, int StopRow,
          int StopCol, int ch, int Attr);
static void printxy(int x,int y, char* str, int color);
static void printn(int x,int y, char* str, int color, int num);
static void printch(int x,int y, int ch, int color);
 
static unsigned char far *PtrVideoMode = (unsigned char far*)0x00400049;
 
#define MAX_WIDTH 78
 
Browse::Browse(Btrieve *xbfhd, int pt, int pl, int pb, int pr,
	int pno_target_fld, char* ptarget_fld[],
    int pmaincolor, int ptitlecolor,int pfldcolor, int penhcolor)
{
    int i,width;
	bfhd=xbfhd;
    t=pt,l=pl,b=pb,r=pr;
    maincolor=pmaincolor;
    enhcolor=penhcolor;
    titlecolor=ptitlecolor;
    titlespacechar=32;
//    spacechar=177;
    spacechar=179;

    filterNo=0;
 
    no_rec_on_scr=b-t;      // take one out for title
    no_target_fld=pno_target_fld;
    target_fld=new int [no_target_fld];
    fld_width=new int [no_target_fld];
    fld_color=new int [no_target_fld];
 
    for (i=0;i<no_target_fld;i++)
        {
        target_fld[i]=bfhd->fPost(ptarget_fld[i]);
        switch (bfhd->fType(target_fld[i]))
            {
            case 'c':
            case 'y':       // Date
                width=bfhd->fWidth(target_fld[i])-1;
                break;
            case 'i':
                width=10;
                break;
            case 'l':
            case 'd':
            case 'f':
                width=10;
                break;
            }
        fld_width[i]= width > strlen(ptarget_fld[i]) ?
            width : strlen(ptarget_fld[i]);
        fld_width[i]=                               // avoid field width is
            fld_width[i]>r-l+1 ? r-l+1:fld_width[i];// greater than scr width
        fld_color[i]=pfldcolor;
        }
    // 
    // determine the start and end field on screen
    //
    StartField(0);
 
    MoveTop();
}
 
Browse::Browse(Btrieve *xbfhd, int pt, int pl, int pb, int pr,
    int pno_target_fld, int ptarget_fld[],
    int pmaincolor, int ptitlecolor,int pfldcolor, int penhcolor)
{
    int i,width;
	bfhd=xbfhd;
    t=pt,l=pl,b=pb,r=pr;
    maincolor=pmaincolor;
    enhcolor=penhcolor;
    titlecolor=ptitlecolor;
    titlespacechar=32;
//    spacechar=177;
    spacechar=179;

    filterNo=0;
 
    no_rec_on_scr=b-t;      // take one out for title
    no_target_fld=pno_target_fld;
    target_fld=new int [no_target_fld];
    fld_width=new int [no_target_fld];
    fld_color=new int [no_target_fld];
 
    for (i=0;i<no_target_fld;i++)
        {
        target_fld[i]=ptarget_fld[i];
        switch (bfhd->fType(ptarget_fld[i]))
            {
            case 'c':
            case 'y':       // Date
                width=bfhd->fWidth(ptarget_fld[i])-1;
                break;
            case 'i':
                width=10;
                break;
            case 'l':
            case 'd':
            case 'f':
                width=10;
                break;
            }
        fld_width[i]= width > strlen(bfhd->fName(ptarget_fld[i])) ?
            width : strlen(bfhd->fName(ptarget_fld[i]));
        fld_width[i]=                               // avoid field width is
            fld_width[i]>r-l+1 ? r-l+1:fld_width[i];// greater than scr width
        fld_color[i]=pfldcolor;
        }
    // 
    // determine the start and end field on screen
    //
    StartField(0);
 
    MoveTop();
}
 
Browse::Browse(Btrieve *xbfhd, int pt, int pl, int pb, int pr,
    int pmaincolor, int ptitlecolor,int pfldcolor, int penhcolor)
{
    int i,width;
	bfhd=xbfhd;
    t=pt,l=pl,b=pb,r=pr;
    maincolor=pmaincolor;
    enhcolor=penhcolor;
    titlecolor=ptitlecolor;
    titlespacechar=32;
//    spacechar=177;
    spacechar=179;
 
    filterNo=0;

    no_rec_on_scr=b-t;      // take one out for title
    no_target_fld=bfhd->fNumber();
    target_fld=new int [no_target_fld];
    fld_width=new int [no_target_fld];
    fld_color=new int [no_target_fld];
 
    for (i=0;i<no_target_fld;i++)
        {
		target_fld[i]=i;
        switch (bfhd->fType(i))
            {
            case 'c':
            case 'y':       // Date
				width=bfhd->fWidth(i)-1;
                break;
            case 'i':
                width=10;
                break;
            case 'l':
            case 'd':
            case 'f':
                width=10;
                break;
            }
        fld_width[i]= width > strlen(bfhd->fName(i)) ?
            width : strlen(bfhd->fName(i));
        fld_width[i]=                               // avoid field width is
            fld_width[i]>r-l+1 ? r-l+1:fld_width[i];// greater than scr width
        fld_color[i]=pfldcolor;
        }
    // 
    // determine the start and end field on screen
    //
    StartField(0);

	MoveTop();
}
 
Browse::~Browse()
{
	delete target_fld;
	delete fld_width;
	delete fld_color;
    for (int i=0;i<filterNo;i++)
        delete filterVal[i];
}
 
void Browse::Paint()
{
	int x,y,i,j;
 
	x=t;
	y=l;
	for (j=LfRtScrFld[0];j<=LfRtScrFld[1];j++)
		{
		if (j!=LfRtScrFld[0])
            {
			y+=(fld_width[j-1]+1);
            printch(x,y-1,titlespacechar,titlecolor);
            }
        cleararea(x,y,x,y+fld_width[j]-1,32,titlecolor);
        printxy(x,y,bfhd->fName(target_fld[j]),titlecolor);
		}
    if (y+fld_width[j-1]<r)
        {
        cleararea(t,y+fld_width[j-1],t,r,32,titlecolor);
        cleararea(t+1,y+fld_width[j-1],b,r,32,maincolor);
        }
	x++;
 
	scr_top=bfhd->GetPost();
	for (i=0;i<b-t;i++)
		{
		y=l;
		for (j=LfRtScrFld[0];j<=LfRtScrFld[1];j++)
			{
			if (j!=LfRtScrFld[0])
                {
                y+=(fld_width[j-1]+1);
                printch(x,y-1,spacechar,maincolor);
                }
			DisplayOneField(x,y,j, fld_color[j]);
			}
		if (i==(b-t-1))  		// reach the bottom line
			break;
        if (MoveDown())    // end of file
			break;
		x++;
		}
	scr_bot=bfhd->GetPost();
	bfhd->GoTo(scr_top);
	no_rec_on_scr=i+1;
    if (t+no_rec_on_scr<b)
        cleararea(t+no_rec_on_scr+1,l,b,r,32,maincolor);
}
 
void Browse::DisplayOneField(int x, int y, int fno, int clr)
{
    char buf[80],*p;
 
    cleararea(x,y,x,y+fld_width[fno]-1,32,clr);
 
    switch (bfhd->fType(target_fld[fno]))
        {
        case 'c':
            printn(x,y,bfhd->fStr(target_fld[fno]),clr,fld_width[fno]);
			break;
        case 'y':
            p=bfhd->fStr(target_fld[fno]);
            convertDate(p,buf);
            printn(x,y,buf,clr,8);
			break;
		case 'i':
            sprintf(buf,"%10.d",bfhd->fInt(target_fld[fno]));
            printxy(x,y,buf,clr);
			break;
		case 'l':
            sprintf(buf,"%10.ld",bfhd->fLong(target_fld[fno]));
            printxy(x,y,buf,clr);
			break;
		case 'd':
            sprintf(buf,"%10.2f",bfhd->fDouble(target_fld[fno]));
            printxy(x,y,buf,clr);
			break;
		case 'f':
            sprintf(buf,"%10.2f",bfhd->fFloat(target_fld[fno]));
            printxy(x,y,buf,clr);
			break;
        }
}
 
void Browse::FieldColor(int fno, int fcolor)
{
    fld_color[fno]=fcolor;
}
 
void Browse::MainColor(int clr)
{
    maincolor=clr;
}
 
void Browse::TitleColor(int clr)
{
    titlecolor=clr;
}
 
void Browse::EnhancedColor(int clr)
{
    enhcolor=clr;
}
 
Browse::Show(int simulate, int startFromTop)
{
    int i,rc,fld_post,repaint=0;
 
    cleararea(t,l,b,r,32,maincolor);
 
    if(startFromTop)        // start form top
    {
        MoveTop();
        if (bfhd->Err())
            return -1;
    }
    else                    // start from current position, default
    {
        if(!ValueOk())      // if current record's value OK, skip it
        {
            MoveDown();
            if (bfhd->Err())
                return -1;
        }
    }
	Paint();
    row=t+1,col=l;
    fld_post=LfRtScrFld[0];
 
	for (;;)
    {
		if (repaint)
        {
			repaint=0;
			Paint();
        }
        if (simulate==0)
            area(row,col,row,col+fld_width[fld_post]-1,enhcolor);
        SetCursor(row,col);
        rc=waitKey(simulate);
        if (simulate==0)
            area(row,col,row,col+fld_width[fld_post]-1,fld_color[fld_post]);
 
        if (rc==ESC)
			break;
        if (rc==ENTER)
        {
            bfhd->GoTo(scr_top);
            for (i=0;i<row-(t+1);i++)
                if (MoveDown())
                    break;
            break;
        }
        switch (rc)
        {
            case UP:
                if (row==t+1)   // reach the top line
                {
                    bfhd->GoTo(scr_top);
                    if (!MoveUp())
                        repaint=1;
                    else
                        bfhd->GoTo(scr_top);
                }
                else
					row--;
				break;
            case DOWN:
                if (row>=t+no_rec_on_scr)
                {
                    bfhd->GoTo(scr_bot);
                    if (!MoveDown())
                    {
                        bfhd->GoTo(scr_top);
                        MoveDown();
                        repaint=1;
                    }
                    else
                        bfhd->GoTo(scr_top);
                }
                else
					row++;
				break;
            case RIGHT:
            case TAB:
                bfhd->GoTo(scr_top);
                if (fld_post<LfRtScrFld[1])
                {
					col+=(fld_width[fld_post]+1);
					fld_post++;
                }
                else        // over boundary
                {
                    if (LfRtScrFld[1]<no_target_fld-1)// more field on the right
                    {
                        StartField(LfRtScrFld[1]+1);
                        repaint=1;
                        fld_post=LfRtScrFld[0];
                        col=l;
                    }
                }
				break;
            case LEFT:
            case SHIFT_TAB:
                bfhd->GoTo(scr_top);
				if (fld_post>LfRtScrFld[0])
                {
                    fld_post--;
                    col-=(fld_width[fld_post]+1);
                }
                else
                 {
					if (LfRtScrFld[0]>0)       // more field on the left
                    {
                        EndField(LfRtScrFld[0]-1);
                        repaint=1;
                        fld_post=LfRtScrFld[0];
                        col=l;
                    }
                }
                break;
			case PGDN:
				bfhd->GoTo(scr_bot);
                if (!MoveDown())
                {
                    row=t+1;
					repaint=1;
                }
                else
                    bfhd->GoTo(scr_top);
				break;
            case PGUP:
                bfhd->GoTo(scr_top);
                if (!MoveUp())
                {
					for (i=1;i<b-t;i++)
                    {
                        if (MoveUp())
                            break;
                    }
                    row=t+1;
                    repaint=1;
                }
                else
                    bfhd->GoTo(scr_top);
                break;
            case CTRL_HOME:
                MoveTop();
                row=t+1;
                repaint=1;
                break;
            case CTRL_END:
				MoveEnd();
                for (i=1;i<b-t;i++)
                {
                    if (MoveUp())
                        break;
                }
                row=t+1;
                repaint=1;
                break;
            case HOME:
                bfhd->GoTo(scr_top);
                StartField(0);
                fld_post=LfRtScrFld[0];
                col=l;
                repaint=1;
                break;
            case END:
                bfhd->GoTo(scr_top);
                EndField(no_target_fld-1);
                fld_post=LfRtScrFld[0];
                col=l;
                repaint=1;
                break;
            case F5:
                Seek(NULL);
                row=t+1;
                repaint=1;
                break;
        }
    }
    return rc;
}
 
void Browse::StartField(int pfld)
{
	int i,total_scr_width=0;
 
    for (i=pfld;i<no_target_fld;i++)
		{
		total_scr_width+=fld_width[i];
        total_scr_width+=1;             // space between field
        if (total_scr_width > r-l+1)
			break;
		}
	LfRtScrFld[0]=pfld;
	LfRtScrFld[1]=i-1;
}
 
void Browse::EndField(int pfld)
{
    int i,space=0,total_scr_width=0;
 
	for (i=pfld;i>=0;i--)
		{
		total_scr_width+=fld_width[i];
        total_scr_width+=1;             // space between field
		if (total_scr_width > r-l+1)
            break;
        }
    LfRtScrFld[0]=i+1;
    LfRtScrFld[1]=pfld;
 
}
 
static void cleararea(int StartRow, int StartCol, int StopRow,
          int StopCol, int ch, int Attr)
{
 
	register int Row, Col;
	int CharPerRow, Delta;
	char far *Video;
//    unsigned char far *PtrVideoMode = (unsigned char far*)0x00400049;
	if(*PtrVideoMode ==7)
		Video=(char far *)MK_FP(0xb000,0000);
	else
		Video=(char far *)MK_FP(0xb800,0000);
    Video+=(StartRow*160+StartCol*2);
 
	CharPerRow = StopCol-StartCol+1;
 
    Delta = 160-(StopCol-StartCol+1)*2;
 
    for(Row=1; Row<= StopRow - StartRow+1; ++Row)
        {
        for(Col=1; Col<=CharPerRow; ++Col)
            {
            *Video++=(char)ch;
            *Video++=(char)Attr;
            }
		Video += Delta;
        }
}
 
static void printxy(int x,int y, char* str, int color)
{
    int num=strlen(str);
    printn(x,y,str,color,num);
}
static void printn(int x,int y, char* str, int color, int num)
{
    register int row, col;
    char far *video;
//    unsigned char far *PtrVideoMode = (unsigned char far*)0x00400049;
	if(*PtrVideoMode ==7)
        video=(char far *)MK_FP(0xb000,0000);
	else
        video=(char far *)MK_FP(0xb800,0000);
    video+=(x*160+y*2);
 
    for (int i=0;i<num;i++)
        {
        *video++=*str++;
        *video++=color;
        if (*str=='\0')
            break;
        }
 
}
 
static void printch(int x,int y, int ch, int color)
{
    register int row, col;
    char far *video;
	if(*PtrVideoMode ==7)
        video=(char far *)MK_FP(0xb000,0000);
	else
        video=(char far *)MK_FP(0xb800,0000);
    video+=(x*160+y*2);
    *video++=ch;
    *video=color;
}

int Browse::waitKey(int tick)
{
    static int count=0;
    int rc;
    union  REGS  regs ;
    regs.h.ah = 0x7 ;
    while(1)
    {
        if(kbhit())
        {
            int86( 0x21, &regs, &regs ) ;

            if ( regs.h.al != 0 )
            {
                rc=(int) regs.h.al ;
                break;
            }
            int86( 0x21, &regs, &regs ) ;
            rc=(int) (regs.h.al << 8) ;
            if(rc==F1)
                helpscr();
            else
                break;
        }
        if (tick==0)
            continue;
        if (count++>tick)
        {
            count=0;
            Paint();
        }
    }
    return (rc);
}

void Browse::GapChar(int ch)
{
    spacechar=ch;
}
 
int Browse::Seek(char* target)
{
    int oldrow,oldcol;
    cleararea(t,l,t,r,32,titlecolor);
    printxy(t,l,"Search?",titlecolor);

    if (target==NULL)
    {
        int len=bfhd->KeyLength(bfhd->ActiveIndex());
        char* buf=new char [len];
        memset(buf,32,len);
        buf[len-1]='\0';

        oldrow=ClockRow,oldcol=ClockCol;
        ClockRow=-1,ClockCol=-1;

        GETc(t,l+8,buf);    UpperGET();
        int rc=ReadGETs(ESC,ENTER,F4,0);

        ClockRow=oldrow,ClockCol=oldcol;

        if (rc!=ESC)
            bfhd->GetGEqual(buf);

		delete buf;
	}
	else
        bfhd->GetGEqual(target);

    return bfhd->Err();
}

void Browse::KillFilter()
{
    filterNo--;
    delete filterVal[filterNo];
}

void Browse::Filter(char* pfldname, char* pfldval)
{
    filterNo++;
    filterFld[filterNo-1]=bfhd->fPost(pfldname);

    int pwidth=bfhd->fWidth(filterFld[filterNo-1]);
    filterVal[filterNo-1]=new char [pwidth];
    //
    // pad rest space with ASC(32)
    //
    int len=strlen(pfldval)+1;
    memcpy(filterVal[filterNo-1],pfldval,len);
    for (int i=len-1;i<pwidth-1;i++)
        filterVal[filterNo-1][i]=32;
    filterVal[filterNo-1][pwidth-1]='\0';
}

void Browse::Filter(int pfldno, char* pfldval)
{

    filterNo++;
    filterFld[filterNo-1]=pfldno;
    int pwidth=bfhd->fWidth(filterFld[filterNo-1]);

    filterVal[filterNo-1]=new char [pwidth];

    int len=strlen(pfldval)+1;
    memcpy(filterVal[filterNo-1],pfldval,len);

    for (int i=len-1;i<pwidth-1;i++)
        filterVal[filterNo-1][i]=32;
    filterVal[filterNo-1][pwidth-1]='\0';
}

//----------------------------------
// only char field is filterable now
//
//----------------------------------
Browse::ValueOk()
{
    int i,ok;
    ok=1;
    for (i=0;i<filterNo;i++)
    {
        if (strcmp(bfhd->fStr(filterFld[i]),(char*)filterVal[i]))
        {
            ok=0;
            break;
        }
    }
    return ok;
}

Browse::MoveTop()
{
	bfhd->GetFirst();
    if (filterNo>0)     // any filter
    {
        for (;;)
        {
            if (ValueOk() || bfhd->Err())
                break;
            bfhd->GetNext();
        }
    }
    return bfhd->Err();
}

Browse::MoveEnd()
{
	bfhd->GetLast();
    if (filterNo>0)     // any filter
    {
        for (;;)
        {
            if (ValueOk() || bfhd->Err())
                break;
            bfhd->GetPrev();
        }
    }
    return bfhd->Err();
}

Browse::MoveUp()
{
	bfhd->GetPrev();
    if (filterNo>0)     // any filter
    {
        for (;;)
        {
            if (ValueOk() || bfhd->Err())
                break;
            bfhd->GetPrev();
        }
	}
    return bfhd->Err();
}

Browse::MoveDown()
{
	bfhd->GetNext();
    if (filterNo>0)     // any filter
    {
        for (;;)
        {
            if (ValueOk() || bfhd->Err())
                break;
            bfhd->GetNext();
        }
    }
    return bfhd->Err();
}
//
// return the top rec position
//
long Browse::TopRecNum()
{
    return scr_top;
}

long Browse::BotRecNum()
{
    return scr_bot;
}
