        /* sendbyte */

        /* In wires.lib */

        #include <rs.h>
        #include <subwires.h>

                
/************************************************************************
*                                                                       *
*       Send a byte to the BBC.Send in 3 slices,setting up a parity bit *
*       for the last slice,hence 9 bits altogether.Each slice has the   *
*       same protocol:-                                                 *
*                                                                       *
*               Is BBC ready ? (Wait for Rx=0)                          *
*               Load the Data port,and send (Set_Tx)                    *
*               Has BBC acknowledged? (Wait for Rx=1)                   *
*               Confirm the Acknowledge (Clear_Tx)                      *
*                                                                       *
*       Then,after the last slice is sent,there is a final wait for     *
*       the BBC to settle(Rx=0).                                        *
*                                                                       *
*       See 'subwires.h' for comments on Timeout.                       *
*                                                                       *
*       N.B.In all these slices,the higher 5 bits of the byte being     *
*       sent will be zero,therefore the Tx line will not be set until   *
*       Tx() is called.                                                 *
*                                                                       *
*                                                       17.02.1995.     *
************************************************************************/

        byte sendbyte(x)
        byte x; 
        {
        byte X; 
        unsigned long systime0,systime1;
        if (!SENDING) return(6);        /* Wrong mode */
/*
*       1st Slice:-
*/
/*      Wait for BBC ready:-                                             */
        getsyst(&systime0);
        while (Rx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        X=x&7;                             /* Get lower 3 bits */
        X=Tmask(X);                        /* Set up Transmit byte */
        out8(PORT_OUT,X);                  /* Fire it off */
        if (!Set_Tx()) return(6);          /* Tell BBC it's there */
/*
*       Wait for BBC to acknowledge:-
*/
        getsyst(&systime0);
        while (Rx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        if (!Clear_Tx()) return(6);        /* Confirm the acknowledge */
/*
*       2nd Slice:-
*/
/*      Wait for BBC ready:-                            */
        getsyst(&systime0);
        while (Rx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        X=(x&56)>>3;                       /* Get middle 3 bits */
        X=Tmask(X);                        /* Set up Transmit byte */
        out8(PORT_OUT,X);                  /* Fire it off */
        if (!Set_Tx()) return(6);          /* Tell BBC it's there */
/*
*       Wait for BBC to acknowledge:-
*/
        getsyst(&systime0);
        while (Rx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        if (!Clear_Tx()) return(6);        /* Confirm the acknowledge */
/*
*       Last Slice:-
*/
        X=(x&192)>>6;                      /* Get top 2 bits */
        X=X|(evenprty(x)<<2);              /* Add parity bit */
        X=Tmask(X);                        /* Set up Transmit byte */
/*      Wait for BBC ready:-                            */
        getsyst(&systime0);
        while (Rx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        out8(PORT_OUT,X);                  /* Fire it off */
        if (!Set_Tx()) return(6);          /* Tell BBC it's there */
/*
*       Wait for BBC to acknowledge:-
*/
        getsyst(&systime0);
        while (Rx()!=1) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        if (!Clear_Tx()) return(6);        /* Confirm the acknowledge */
/*
*       Wait for BBC to settle before returning:-
*/
        getsyst(&systime0);
        while (Rx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        return(TRUE);
        }
