; CLOCKRES.ASM

; TSR or C callable clock routine.
; 
; For What It's Worth, this thing is FREE.
; Please keep the original files together and distribute them unchanged!
; 
; David C. Schooley  (CIS 72571,2543)
; Birmingham, AL and Stillwater, OK (GO Pokes!!!)
; October 1990

IDEAL


TSR	EQU 0	; 1 for TSR, 0 for C callable

ATBIOS	EQU 0	; Smaller code for machines that support function 2
		;  of INT 1AH will be assembled if ATBIOS is defined
		;  to be nonzero

REFRESH EQU 0	; Set to 1 to update display during every clock
		; tick, 0 to update display only when time
		; changes.

IFE TSR
MODEL SMALL	; Change this to the correct memory model
ENDIF




IF TSR
SEGMENT CODE WORD PUBLIC 'CODE'
	ASSUME CS:CODE
		ORG	100H

ENDIF
Begin:	

IF TSR
	JMP	Init


ELSE

PUBLIC _TimerHit
PUBLIC _oldint1C
PUBLIC _ClockPosition

DATASEG

ENDIF

IFE ATBIOS
;
; Lookup table for converting hex values to binary coded decimal.
; It's only assembled if ATBIOS is defined to be equal to 0.
;
Tbl		db	0,1,2,3,4,5,6,7,8,9
Tbl2		db	10H,11H,12H,13H,14H,15H,16H,17H,18H,19H
Tbl3		db	20H,21H,22H,23H,24H,25H,26H,27H,28H,29H
Tbl4		db	30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
Tbl5		db	40H,41H,42H,43H,44H,45H,46H,47H,48H,49H
Tbl6		db	50H,51H,52H,53H,54H,55H,56H,57H,58H,59H
ENDIF

_ClockPosition		dw	0
LastTime		dw	?
Hour			dw	?
Colon		db	':'
Minutes		dw	? 
Space		db	' '
AMPM			db	'     ' ;
Seconds		dw	?
LastMinutes	db	? 
PM			db	'p.m.'
AM			db	'a.m.'

_oldint1C		dd	?


IFE TSR

CODESEG

ENDIF

PROC		ConvertToASCII	;	Takes value in AL
				;	Offset of variable in DI
		ADD	AL,30H    	
StoreIt:	STOSB
		RET

ENDP	ConvertToASCII

PROC	_TimerHit

; Call the old interrupt handler
		PUSHF
		CALL [_oldint1C]

IF TSR
; Let's be nice!
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	BP
		PUSH	DI
		PUSH	SI
		PUSH	DS
		PUSH	ES

; This part is should not be used when doing using interrupt functions in TC.
		MOV	AX,CS
		MOV	DS,AX

ELSE
; TC sets up DS for us,
		MOV	AX,DS

ENDIF
; This part should always be assembled.
		MOV	ES,AX
		
; Disable interrupts.
		CLI

IF ATBIOS
; Get the current time.
		MOV	AH,02H
		INT	1AH
		MOV	BX,CX		
ELSE

; Get tick count since midnight
		XOR	AH,AH
		INT	1AH

; The value in the CX register is pretty close to the correct hour.
; Convert it to BCD.
		XCHG	AL,CL
		MOV	BX,OFFSET Tbl
		XLAT
		MOV	SI,AX	; Hour is now in low byte of SI
		
		MOV	AX,DX
		XOR	DX,DX
		MOV	CX,445H
		DIV	CX
		XLAT

		MOV	BX,SI
		XCHG	BH,BL

		MOV	BL,AL	; Min is now in BL


ENDIF

IFE REFRESH
		CMP	[LastTime],BX
		JNE	Update
		JMP	Finish
ENDIF

; BH - hour, BL - minutes, DH - seconds, all values in binary coded
; decimal.

; See if it's morning or afternoon.
Update:

IFE REFRESH
		MOV	[LastTime],BX
ENDIF
		CMP	BH,12H
		JB	InTheAM

; Set up the p.m.
		MOV	SI,OFFSET PM
		MOV	DI,OFFSET AMPM
		MOV	CX,2
		REP	MOVSW

		CMP	BH,12H
		JE	PutInAL

; Subtract 12 in BCD
		MOV	AL,BH
		SUB	AL,12H
		DAS
		MOV	BH,AL	
		JMP SHORT NotMidNight

; Set up the a.m.
InTheAM:        MOV	SI,OFFSET AM
		MOV	DI,OFFSET AMPM
		MOV	CX,2
		REP	MOVSW

	        TEST	BH,BH ; between midnight and 1.00 a.m.
		JNZ	PutInAL
		MOV	BH,12H
PutInAL:	MOV	AL,BH
NotMidNight:	MOV	CX,4

; Display the hour
		SHR	AL,CL
		MOV	DI,OFFSET Hour
		CALL    ConvertToASCII

		MOV	AL,BH
		AND	AL,0FH
		CALL	ConvertToASCII

		CMP	BH,10H
		JAE	AfterNine
		MOV	[BYTE Hour],0

; Display the minutes
AfterNine:	MOV	AL,BL
		MOV	DI,OFFSET Minutes
		SHR	AL,CL
		CALL	ConvertToASCII

		MOV	AL,BL
		AND	AL,0FH
		CALL 	ConvertToASCII

		MOV	[Colon],':'

; Get the cursor position.
		MOV	AH,03H			
		XOR	BH,BH
		INT	10H
                PUSH	DX

; Write the string in the position determined by the contents of DX.
		MOV	AX,1300H		
		MOV	BX,0007H
		MOV	CX,OFFSET LastMinutes - OFFSET Hour

		MOV	DX,[_ClockPosition]
		MOV	BP,OFFSET Hour
		INT	10H

; Put the cursor back where you found it!
		MOV	AH,02H
		POP	DX
		INT	10H

; Clean up the mess.		
Finish:	STI


IF TSR
		POP	ES
		POP	DS
		POP 	SI
		POP 	DI
		POP  BP
		POP 	DX
		POP 	CX
		POP 	BX
		POP 	AX

		IRET
ELSE

		RET

ENDIF

ENDP	_TimerHit

IF TSR

Init:	MOV	BX,2CH
		MOV	ES,[BX]
		MOV	AH,49H
		INT	21H

		MOV	AX,351CH
		INT	21H
		MOV	[WORD _oldint1C],BX
		MOV	[WORD _oldint1C+2],ES
		CLI
		MOV	AX,251CH
		MOV	DX,OFFSET _TimerHit
		INT	21H			;Initialize the timer
		STI

		MOV	DX,OFFSET Init
		INT	27H


ENDS	CODE


ENDIF
		END Begin