* Program: UDF.prg
* Author:  Don L. Powells
* Version: Clipper Summer '87
* Note(s): Two samples of User-Defined Functions (UDFs).
*
* Copyright (c) 1988, 1989 Nantucket Corp.  All Rights Reserved.


* Saycenter()
* Centers a string on a given row.
* Usage: Saycenter(row#, expC)
*
FUNCTION Saycenter
PARAMETERS trow, in_string
IF LEN(in_string) >= 80
   @ trow, 0 SAY in_string
ELSE
   @ trow, (80 - LEN(in_string))/2 SAY in_string
ENDIF
RETURN (.T.)


* Dupcheck()
* Checks for the existence of the specified value in specified
* file and index, and returns a true if the value is found.
*
FUNCTION Dupcheck
PRIVATE mvalue, mfile, mntx, mntxkey

* Save the current workarea number
currarea = SELECT()

* Check for the existence of the database
IF FILE(mfile + ".dbf")
   * Select or open the database and index files.
   IF SELECT(mfile) = 0
      * Go to next available workarea.
      SELECT 0
      USE (mfile)
      IF FILE(mntx + ".ntx")
         SET INDEX TO (mntx)
      ELSE
         * Create the index if it does not exist.
         INDEX ON (mntxkey) TO (mntx)
      ENDIF
   ELSE
      * Save the current workarea and select the new one.
      wkarea = SELECT(mfile)
      SELECT (wkarea)
   ENDIF
   currec = RECNO()
   SEEK mvalue
   retval = FOUND()
   GO currec
ELSE
   retval = .F.
ENDIF
RETURN(retval)

* EOP: UDF.prg
