;
;****************************************************************
;                                                               *
;       CLIPPER ROUTINE - CURSOR ON / OFF ( IBM PC ONLY )       *
;                      By Kelly Mc Tiernan                      *
;                                                               *
;****************************************************************
;
;
;       This routine is called to turn the cursor on and off.
;       It is a toggle i.e. - call to turn off, upon next call,
;       cursor is turned on.
;
;       CALL CURSW
;       * Do video i/o
;       CALL CURSW
;       * Get input 
;
;       Also provides for manual over - ride via WITH <param> ->
;
;       CALL CURSW WITH "ON"
;       CALL CURSW WITH "OFF"
;
;       *** NOTE: COMMAND MUST BE CAPS ! ***
;
PUBLIC	cursw
;
video	EQU	10h            ; ROM BIOS video interupt
curlin	EQU	01h            ; Set cursor lines function
offlin	EQU	0FF00h         ; Works with MOST PC compatables !
colcur	EQU	0A0Bh          ;   "    "    "   "    "   "  "  !
eqpchk	EQU	11h            ; equipment check interupt
off		EQU	0FFh           ; Flag test value, cursor off ?
on		EQU	00h            ; Flag for cursor on.
bw		EQU	30h            ; bits indicate B/W card.
;

_PROG	SEGMENT	BYTE
		ASSUME	CS:_PROG
;
cursw	PROC		FAR
		push		bp                      ; standard setup, param's
		mov		bp,sp                   ;
		push		ds                      ; save, need for string compare
		push		es                      ;  "  ,   "   "     "    "  "
		cld                               ; assure proper direction for cmpsb
		cmp		byte ptr cs:[fstpas],0  ; check display type on first pass
		jnz		docurs			    ; set start/stop line on first
		mov		byte ptr cs:[fstpas],1  ; to skip this after first time
		int		eqpchk			    ; check if color / mono board
		and		ax,bw			    ; black and white ?
		cmp		ax,bw			    ;
		jnz		docurs			    ; color, leave as 0707h
		mov		word ptr cs:[onlin],colcur
docurs:
		mov		ah,curlin               ; set up for cursor on/off function
		lds		si,dword ptr [bp + 6]   ; address of command param. if inc.
		mov		bx,si                   ; save for "OFF" command check
		push		cs                      ; get segment
 		pop		es                      ; for compare
		mov		di,offset cs:oncmd      ; get offset for compare
		mov		cx,3                    ; length of on command
		rep		cmpsb                   ; compare string - WITH "ON" ?
		jnz		offtst                  ; not "ON" command, check for "OFF"
		mov		byte ptr cs:[curflg],off ; set flag accordingly
		mov		cx,cs:[onlin]           ; turn it on
		jmp		short curon             ; ( save a byte )
offtst:
		mov		si,bx                   ; get back param. ptr.
		mov		di,offset cs:offcmd     ; and table ptr.
		mov		cx,4                    ; length of "OFF" string
		rep		cmpsb                   ; compare string - WITH "OFF"
		jnz		switch                  ; no over - ride, do toggle
		mov		byte ptr cs:[curflg],on ; set flag
		mov		cx,offlin               ; turn it off
		jmp		short curon             ;
switch:
		mov		cx,cs:[onlin]           ; default is turn off, is it off ?
		cmp		byte ptr cs:[curflg],off
		jz		curon                   ; yes, turn it on
		mov		cx,offlin               ; change up
curon:
		int		video                   ; set cursor lines
		not		byte ptr cs:[curflg]    ; flip switch flag
		pop		es                      ; restore state, normalize stack
		pop		ds                      ;
		pop		bp                      ;
		ret
cursw	ENDP
;
curflg	DB		00h                     ; ON / OFF FLAG - INIT. SET TO ON
fstpas	DB		00h		              ; for equip check on first pass
oncmd	DB		'ON',0                  ; WITH PARAM - ON COMMAND
offcmd	DB		'OFF',0                 ;  "     "   - OFF COMMAND
onlin	DW		0707h		         ; default cursor ( COLOR / MONO )
;
_PROG	ENDS
		END

