/* ---------------------- Dot Command 2.31-------------------------

   Copyright 1993-1994, Hong Kong, C.K.Hung.  All rights reserved.

   Compile :  clipper dot     /a /n [/d_RDD] [/d_SHARE]
              clipper shell   /a /n
              clipper clfunc  /a /n [/d_RDD]
   Link    :  blinker fi dot,shell,clfunc lib ck20 @cl520mid.lnk

   or compile+link with :   cldot <enter>
                            rcldot <enter>     // Rdd Version

   Usage   :  [Path] DOT [Path] [MacroPrg]
              [Path] RDOT [Path] [MacroPrg]    // Rdd Version

------------------------------------------------------------------- */

#define  _REQUEST       //
#define  _ALL           // request all functions in Casual-Kit
#include 'CKHEADER.CH'  //

#IFDEF _RDD
   #define  CONFIG_FILE  'RDOT.CFG'
#ELSE
   #define  CONFIG_FILE  'DOT.CFG'
#ENDIF


Func Main(opt1,opt2)

PUBL ETBOX :=                                        ;
        { 'zw{xx|w}','',     ;
          'xx|w}','zw{xx',     ;
          'xx','ww',     ;
          '~wxxw','',     ;
          'zw{xx|w}w','', ;
          'uwt','','w',''        }

publ tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9
publ var0,var1,var2,var3,var4,var5,var6,var7,var8,var9
publ col0,col1,col2,col3,col4,col5,col6,col7,col8,col9
publ sys0,sys1,sys2,sys3,sys4,sys5,sys6,sys7,sys8,sys9
publ syspath:=if( empty(opt1), '\'+curdir(), opt1 )
 syspath += if( right(syspath,1)$':\', '', '\' )
 if ! file( syspath + CONFIG_FILE )
    ?  "   ======== Config File Found !! ======= " + chr(7)
    ?
    retu
 endi
 col0 := if( iscolor(), 'w/b;w+/br;gr+/b,w+/g',  'w/n;n/w;w+/n,n/w' )
 col1 := if( iscolor(), 'gr+/b;w+/br;w/b,w+/gr', 'n/w;w+/n;n/w,w/n' )
 col2 := if( iscolor(), 'w+/b;gr+/g;w/b,w/br',   'n/w;w+/n;n/w,w/n' )
 col3 := if( iscolor(), 'w+/br;w+/r;bg+/br,w+/bg','n/w;w+/n;n/w,w/n' )

 tmp0 := dotmessage()                 // message of dot command
 swpcurdir(.f.)
 macrof(syspath+CONFIG_FILE,,{opt2})    //  run config macro program.
 scr_load(tmp0)
 dotcom( {|s|swpruncmd(subs(s,2))} )          //  dot command

retu nil


#ifdef _SHARE      // --------- Shareware Version --------------

 func dotmessage()
 loca mc, ms
   mc := if( iscolor(), 'bg, gr+, w+', nil )

   #IFDEF _RDD
     ms := boxwind( ,,,, mc, 'Dot Command 2.31a (RDD) (Shareware Version)' )
   #ELSE
     ms := boxwind( ,,,, mc, 'Dot Command 2.31a (Shareware Version)' )
   #ENDIF

   m_say(  5, 6, "Dot Command is a utility of Casual-Kit 2.00. It provides a dbase-like  ")
   m_say(  6, 6, "platform to run clipper expressions and macro programs.                ")
   m_say(  7, 6, "It can run all expressions consist of both clipper and Casual-Kit      ")
   m_say(  8, 6, "functions, it can also run dos command, manage file and databse...     ")
   m_say(  9, 6, "                                                                       ")
   m_say( 10, 6, "  F1 --- Help    CK20.NG --- Norton Guide of Casual Kit 2.00           ")
   m_say( 11, 6, "                                                                       ")
   m_say( 12, 6, "If you find it is good, HKD 200.00 will be great encouragement to me.  ")
   m_say( 13, 6, "Please send your register form to G.P.O.Box 8022, HongKong.            ")
   m_say( 14, 6, "Registered users have the following benifits :                         ")
   m_say( 15, 6, "                                                                       ")
   m_say( 16, 6, "     Latest version of < Dot Command >                                ")
   m_say( 17, 6, "     A library include 40 functions of Casual-Kit 2.00                ")
   m_say( 18, 6, "     printed document                                                 ")
   m_say( 19, 6, "     Your questions will be answered                                  ")
   m_say( 20, 6, "     Lower price or free to upgrade                                   ")
   m_say( 22, 3, padc("Copyright 1993,1994.  C. K. Hung.   HongKong. All Right Reserved",74),'w+/br')
   inkey(0)
   scr_close(ms[9])
 retu ms
#else      // ------------- Register version ------------------

 func dotmessage()
 loca ms
   #IFDEF _RDD
      ms := e_wind(5,20,15,60,'N+$','ͻ ͼĶ',col0,'Dot Command 2.31a (RDD)' )
   #ELSE
      ms := e_wind(5,20,15,60,'N+$','ͻ ͼĶ',col0,'Dot Command 2.31a')
   #ENDIF
   m_say( 09, 25, 'Copyright 1993-1994, C.K.Hung' )
   m_say( 10, 25, '    All Rights Reserved' )
   m_say( 12, 25, ' F1 --- Help   F10 --- Quit' )
 retu ms

#endif


// ---------------------------------------------------------------------
// This function is not included in Casual-Kit, but it is very useful
// for database convertion. It is added into DOT COMMAND since ver 2.31,
// so that we can use macro program to convert database.
//

func trandbf( aStru, bRecord, bFor, cCol, nx, ntime )
loca mscr, mi, mj, mk

  if !used() then retu .f.

  type default bFor to {||.t.}, nX to 7, ntime to 3
  type default cCol to 'bg+/b; gr+/b; w+/b'

  mScr := e_wind( nX, 19, nX+11, 62, 'n$', ;
                  ' ', cCol, 'Converting ('+alias()+') -> Buffer.DBF' )
  m_say(nX+4,25,'Total Source Records = ' )
  m_say(nX+5,25,'Converting Records   = ' )
  m_say(nX+6,25,'Total Target Records = ' )
  m_say(nX+8,20,repl('',40) )

  dbcreate( 'buffer.dbf', aStru )
  pusharea()
  use buffer new
  poparea()
  dbeval( {||tranrecord(bRecord,nx,nTime)}, bFor )
  buffer->(dbclosearea())
  scr_load(mScr)

retu .t.


stat func tranrecord( bRecord, nX, nTime )
loca mCur := recno(), mNew, mi
  if mCur%nTime = 0
     mTot := lastrec()
     setpos(nX+4,48); dispout( str(mTot,6) )
     setpos(nX+5,48); dispout( str(mCur,6) )
     setpos(nX+6,48); dispout( str(buffer->(lastrec()),6) )
     setpos(nX+9,21)
     dispout( padr( repl('',mi:=30*mCur/mTot), 30, '.') + ;
                          + ' ' + str(mi*10/3,3)+'% OK' )
  endi
  buffer -> ( dbappend() )
  mNew := eval( bRecord )
  buffer -> ( Rec_Put(mNew) )
retu nil


//=====================THE END===========================DOT.PRG=====



