' SIM2RBBS.BAS - Convert SimTel "SIMIBM.IDX" to RBBS-PC FMS directory format.
'                A free utility by Chip Morrow, Fidonet 1:226/730,
'                chip@infinet.com
'
' Last updated 20 Sep 94
'
' $Include: 'PDQ312.INC'       ' <- This is PDQDECL.BAS from Crescent Software.
'
' Microsoft QuickBASIC v4.5, and Crescent's PDQ library v3.00 or later is
' required to recompile this code without modification.
'
' Command lines used to create the executable:
'
' bc sim2rbbs /o;
' link sim2rbbs+
' _str$+_noval+_noread+_noerror+_nofield+_nonet/nod/noe,,nul,pdq312

COMMON SHARED InsFlag%
DECLARE FUNCTION PDQColor%(Fore%, Back%)
DECLARE SUB EditStr (Row%, Col%, Fore%, Back%, A$, MaxLen%, K$)
DECLARE SUB ErrExit ()
DECLARE SUB KillQuotes (A$)

TYPE SimTel
  SubDir AS STRING * 8
  FileName AS STRING * 12
  FileSize AS LONG
  FileDate AS STRING * 6
  Descr AS STRING  * 46
END TYPE

DEFINT A-Z

  DIM SimTel AS SimTel
  REDIM SimDir$(1 TO 1000)                         ' Max of 1,000 directories.
  InsFlag = 1

  ' ************************
  ' Set some initial values.
  ' ************************

  Index$   = "SIMIBM.IDX"                 ' the master file listing
  DirList$ = "DIRLIST.TXT"                ' directories and descriptions

  CD$ = "D"                               ' CDROM drive letter
  DirCat$ = "C:\RBBS\DIR\SIMTEL.CAT"      ' RBBS-PC directory category file
  FMSDir$ = "C:\RBBS\DIR\SIMTEL.DIR"      ' RBBS-PC FMS directory
  DirDir$ = "C:\RBBS\DIR\SIMDIR.DIR"      ' RBBS-PC directory of directories

  BaseIndex$ = Index$
  BaseDirList$ = DirList$

  ' **********************************
  ' Create a simple data entry screen.
  ' **********************************

  CLS
  PRINT "Sim2RBBS v1.0 (9/20/94) by Chip Morrow"
  PRINT "Create RBBS-PC-compatible file listings for use with the SimTel CDROMs."
  PRINT
  PRINT "We need to know the path/filenames of SIMIBM.IDX and DIRLIST.TXT."
  PRINT
  PRINT "Your CDROM is located on drive letter: "
  PRINT
  PRINT "SIMIBM.IDX  is named: "
  PRINT "DIRLIST.TXT is named: "
  PRINT
  PRINT "Now for the filenames that this program will create.  Be sure to"
  PRINT "include the complete path and filename."
  PRINT
  PRINT "RBBS-PC DIR.CAT should be created as: "
  PRINT "RBBS-PC FMS.DIR should be created as: "
  PRINT "RBBS-PC DIR.DIR should be created as: "

  Location = 1

  ' **************
  ' Get user input
  ' **************

SetParms:                                   ' Branch here to get user input.

  PDQPrint SPACE$(1), 6, 40, 7
  PDQPrint SPACE$(40), 8, 23, 7             ' Clear the data entry fields
  PDQPrint SPACE$(40), 9, 23, 7
  PDQPrint SPACE$(40), 14, 39, 7
  PDQPrint SPACE$(40), 15, 39, 7
  PDQPrint SPACE$(40), 16, 39, 7

  PDQPrint CD$, 6, 40, 15
  PDQPrint Index$, 8, 23, 15                ' Display current values.
  PDQPrint DirList$, 9, 23, 15
  PDQPrint DirCat$, 14, 39, 15
  PDQPrint FMSDir$, 15, 39, 15
  PDQPrint DirDir$, 16, 39, 15

  SELECT CASE Location
     CASE 1:
        EditStr 6, 40, 0, 7, CD$, 1, K$            ' Get CDROM drive letter
        CD$ = UCASE$(CD$) : IF CD$ = "" THEN CD$ = "D"
        DirList$ = CD$ + ":\" + BaseDirList$
        Index$ = CD$ + ":\" + BaseIndex$
     CASE 2:
        EditStr 8, 23, 0, 7, Index$, 40, K$        ' Get SIMIBM.IDX filename
        Index$ = UCASE$(Index$)
     CASE 3:
        EditStr 9, 23, 0, 7, DirList$, 40, K$      ' Get DIRLIST.TXT filename
        DirList$ = UCASE$(DirList$)
     CASE 4:
        EditStr 14, 39, 0, 7, DirCat$, 40, K$      ' Get DIR.CAT filename
        DirCat$ = UCASE$(DirCat$)
     CASE 5:
        EditStr 15, 39, 0, 7, FMSDir$, 40, K$      ' Get FMS.DIR filename
        FMSDir$ = UCASE$(FMSDir$)
     CASE ELSE:
        EditStr 16, 39, 0, 7, DirDir$, 40, K$      ' Get DIR.DIR filename
        DirDir$ = UCASE$(DirDir$)
  END SELECT

  ' *****************************************************
  ' Act on keystrokes used to exit the data entry fields.
  ' *****************************************************

  SELECT CASE K$
     CASE CHR$(27): CLS : Print "Sim2RBBS aborted." : END      ' Esc
     CASE CHR$(0) + CHR$(72):                                  ' Up cursor
        Location = Location - 1
        IF Location < 1 THEN Location = 6
        GOTO SetParms
     CASE ELSE:                                                ' Anything else
        Location = Location + 1
        IF (Location < 7) THEN GOTO SetParms
  END SELECT

  ' ********************************
  ' Initial variable entry complete.
  ' ********************************

  PDQPrint SPACE$(40), 16, 39, 7                      ' Clear last entry line
  PDQPrint DirDir$, 16, 39, 15                        ' and display it's value.

  LOCATE 18, 1

  ' ************************************
  ' Error checks and overwrite warnings.
  ' ************************************

  IF NOT PDQExist(Index$) THEN                                    ' SIMIBM.IDX
     PRINT "SimTel index file '"; Index$; "' not found."
     ErrExit
  END IF

  IF NOT PDQExist(DirList$) THEN                                  ' DIRLIST.TXT
     PRINT "SimTel directory listing '"; DirList$; "' not found."
     ErrExit
  END IF

  IF PDQExist(DirCat$) THEN                                       ' DIR.CAT
     PRINT
     PRINT "The specified directory cateogory file '"; DirCat$; "'"
     PRINT "already exists.  OK to overwrite this file (Y/N)? ";
     DO
       X$ = UCASE$(INKEY$)
       IF X$ = "Y" THEN PRINT "Yes" : EXIT DO
       IF X$ = "N" THEN PRINT "No" : ErrExit
     LOOP
  END IF

  IF PDQExist(FMSDir$) THEN                                       ' FMS dir
     PRINT
     PRINT "The specified FMS directory file '"; FMSDir$; "'"
     PRINT "already exists.  OK to overwrite this file (Y/N)? ";
     DO
       X$ = UCASE$(INKEY$)
       IF X$ = "Y" THEN PRINT "Yes" : EXIT DO
       IF X$ = "N" THEN PRINT "No" : ErrExit
     LOOP      
  END IF

  IF PDQExist(DirDir$) THEN                                       ' DIR.DIR
     PRINT
     PRINT "The specified directory of directories '"; DirDir$; "'"
     PRINT "already exists.  OK to overwrite this file (Y/N)? ";
     DO
       X$ = UCASE$(INKEY$)
       IF X$ = "Y" THEN PRINT "Yes" : EXIT DO
       IF X$ = "N" THEN PRINT "No" : ErrExit
     LOOP      
  END IF

  ' *******************************************
  ' Create the RBBS-PC directory category file.
  ' *******************************************

  FirstDir$ = "4DOS"                     ' <<<<<--- If "4DOS" is not the first
                                         '   directory listed in DIRLIST.TXT,
                                         '   this line needs to be changed
                                         '   accordingly!!!!!!  This directory
                                         '   name must be listed here in upper
                                         '   case.

  PRINT
  PRINT "Creating "; DirCat$; " and "; DirDir$; "... ";
  OPEN DirList$ FOR INPUT AS #1
  OPEN DirCat$ FOR OUTPUT AS #2
  IF ERR THEN
     PRINT
     PRINT "Unable to create directory category file '"; DirCat$; "'.
     ErrExit
  END IF

  OPEN DirDir$ FOR OUTPUT AS #3

  IF ERR THEN
     PRINT
     PRINT "Unable to create directory of directories '"; DirDir$; "'.
     ErrExit
  END IF

  Foundfirst = 0
  NumDirs = 0

  DO

     LINE INPUT #1, A$
     IF ERR THEN EXIT DO
     IF LEFT$(UCASE$(A$), LEN(FirstDir$)) = FirstDir$ THEN
        Foundfirst = -1
     END IF

     IF Foundfirst THEN                            ' If found first category,
        IF LTRIM$(RTRIM$(A$)) = "" THEN EXIT DO    ' but nobody home, all done.
        SpaceLoc = INSTR(A$, " ")
        IF (SpaceLoc > 0) THEN 
           DN$ = LEFT$(A$, SpaceLoc-1)
           IF PDQExist(CD$ + ":\" + DN$ + "\*.*") THEN
              NumDirs = NumDirs + 1
              B$ = STR$(NumDirs)
              C$ = RIGHT$("00" + STR$(NumDirs), 3)
              D$ = LTRIM$(MID$(A$, SpaceLoc))
              WriteDisk$ = CHR$(34) + B$ + CHR$(34) + "," + _
                           CHR$(34) + C$ + CHR$(34) + "," + _
                           CHR$(34) + D$ + CHR$(34)

              PRINT #2, WriteDisk$
              IF ERR THEN
                 PRINT
                 PRINT "Error while writing to directory category file '"; DirCat$; "'."
                 ErrExit
              END IF

              PRINT #3, RIGHT$(SPACE$(4) + B$, 4) + " - " + D$
              IF ERR THEN
                 PRINT
                 PRINT "Error while writing to directory of directories '"; DirDir$; "'."
                 ErrExit
              END IF

              SimDir$(NumDirs) = UCASE$(LEFT$(A$, SpaceLoc-1))

           END IF
        END IF
     END IF

  LOOP

  CLOSE  

  Print STR$(NumDirs); " categories found."

  ' ************************************************************************
  ' RBBS-PC DIR.CAT file created. The variable NumDirs% contains the highest
  ' numbered element in the SimDir$() array.
  ' ************************************************************************

  IF NumDirs = 0 THEN PRINT "No categories found!  Exiting..." : END

  ' ****************************
  ' Write RBBS-PC FMS directory.
  ' ****************************

  PRINT
  PRINT "Creating FMS directory '"; FMSDir$; "'."
  PRINT
  PRINT "Press [Esc] to abort."
  PRINT
  PRINT "  Checking file #"
  PRINT "     Found file #";

  Row = CSRLIN
  Col = POS(0)
  FilesFound& = 0&
  FilesGood& = 0&

  OPEN Index$ FOR INPUT AS #1
  OPEN FMSDir$ FOR OUTPUT AS #2

  IF ERR THEN
     PRINT
     PRINT "Unable to create FMS directory '"; FMSDir$; "'."
     ErrExit
  END IF

  DO
 
     LINE INPUT #1, A$
     IF ERR THEN EXIT DO

     X$ = INKEY$
     IF X$ = CHR$(27) THEN EXIT DO

     PDQRestore
     SetDelimitChar 44

     Dummy$ = PDQParse$(A$)
     TempSub$ = PDQParse$(A$) : KillQuotes TempSub$

     Start = 0
     FOR Z = LEN(TempSub$)-1 TO 1 STEP - 1
        IF MID$(TempSub$, Z, 1) = "/" THEN
           Start = Z+1
           Stopp = LEN(TempSub$)-1
           EXIT FOR
        END IF
     NEXT

     IF (Start > 0) THEN
        Temp$ = MID$(TempSub$, Start, Stopp-(Start-1))
        KillQuotes Temp$
        LSET SimTel.SubDir = Temp$
     ELSE
        END
     END IF

     Temp$ = PDQParse$(A$) : KillQuotes Temp$ 
     SimTel.FileName = Temp$
     Dummy$ = PDQParse$(A$)
     Temp$ = PDQParse$(A$) : KillQuotes Temp$ 
     SimTel.FileSize = PDQValL&(Temp$)
     Dummy$ = PDQParse$(A$)
     Temp$ = PDQParse$(A$) : KillQuotes Temp$
     SimTel.FileDate = Temp$
     Temp$ = PDQParse$(A$) : KillQuotes Temp$
     SimTel.Descr = Temp$

     WriteDisk$ = UCASE$(SimTel.FileName) + _
                  RIGHT$(SPACE$(9) + STR$(SimTel.FileSize), 9) + _
                  "  " + MID$(SimTel.FileDate, 3, 2) + "-" + _
                         MID$(SimTel.FileDate, 5, 2) + "-" + _
                         MID$(SimTel.FileDate, 1, 2) + "  " + SimTel.Descr

     Foundit = 0

     FOR Z = 1 TO NumDirs
        IF RTRIM$(UCASE$(SimTel.SubDir)) = SimDir$(Z) THEN
           Foundit = -1
           WriteDisk$ = WriteDisk$ + RIGHT$("00" + STR$(Z), 3)
           PRINT #2, WriteDisk$
           IF ERR THEN
              PRINT "Error while writing to FMS directory '"; FMSDir$; "'."
              ErrExit
           END IF
           EXIT FOR
        END IF
     NEXT

     FilesFound& = FilesFound& + 1&
     IF Foundit THEN FilesGood& = FilesGood& + 1

     LOCATE Row-1, Col
     PRINT STR$(FilesFound&);
     LOCATE Row, Col
     PRINT STR$(FilesGood&);

  LOOP

PRINT : PRINT
PRINT "Sim2RBBS complete.  "
PRINT
PRINT STR$(FilesFound&); " files listed."
PRINT STR$(FilesGood&); " files on this CD, in "; STR$(NumDirs); " categories."
CLOSE
END

' *******************************************
' END of program.  Subs and functions follow.
' *******************************************

SUB KillQuotes (A$)

   IF LEFT$(A$, 1) = CHR$(34) THEN B$ = MID$(A$, 2) ELSE B$ = A$
   IF RIGHT$(A$, 1) = CHR$(34) THEN B$ = LEFT$(B$, LEN(B$)-1)

   A$ = B$

END SUB

SUB EditStr (Row, Col, Fore, Back, A$, MaxLen, K$)

' Original routine by Doug Wilson
' Modified and adapted for PDQ by Chip Morrow

IF NOT maxlen > 0 THEN EXIT SUB 
y0 = Row: x0 = Col                                                        ' PDQ
PassColor = PDQColor (Fore, Back)                                         ' PDQ

'Check to make sure there is room for a maxlen string starting at current
'cursor position.  If not, shorten allowable string length.

IF x0 + maxlen > 81 THEN maxlen = 81 - x0
 
b$ = LEFT$(a$, maxlen)           'create working copy of string
cp = LEN(b$) + 1                 'cursor position within string, start at end
IF cp > maxlen THEN cp = maxlen  'keep cursor within edit space
if cp => maxlen then cp = 1
k$ = ""                          'variable to store pressed key

'insflag = 1                      'insert mode default value: 1=on 0=off
' "InsFlag%" is now a shared variable - initially "on".  When user presses
' the [Ins] key, that setting is now continued between fields. - 352h, CM

Call PDQPrint (String$(MaxLen, 32), y0, x0, PassColor)                    ' PDQ
Call PDQPrint (B$, y0, x0, PassColor)                                     ' PDQ

DO                                    '< Keep going until exit key is pressed

   LOCATE y0, x0 + cp - 1
   Call CursorOn                                                          ' PDQ

   DO
     K$ = INKEY$
     IF K$ <> "" THEN EXIT DO
   LOOP

   IF LEN(k$) = 2 THEN         '< If k$ returned by INKEY$ is 2 characters
                               '< long, it means a special key, like a
                               '< cursor control key or Function key was
                               '< pressed.
                               '
      k = ASC(MID$(k$, 2))    '< The 2nd char. tells which key pressed.
                               '    (1st char. is Zero$.)
      SELECT CASE k           '< Choose response according to key pressed.

         CASE 71: cp = 1                                     '< home
         CASE 75:                                            '< left arrow
            IF cp > 1 THEN cp = cp - 1 ELSE CALL PDQSOUND (1000, 2)       ' PDQ
         CASE 77:                                            '< right arrow
            IF cp < maxlen THEN
               cp = cp + 1
            ELSE Call PDQSOUND (1000, 2)                                  ' PDQ
            END IF
         CASE 79:                                            '< end
            cp = LEN(RTRIM$(b$)) + 1

         CASE 80, 81: EXIT DO                                '< dn arrow, PgDn

         CASE 82:                                            '< insert
            IF insflag = 0 THEN insflag = 1 ELSE insflag = 0

         CASE 83:                                            '< delete
            If Len(B$) = 1 and cp = 1 Then                   ' Bug fix......
               B$ = ""                                       ' .............
            End If                                           ' .............
            If Len(B$) > 1 and cp = 1 Then                   ' .............
               B$ = Mid$(B$, cp+1, Len(B$) - 1)              ' .............
            End If                                           ' .............
            If Len(B$) > 1 and cp <> Len(B$) and cp <> 1 Then ' ............
               B$ = Left$(B$, cp - 1) + _                    ' ...4/09/90...
                    Mid$(B$, cp+1, Len(B$) - 1)              ' .............
               Else                                          ' .............
               If Len(B$) > 1 and cp = Len(B$) Then          ' .............
                  B$ = Left$(B$, Len(B$) - 1)                ' .............
                  cp = Len(B$) + 1                           ' .............
               End If                                        ' .............
            End If                                           ' ...........CM
               
         CASE 117:                                           '< Ctrl-End
            b$ = LEFT$(b$, cp - 1)
         CASE ELSE: EXIT DO

      END SELECT

   ELSE   '< If length of k$ not 2, then a "regular" typewriter key pressed

      SELECT CASE ASC(k$)
         CASE 8:                               '< backspace
            IF cp > 1 THEN
               b$ = LEFT$(b$, cp - 2) + MID$(b$, cp)
               cp = cp - 1
            ELSE Call PDQSOUND (1000, 2)                                  ' PDQ
            END IF
         CASE 9, 13: EXIT DO                         '< tab, enter        ' PDQ

         Case 27:                                    '< Esc               ' PDQ
            IF B$ = A$ Then                                               ' PDQ
                 K$ = CHR$(27)                                            ' PDQ
                 Exit DO                                                  ' PDQ
            End If                                                        ' PDQ
            IF B$ = "" Then                                               ' PDQ
                 B$ = A$                                                  ' PDQ
                 cp = Len(B$) + 1                                         ' PDQ
            End If                                                        ' PDQ
            IF B$ <> A$ THEN                                              ' PDQ
                 B$ = ""                                                  ' PDQ
                 cp = Len(B$) + 1                                         ' PDQ
            END IF                                                        ' PDQ

         CASE ELSE:                                  '< regular char key

            WHILE cp > LEN(b$)    '< If beyond end off string
               b$ = b$ + " "      '< pad with spaces.
            WEND                  '

            IF insflag = 0 THEN   '< If not in insert mode...
               MID$(b$, cp, 1) = k$  '< Replace present character.
               cp = cp + 1           '< Update cursor positon.

            ELSE                  '< If in insert mode...

               b$ = LEFT$(b$, cp - 1) + k$ + MID$(b$, cp)'< Insert character
               cp = cp + 1                               '< Update cursor pos.

            END IF                '< End of insert/not insert test

      END SELECT                '< End of single char k$ processing

   END IF                      '< End of len(k$)=2/else test

   IF cp > maxlen THEN cp = maxlen         '< Don't let cursor go beyond end
   IF Len(B$) > MaxLen Then
      B$ = Left$(B$, MaxLen)
   End If

   This.Place = x0 + Len(Left$(B$, MaxLen))                               ' PDQ
   Call PDQPrint (Left$(B$, MaxLen), y0, x0, PassColor)  '< Edited string ' PDQ
   Test = (MaxLen - Len(B$))                                              ' PDQ
   If Test > 0 Then
     Call PDQPrint (String$(Test, " "), y0, This.Place, PassColor)        ' PDQ
   End If

LOOP                           '< Loop to here 'til an exit key pressed

   IF NOT k$ = CHR$(27) THEN a$ = RTRIM$(LEFT$(b$, maxlen))

END SUB

FUNCTION PDQColor(Fore, Back)

   PDQColor = (Fore and 16) * 8 + ((Back and 7) * 16) + (Fore and 15)

END FUNCTION

SUB ErrExit

   PRINT
   PRINT "Program aborted."
   CLOSE
   END

END SUB
