include src\qlib.inc
include string.inc

.data?  ;starts DWORD aligned
  h db ?  ;('a' or 'A') - 10
  tss db ?
  ts db 34 dup (?)

.code
_num2str_:
  ;eax = # to decode
  ;ebx = radix
  mov edi,offset ts+33
  mov byte ptr[edi],0
  dec edi
  mov ecx,32  ;the MAX
num2str_2:
  xor edx,edx
  div ebx
  .if dl<10
    add dl,'0'
  .else
    add dl,h
  .endif
  mov [edi],dl
  dec edi
  dec ecx
  jnz num2str_2
  .while edi!=offset ts
    mov bptr[edi],'0'
    dec edi
  .endw
  mov bptr[edi],'0'
  ret

copyit:
; esi => edi
;copies a string (and removes unneeded 0s)
  mov ebx,edi
  mov al,bptr[esi]
  .if (al=='-')
    movsb
    mov al,bptr[esi]
  .endif
  .if (al=='0')
    .while al=='0'
      lodsb
    .endw
    stosb
  .endif
  .if !al  ;the # is zero
    mov edi,ebx
    mov bptr[edi],'0'
    mov bptr[edi+1],0
    ret
  .endif
  .while al
    lodsb   ;can't use movsb : must get al loaded
    stosb
  .endw
  ret

num2str proc,a:dword,off:dword,rax:byte
  mov h,'a'-10
jumpin1::
  pushad
  xor ebx,ebx
  mov bl,rax
  .if (bl>36) || (bl<2)  ;tolerance
    mov ebx,off
    mov bptr[ebx],0
    popad
    mov eax,off
    ret
  .endif
  mov eax,a
  call _num2str_
  mov edi,off
  mov esi,offset ts
  call copyit

  popad
  mov eax,off
  ret
num2str endp

num2strc proc,a:dword,off:dword,rax:byte
  ;same as num2str except starts with capital letters when # > 9
  mov h,'A'-10
  jmp jumpin1
num2strc endp

;signed output (does not put in '+' symbol when pos)
num2strs proc,a:dword,off:dword,rax:byte
  mov h,'a'-10
jumpin2::
  pushad
  xor ebx,ebx
  mov bl,rax
  .if (bl>36) || (bl<2)  ;tolerance
    mov ebx,off
    mov bptr[ebx],0
    popad
    mov eax,off
    ret
  .endif
  mov eax,a
  .if eax & 80000000h
    neg eax
    mov tss,'-'
  .else
    mov tss,0
  .endif
@@:
  call _num2str_
  mov edi,off
  mov esi,offset ts
  .if tss
    dec esi
  .endif    
  call copyit
  popad
  mov eax,off
  ret
num2strs endp

;signed version too + caps
num2strsc proc,a:dword,off:dword,rax:byte
  ;same as num2str except starts with capital letters when # > 9
  mov h,'A'-10
  jmp jumpin2
num2strsc endp

num2str0 proc,a:dword,off:dword,rax:byte,zeros:dword
  mov h,'a'-10
  pushad
  mov edi,off
  mov ecx,zeros
  mov eax,'0000'
  storeECX   ;destorys BL
  mov off,edi
  popad
  mov eax,zeros  ;FIX : v2.11 Beta #1 : this was needed
  add off,eax    
  jmp jumpin1
num2str0 endp

num2strc0 proc,a:dword,off:dword,rax:byte,zeros:dword
  mov h,'A'-10
  pushad
  mov edi,off
  mov ecx,zeros
  mov eax,'0000'
  storeECX   ;destorys BL
  mov off,edi
  popad
  mov eax,zeros  ;FIX : v2.11 Beta #1 : this was needed
  add off,eax
  jmp jumpin1
num2strc0 endp

num2strs0 proc,a:dword,off:dword,rax:byte,zeros:dword
  mov h,'a'-10
  pushad
  mov edi,off
  mov ecx,zeros
  mov eax,'0000'
  storeECX   ;destorys BL
  mov off,edi
  popad
  mov eax,zeros  ;FIX : v2.11 Beta #1 : this was needed
  add off,eax
  jmp jumpin2
num2strs0 endp

num2strsc0 proc,a:dword,off:dword,rax:byte,zeros:dword
  mov h,'A'-10
  pushad
  mov edi,off
  mov ecx,zeros
  mov eax,'0000'
  storeECX   ;destorys BL
  mov off,edi
  popad
  mov eax,zeros  ;FIX : v2.11 Beta #1 : this was needed
  add off,eax
  jmp jumpin2
num2strsc0 endp

_endseg

end

