#include <src/video.h>

byte str1[0x80];
volatile struct mouse_user us;  //mouser User Struct
void *cursor_a;
void *cursor_b;
dword tx,ty;

//this proc is called every time the mouse moves or a button is pressed/released
//NOTE:this is called in an IRQ!!  (so don't do any file IO, ok? - just
//don't do anything that calls DOS)
void user(void) {
  word buttons;

//  buttons = us.but;  //I do not used here

  if ((us.x>100) && (us.x<200) && (us.y>110) && (us.y<199))
    mouse_setcursor((void *)cursor_b);
  else
    mouse_setcursor((void *)cursor_a);
}

void exit_error(char *aa) {
  printf(aa);
  exit(0);
}

#define exit_on_null(x,aa) if (x==NULL) exit_error(aa);
#define exit_on_error(x,aa) if (x==ERROR) exit_error(aa);

#define X1 210
#define Y1 110
#define X2 310
#define Y2 170

void rotate(dword *x,dword *y) {
  if ((*x) == X1) {
    if ((*y) == Y1)
      (*x)++;
    else
      --(*y);
  } else if ((*y) == Y1) {
    if ((*x) == X2)
      ++(*y);
    else
      ++(*x);
  } else if ((*x) == X2) {
    if ((*y) == Y2)
      --(*x);
    else
      ++(*y);
  } else (*x)--;
}

dword l_p1x=X1;
dword l_p1y=Y1;
dword l_p2x=X2;
dword l_p2y=Y2;
dword l_clr=0;

char ts_msg[]="A text scrolly thingy using g_printf()  Cool eh?";
dword ts_x=0;
dword ts_x_stop=0;

void coords(dword _x,dword _y) {
  tx=_x*fontx;
  ty=_y*fonty;
}

void update_cool_stuff(void) {
  //Print text scrolly

  g_boxfill(0,0,x-1,fonty-1,0);
  --ts_x;
  if (ts_x==ts_x_stop) ts_x=x;
  
  g_printf(ts_x,0,ts_msg);
  g_copyblk(0,0,_v_x-1,fonty-1);

  //Print spinning line 
  g_line(l_p1x,l_p1y,l_p2x,l_p2y,l_clr);
  g_copyblk(X1,Y1,X2,Y2);
  l_clr+=0x010101;
  if (l_clr > 0xffffff) l_clr=0;

  //Rotate coords
  rotate(&l_p1x,&l_p1y);
  rotate(&l_p2x,&l_p2y);
}

void gwait4key(void) {
  g_copy();
  do {
    update_cool_stuff();
  } while (!kbhit());
  getch();
}

void grafix_test(void) {
  dword ebx,ecx;
  char ch;
  clrscr();
top:
  printf("Grafix Mode Tests\n\n");
  printf("Enter X Res (ie: 320,640,800,etc.) :>");

  gets(tmpstr);
  x=atol(tmpstr);

  printf("Enter Y Res (ie: 200,480,600,etc.) :>");
  gets(tmpstr);
  y=atol(tmpstr);

  printf("Enter BPP (ie: 8,16,24,etc.) :>");

  gets(tmpstr);
  bpp=atol(tmpstr);

  if (! (bpp==32 || bpp==24 || bpp==16 || bpp==15 || bpp==8)) goto not_avail;
  if ((x<320) || (y<200) || (bpp<8)) goto not_avail;

  mouse_setuser((void *)& user,(void *)& us);  //setup mouse callback thingy

  cursor_a=mouse_loadcursor("mouse.ptr");
  exit_on_error((sdword)cursor_a,"Unable to load PTR file!");
  cursor_b=mouse_loadcursor("hourgls.ptr");
  exit_on_error((sdword)cursor_b,"Unable to load PTR file!");
  if (bpp!=8) goto use1only;

  printf("Select font type:\n");
  printf(" 1) 8x8 mono font     [font.fnt]\n");
  printf(" 2) 16x16 color font  [big16.fnt]\n");
t1:
  ch=getch();
  if (ch=='1') {
use1only:
    fontbuf=g_loadfnt("font.fnt");
    goto t2;
  }
  if (ch=='2') {
    fontbuf=g_loadfnt("big16.fnt");
    goto t2;
  }
  goto t1;
t2:
  exit_on_error((sdword)fontbuf,"Unable to load FONT file!");

  fontx=fontbuf->x;
  fonty=fontbuf->y;

  mouse_setcursor((void *)cursor_a);

  _v_debug=1;     //Enable video debug info messages

  mode=g_getmode(x,y,bpp);
  if ((sbyte)mode==ERROR) {
not_avail:
    printf("\nVideo mode not supported!\n Press a key...");
    wait4key();
    return;
  }

  printf("Press a key...");
  getch();

  g_setmode();

  tvid=g_alloc();
  exit_on_null(tvid,"Out of memory");
  g_setbuf((void *)tvid);

  if ((bpp==24) || (bpp==32)) {
    g_setfntcolor(0xffffff);  //24/32bit color
    mouse_setcolor(0xffffff);  //24bit color
  } else if ((bpp==15) || (bpp==16)) {
    g_setfntcolor(0xcccc);    //2byte color
    mouse_setcolor(0xeeee);    //2byte color
  } else {
    g_setfntcolor(4);
    mouse_setcolor(1);
  }

  coords(0,1);
  g_printf(tx,ty,"Video Type =");

  switch (mode) {
    case G_VGA:
      strcpy(str1,"VGA "); break;
    case G_VESA:
      strcpy(str1,"VESA "); break;
    case G_MODEX:
      strcpy(str1,"ModeX "); break;
    default:
      strcpy(str1,"??? "); break;
  }

  if ((_v_acctype == G__LINEAR) || (_v_acctype == G__LINEARX))
    strcat(str1,"[Linear Mode]");
  if ((_v_acctype == G__VESA) || (_v_acctype == G__VESAX))
    strcat(str1,"[Banking Mode]");
  
  coords(12,1);
  g_printf(tx,ty,str1);
  if (bpp==8)
    g_setfntcolor(7);
  else if (bpp==15)
    //Really weird colors needed to work properly
    g_setfntcolor(0xeeee);
  else
    g_setfntcolor(0xbbbbbb);

  coords(0,2);
  g_printf(tx,ty,"Video Mode %dx%d %dbit (%d,%#010x)",x,y,bpp,_v_xbpsl,_v_linear);

  coords(0,3);
  g_printxy(tx,ty,"Press keys to move on...");
  coords(0,4);
  g_printxy(tx,ty,"Mouse Window : (50,50)-(100,100)");
  if ((bpp==24) || (bpp==32))
    g_box(100,110,200,199,0xffffff);  //24bit color
  else
    g_box(100,110,200,199,15);
  
  g_printxy(102,112,"User Defined");

  g_printxy(102,112+fonty," area");
  g_copy();

  //setup text scrolly
  ts_x_stop=-strlen(ts_msg)*fontx;
  ts_x=x;

  mouse_setwin(50,50,100,100);//must reset size before mouse_on
  mouse_setpos(50,50);
  mouse_setspd(1,1);
  mouse_on();
  gwait4key();

  coords(0,5);
  g_printxy(tx,ty,"Full Window");
  g_copy();
  mouse_setwin(0,0,x-1,y-1);
  gwait4key();

  coords(0,6);
  g_printxy(tx,ty,"Half Speed");
  g_copy();
  mouse_setspd(2,2);
  gwait4key();

  coords(0,7);
  g_printxy(tx,ty,"Moved mouse to (100,100)");
  if (bpp>8) {
    coords(0,8);
    g_printxy(tx,ty,"Press a key to quit");
  }
  g_copy();
  mouse_setpos(100,100);
  gwait4key();

  if (bpp==8) {
    coords(0,8);
    g_printxy(tx,ty,"Hold in buttons to change color:");
    coords(0,9);
    g_printxy(tx,ty,"Press a key to quit");
    g_copy();
    ccol=63;
    do {
      update_cool_stuff();
      if (us.but==3) goto c1;  //if both buttons are pressed
      if (us.but & 1) ++ccol;
      else if (us.but & 2) --ccol;
      else goto c1;
      if (ccol==64) ccol=0;
      else if (ccol==255) ccol=63;

      g_waitvsync();  //Slows things down Big time!
      g_setcol(1,0,0,ccol);
c1:
    } while (!kbhit());
    getch();
  }
done:
  mouse_off();
  t_setmode(80,25);
  free((void *)tvid);
  free((void *)fontbuf);
  free((void *)cursor_a);
  free((void *)cursor_b);
  return;
}

