/* ------------------------------- KBD.H ---------------------------------- */
#define RIGHTSHIFT		0x0001
#define LEFTSHIFT		0x0002
#define CONTROL			0x0004
#define ALT				0x0008
#define SCROLLSTATE		0x0010
#define NUMLOCKSTATE	0x0020
#define CAPLOCKSTATE	0x0040
#define INSERTSTATE		0x0080
#define CTRLNUMLKSTATE 	0x0800
#define SCROLLLOCK		0x1000
#define NUMLOCK			0x2000
#define CAPSLOCK		0x4000
#define INSERT			0x8000

#define UP		0x4800
#define DN		0x5000
#define RIGHT	0x4d00
#define LEFT	0x4b00
#define PGUP	0x4900
#define PGDN	0x5100
#define HOME	0x4700
#define END		0x4f00
#define ESC		0x011b
#define RET		0x1c0d
#define BKSP	0x0e08
#define SPACE	0x3920

#define F1		0x3b00
#define F2		0x3c00
#define F3		0x3d00
#define F4		0x3e00
#define F5		0x3f00
#define F6		0x4000
#define F7		0x4100
#define F8		0x4200
#define F9		0x4300
#define F10		0x4400

/* ------------- Alt-Keys ---------------- */
#define ALT_A	0x1e00
#define ALT_B	0x3000
#define ALT_C	0x2e00
#define ALT_D	0x2000
#define ALT_E	0x1200
#define ALT_F	0x2100
#define ALT_G	0x2200
#define ALT_H	0x2300
#define ALT_I	0x1700
#define ALT_J	0x2400
#define ALT_K	0x2500
#define ALT_L	0x2600
#define ALT_M	0x3200
#define ALT_N	0x3100
#define ALT_O	0x1800
#define ALT_P	0x1900
#define ALT_Q	0x1000
#define ALT_R	0x1300
#define ALT_S	0x1f00
#define ALT_T	0x1400
#define ALT_U	0x1600
#define ALT_V	0x2f00
#define ALT_W	0x1100
#define ALT_X	0x2d00
#define ALT_Y	0x1500
#define ALT_Z	0x2c00

/* -------------- Ctrl-Keys ------------------ */
#define CTRL_A	0x1e01
#define CTRL_B	0x3002
#define CTRL_C	0x2e03
#define CTRL_D	0x2004
#define CTRL_E	0x1205
#define CTRL_F	0x2106
#define CTRL_G	0x2207
#define CTRL_H	0x2308
#define CTRL_I	0x1709
#define CTRL_J	0x240a
#define CTRL_K	0x250b
#define CTRL_L	0x260c
#define CTRL_M	0x320d
#define CTRL_N	0x310e
#define CTRL_O	0x180f
#define CTRL_P	0x1910
#define CTRL_Q	0x1011
#define CTRL_R	0x1312
#define CTRL_S	0x1f13
#define CTRL_T	0x1414
#define CTRL_U	0x1615
#define CTRL_V	0x2f16
#define CTRL_W	0x1117
#define CTRL_X	0x2d18
#define CTRL_Y	0x1519
#define CTRL_Z	0x2c1a

/* ----------- Alt-Function keys ------------- */
#define ALT_F1	0x6800
#define ALT_F2	0x6900
#define ALT_F3	0x6a00
#define ALT_F4	0x6b00
#define ALT_F5	0x6c00
#define ALT_F6	0x6d00
#define ALT_F7	0x6e00
#define ALT_F8	0x6f00
#define ALT_F9	0x7000
#define ALT_F10	0x7100

/* ----------- Ctrl-Function keys ------------- */
#define CTRL_F1 	0x5e00
#define CTRL_F2		0x5f00
#define CTRL_F3		0x6000
#define CTRL_F4		0x6100
#define CTRL_F5		0x6200
#define CTRL_F6		0x6300
#define CTRL_F7		0x6400
#define CTRL_F8		0x6500
#define CTRL_F9		0x6600
#define CTRL_F10	0x6700

/* -------------- Shifted misc. keys ---------- */
#define SHIFT_UP	0x4838
#define SHIFT_DN	0x5032
#define SHIFT_LEFT	0x4b34
#define SHIFT_RIGHT	0x4d36

void KbdFlush	 (void);
int KbdGetShift  (void);
void KbdSetShift (int ShiftStat);
int KbdGetC		 (void);
