/*
 *                              DEPENDNT.H
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 *
 *	This stuff is used so that the same source will compile
 *	and run under either Zortech C , Turbo C, or Microsoft C.
 *	We are attempting to localize differences in interrupt handling
 *  as well as memory and i/o port handling diffferences here.
 */

#if (!defined (DEPENDENTSTUFF))
#	define DEPENDENTSTUFF
#	if (defined (DLC))
#		define inbyte(address)          inp(address)
#		define outbyte(address, value)  outp(address, value)
#		define enable                   int_on
#		define disable                  int_off
#		define peekmem(seg,offset,var)  peek(seg,offset,&var,2)
#		define setraw(fp)    fp->_flag &= ~_IOTRAN
#		define setcooked(fp) fp->_flag |= _IOTRAN
#	else
#		include <dos.h>
#		if (!defined (__TURBOC__))
#			define getvect(i)   _dos_getvect(i)
#			define setvect(i,v) _dos_setvect(i,v)
#			define setraw(fp)
#			define setcooked(fp)
#			define peekmem(seg,offset,var) peekmem(seg,offset,&var)
#		else
#			define setraw(fp)    fp->flags |= _F_BIN
#			define setcooked(fp) fp->flag &= ~_F_BIN
#			define inbyte(address)          inportb(address)
#			define outbyte(address, value)  outportb(address, value)
#			define peekmem(seg,offset, var) var=peek(seg,offset)
#		endif
#	endif
#endif
