/**  lc_chars.c **********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     LC_CTYPE & LC_COLLATE
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <ctype.h>
#include <string.h>
#ifdef   _Windows
#include "win.h"
#endif
#include "_locale.h"

/* WARNING: code in this file is very tangled. That is right, because
   different tables obtained from DOS/Windows are provides incomplete
   information and contains the lots of bugs.
   We can't to change them or use particular patches because the tables
   are unpublic and the bugs are OS-version dependent.
   Ofcourse, This code is hard-to-read (or readless at all)
   but it avoiding most of these bugs very well.
   Don't change it if you aren't sure...
 ******************* Don't touch!   That's works *****************/

     /****** definition of the mobile flags for _ctype[] ******/
/* Note: on all x86 'signed char' is more effective than 'unsigned char' */

#if   defined(__DJGPP__)
typedef unsigned short ctype_t;
#define CtypeT    (__dj_ctype_flags+1)
#elif defined(__WATCOMC__)
typedef /*unsigned*/ char ctype_t;
#define CtypeT    ((ctype_t*)_IsTable+1)
#else
typedef /*unsigned*/ char ctype_t;
#define CtypeT    ((ctype_t*)_ctype+1)
#endif

#define CTYPE(xx) ((xx >= 0x80 ? cType2 : CtypeT)[xx])

#if   defined(_MSC_VER) || defined(__WATCOMC__)
#define _lc_LOW    _LOWER
#define _lc_UPP    _UPPER
#define _lc_PUN    _PUNCT
#define _lc_SPC    _SPACE
#ifdef __WATCOMC__
#define _lc_PRINT  _PRINT
#define _lc_CTL    _CNTRL
#else
#define _lc_CTL    _CONTROL
#endif
#elif defined(__BORLANDC__)
#define _lc_LOW    _IS_LOW
#define _lc_UPP    _IS_UPP
#define _lc_PUN    _IS_PUN
#define _lc_CTL    _IS_CTL
#define _lc_SPC    _IS_SP
#elif defined(__DJGPP__)
#define _lc_LOW    __dj_ISLOWER
#define _lc_UPP    __dj_ISUPPER
#define _lc_PUN    __dj_ISPUNCT
#define _lc_SPC    __dj_ISSPACE
#define _lc_PRINT  __dj_ISPRINT|__dj_ISGRAPH
#define _lc_ALNUM  __dj_ISALNUM|__dj_ISALPHA
#define _lc_CTL      __dj_ISCNTRL
#else /* Valid but slow & fat */
#define _lc_LOW    (islower('z'))  /*_lc_ctype[2] islower */
#define _lc_UPP    (isupper('Z'))  /*_lc_ctype[3] isupper */
#define _lc_PUN    (ispunct('!'))  /*_lc_ctype[4] ispunct */
#define _lc_CTL    (iscntrl( 0 ))  /*_lc_ctype[5] iscntrl */
#define _lc_SPC    (isspace(' '))
#define _lc_DIG    (isdigit('0'))  /* currently not used  */
#endif
#if       defined(_lc_PRINT) ||  defined(_lc_ALNUM)
#ifndef _lc_PRINT
#define _lc_PRINT 0
#endif
#ifndef _lc_ALNUM
#define _lc_ALNUM 0
#endif
#define _lc_LOW_APG (_lc_LOW|_lc_PRINT|_lc_ALNUM)
#define _lc_UPP_APG (_lc_UPP|_lc_PRINT|_lc_ALNUM)
#define _lc_PUN_APG (_lc_PUN|_lc_PRINT)
#define _lc_SPC_APG (_lc_SPC|_lc_PRINT)
#else  /*!defined(_lc_PRINT) && !defined(_lc_ALNUM)*/
#define _lc_PRINT 0
#define _lc_ALNUM 0
#define _lc_LOW_APG  _lc_LOW
#define _lc_UPP_APG  _lc_UPP
#define _lc_PUN_APG  _lc_PUN
#define _lc_SPC_APG  _lc_SPC
#endif /*!defined(_lc_PRINT) && !defined(_lc_ALNUM)*/
#define _lc_ctype_INIT int _lc_LUP = _lc_LOW|_lc_UPP|_lc_PUN
                       /* Can be modified locally */

#ifdef    _Windows
#ifdef    USE_OLENLS
/*#ifndef   SORT_STRINGSORT
#define   SORT_STRINGSORT 0x1000
#endif*/
#define   CompStr(aa,bb) (CompareStringA(intl, \
    /*SORT_STRINGSORT |*/ NORM_IGNORENONSPACE, \
                                         aa, -1, bb, -1) - 2)
#elif !defined(__WINDOWS_386__)
#define   CompStr         lstrcmp
#endif /*!USE_OLENLS*/

#ifndef  _LC_WIN
static void dos_2_win(char *s) { if (!_lc_Win) OemToAnsi(s,s); }
static void win_2_dos(char *s) { if (!_lc_Win) AnsiToOem(s,s); }
#elif    _LC_WIN
#define     dos_2_win(s)
#define     win_2_dos(s)
#else /*!_LC_WIN*/
#define     dos_2_win(s)                       OemToAnsi(s,s)
#define     win_2_dos(s)                       AnsiToOem(s,s)
#endif /*_LC_WIN defined*/
#else  /*!_Windows*/
#endif /*!_Windows*/

#ifndef   USE_OLENLS

#ifndef  _Windows

static void buildCtype(ctype_t       *cType2,
               unsigned char         *toLowt, /*   may be NULL */
         const unsigned char DOS_FAR *toUppt, int ii,
         const unsigned char DOS_FAR *collat, int len)
{
 _lc_ctype_INIT | _lc_SPC | _lc_PRINT | _lc_ALNUM;

 while(--ii >= 0x80)   /* only second half of toUppt is used */
   {
    int cc;
    if (ii != (cc = toUppt[ii]))
      if (cc >= 0x80)
        {
         cType2[cc] = _lc_UPP_APG;
         cType2[ii] = _lc_LOW_APG;
         if (toLowt) toLowt[cc] = ii;
        }
      else cType2[ii] = isalpha(cc) ? _lc_LOW_APG:  /*_lc_SPC_APG??*/
                        (CtypeT[cc] & _lc_LUP/*_lc_PUN_APG*/);
   }

 for(ii = 0x80; ii < len; ii++)
   if (!cType2[ii])
     {
      int j = len;
      int cc = collat[ii];
#if       INTERPOLATE_CTYPEF /* expansion to near flags */
      int mf, mp, mn;
      mf = mp = mn = 0;
      while(--j >= 0)
        {
         int flg;
         if (flg = CTYPE(j) & _lc_LUP)
           {
            int clj = collat[j];
                 if (cc == clj)     mf |= flg;
            else if (cc == clj + 1) mp |= flg;
            else if (cc == clj - 1) mn |= flg;
        }  }
      if (!mf) mf = mp & mn;
#else  /*!INTERPOLATE_CTYPEF*/
      int mf = 0;
      while(--j >= 0)
        {
         int flg;
         if (cc == collat[j] &&
             (flg = CTYPE(j) & _lc_LUP)) mf |= flg;
        }
#endif /*!INTERPOLATE_CTYPEF*/
           if (mf & _lc_PUN) mf = _lc_PUN_APG; /* only ONE */
      else if (mf & _lc_UPP) mf = _lc_UPP_APG;
      else if (mf & _lc_LOW) mf = _lc_LOW_APG;
      cType2[ii] = (ctype_t)mf;
     }
}

#else  /*_Windows*/

static void buildCtype(ctype_t       *cType2,
                       unsigned char *toLowt, /*   may be NULL */
                       unsigned char *toUppt) /* newer be NULL! */
{
#if       INTERPOLATE_CTYPEF   /* What's more ? */
 static const char  cp1252[] = "\x80\x81\x8D\x8E\x8F\x90\x9D\x9E";
 static const char *cp125X[] =
       {
/*1250*/ "\x80\x81\x83\x88"                  "\x90\x98",
/*1251*/             "\x88"                      "\x98",
/*1252*/ cp1252, /*"\x80\x81"    "\x8D\x8E\x8F\x90"          "\x9D\x9E"*/
/*1253*/ "\x80\x81"  "\x88\x8A\x8C\x8D\x8E\x8F\x90\x98\x9A\x9C\x9D\x9E\x9F",
/*1254*/ cp1252, /*"\x80\x81"    "\x8D\x8E\x8F\x90"          "\x9D\x9E"*/
/*1255*/ "\x80\x81"      "\x8A\x8C\x8D\x8E\x8F\x90"  "\x9A\x9C\x9D\x9E\x9F",
/*1256*/ "\x80\x81"      "\x8A"  "\x8D\x8E\x8F\x90\x98\x9A"          "\x9F",
/*1256??? "", */
/*1257*/ "\x80\x81\x83\x88\x8A\x8C"          "\x90\x98\x9A\x9C"      "\x9F"
/*1257   "\x80\x81\x83\x88\x8A\x8C\x8D\x8E\x8F\x90\x98\x9A\x9C\x9D\x9E\x9F"*/
       };
 const char *knownCP = "";
#endif
 int ii;
 _lc_ctype_INIT | _lc_SPC | _lc_PRINT | _lc_ALNUM;
 unsigned char oa[2]; oa[1] = '\0';

#if       INTERPOLATE_CTYPEF   /* What's more ? */
 if (ii = GetPrivateProfileInt("boot", "wincodepage", 0, "system.ini"))
   knownCP = (0 <= (ii -= 1250) &&
             ii < sizeof(cp125X)/sizeof(cp125X[0]))? cp125X[ii]: NULL;
#endif

 for(ii = 0x80; ii < 0x100; ii++)
   {
    toUppt[ii] = oa[0] = ii; dos_2_win(oa);
    if (IsCharUpper(oa[0]))
      {
       cType2[ii] = _lc_UPP_APG;
       if (toLowt)
         {
          AnsiLower(oa);
          win_2_dos(oa);
          toLowt[ii] = oa[0];
      }  }
    else if (IsCharLower(oa[0]))
      {
       cType2[ii] = _lc_LOW_APG;
       AnsiUpper(oa);
       win_2_dos(oa);
       toUppt[ii] = oa[0];
      }
#if       INTERPOLATE_CTYPEF   /* What's more ? */
    else if (knownCP)
      {
#if !defined(_LC_WIN) || !_LC_WIN
       win_2_dos(oa);
       if (oa[0] == ii)
#endif
         cType2[ii] =
#if !defined(_LC_WIN) ||  _LC_WIN
         ii == 0xA0 ? _lc_SPC_APG: /* no-break space, how about _lc_CTL? */
         strchr(knownCP, ii)? _lc_CTL:
#endif
                      _lc_PUN_APG;
      }
#endif /* INTERPOLATE_CTYPEF*/
   }
}
#endif /*_Windows*/
#else   /*USE_OLENLS*/

static LCID buildCtype(LCID intl,
                       ctype_t       *cType2,
                       unsigned char *toLowt, /*   may be NULL */
                       unsigned char *toUppt) /* newer be NULL! */
{
 int ii;
 unsigned char  cgtype[0x80];
 unsigned short w_type[0x80];
 _lc_ctype_INIT;

 for(ii = 0x80; ii <= 0xff; ii++) cgtype[ii - 0x80] = ii;
#ifndef _LC_WIN
 if   (!_lc_Win) OemToAnsiBuff(cgtype, cgtype, 0x80);
#elif  !_LC_WIN
                 OemToAnsiBuff(cgtype, cgtype, 0x80);
#endif
 if (FALSE == GetStringTypeA(intl, CT_CTYPE1,
                             cgtype, 0x80, w_type)) return _lcn_BAD_;
 LCMapStringA(intl, LCMAP_UPPERCASE,
              cgtype, 0x80, toUppt + 0x80, 0x80);
 if (toLowt)
 LCMapStringA(intl, LCMAP_LOWERCASE,
              cgtype, 0x80, toLowt + 0x80, 0x80);

#if !defined(_LC_WIN) || !_LC_WIN
#if !defined(_LC_WIN)
 if        (!_lc_Win)
#endif
   {
    AnsiToOemBuff(cgtype,        cgtype,        0x80);
    AnsiToOemBuff(toUppt + 0x80, toUppt + 0x80, 0x80);
    if (toLowt)
    AnsiToOemBuff(toLowt + 0x80, toLowt + 0x80, 0x80);
   }
#endif     /*_LC_WIN*/

 for(ii = 0x80; ii <= 0xff; ii++)
   {
    int ix = w_type[ii - 0x80], iy = 0;

/*  Condition below necessary if !_lc_Win.
    if _lc_Win - side effect on errors above is used */
    if (ii == cgtype[ii - 0x80])
      {
            if (ix & C1_CNTRL) iy |= _lc_CTL;
       else if (ix & C1_PUNCT) iy |= _lc_PUN_APG;
       else if (ix & C1_SPACE) iy |= _lc_SPC_APG;
       else if (ix & C1_UPPER) iy |= _lc_UPP_APG;
       else if (ix & C1_LOWER) iy |= _lc_LOW_APG;
      }
    else
      {
       if (toLowt)
         toLowt[ii] = ii;
       toUppt[ii] = ii;
      }
    cType2[ii] = iy;
   }

 return intl;
}

#endif  /*USE_OLENLS*/

#ifdef   _Windows

#ifdef   USE_OLENLS
static void getCollat(LCID intl)
#else
static void getCollat(void)
#endif
{
#if !defined(_LC_WIN) || !_LC_WIN
 unsigned char hash_[0x100]; /* temporary hash */
#define    Hoem2win(x)   (hash_[x])
#define SetHoem2win(x,y) (hash_[x] = (y))
#else
#define    Hoem2win(x)   (x)
#define SetHoem2win(x,y) (y)
#endif     /*_LC_WIN*/
#ifdef __WINDOWS_386__
#define CompStr(a,b) (lstrcmp_hi? (short)InvokeIndirectFunction \
                     (lstrcmp_hi, (a), (b)) : \
                      lstrcmp(    (a), (b)) )
 HINSTANCE libUSER;
 FARPROC lstrcmp_p;
 HINDIR lstrcmp_hi = 0;
#endif
 int ii;
 unsigned char aa[2], bb[2];
 aa[1] = bb[1] = /* '\0'; */
 _lc_collate[0] = SetHoem2win(0, '\0'); /* 0 reserved for '\0' */

#ifdef __WINDOWS_386__
 if (HINSTANCE_ERROR <= (libUSER = LoadLibrary("USER"))
    && (lstrcmp_p = GetProcAddress(libUSER, "lstrcmp")))
   lstrcmp_hi = GetIndirectFunctionHandle(
                lstrcmp_p, INDIR_PTR,  INDIR_PTR, INDIR_ENDLIST);
#endif

 for(ii = 1; ii < 0x100; ii++)
   {
    aa[0] = ii;
#if !defined(_LC_WIN) || !_LC_WIN
                   dos_2_win(aa);
    bb[0] = aa[0]; win_2_dos(bb);
    if (bb[0] != ii) _lc_collate[ii] = ii, SetHoem2win(ii, '\0');
    else
#endif
      {
       int jj, weight;
       SetHoem2win(ii, aa[0]);
#if 0
       for(weight = jj = 1; jj < ii; jj++)  /* '\0' == '\1' !!! */
         if (bb[0] = Hoem2win(jj)) /* == jj) */
           {
            int cv, wg = _lc_collate[jj];
            if (!(cv = CompStr(bb, aa))) { weight = wg; goto Break; }
            else if (cv < 0 && weight <= wg) weight = wg + 1;
#else
       weight = 1; jj = ii;
       while(--jj > 0)  /* '\0' == '\1' !!! */
         {
          int cv, wg;    /* == jj) */
          if ((bb[0] = Hoem2win(jj)) &&
              (wg = _lc_collate[jj]) >= weight)
            if (!(cv = CompStr(bb, aa))) { weight = wg; goto Break; }
            else if (cv < 0 /*&& weight <= wg*/) weight = wg + 1;
#endif
         }
       for(jj = 1; jj < ii; jj++)
         if (weight <= _lc_collate[jj]) _lc_collate[jj]++;
Break: _lc_collate[ii] = weight;
      }
   }

#ifdef __WINDOWS_386__
 if (lstrcmp_hi) FreeIndirectFunctionHandle(lstrcmp_hi);
 if (HINSTANCE_ERROR <= libUSER) FreeLibrary(libUSER);
#endif
}
#endif /*_Windows*/

/*-----------------------------------------------------------------------*/

static void rebuildWeight(unsigned char weight[0x100],
                          unsigned char collat[0x100],
                          int min, int max, int add)
{
 int ii;
 memset(weight, 0, 0x100);
 for(ii = 0; ii < 0x100; ii++)
   {
    int fx;
    if (max > (fx = collat[ii]) &&
        min <= fx) collat[ii] = fx += add;
    weight[fx]++;
   }
}

static void buildColl(const ctype_t *cType2  /* second half */
#ifndef  _Windows
                    , unsigned char *COLLAT) /* [0x100]     */
#else
                                           )
#define                              COLLAT _lc_collate
#endif

{
 unsigned ii;
 unsigned char weight[0x100];
 _lc_ctype_INIT | _lc_SPC | _lc_CTL;

 rebuildWeight(weight, COLLAT, 0, 0, 0);

 for(ii = 0; ii < 0x100; ii++)
   {
    int lmf = _lc_LOW;

    if (!weight[ii])
      {
       int nw = ii;
       do if (++nw >= 0x100) goto Break;
       while(!weight[nw]);            /* 0x100 */
       rebuildWeight(weight, COLLAT, nw, nw +1, ii - nw);
      }

    while(weight[ii] > 1)
      {
       int ci = ii, fc;   /* cleaning the next weight */
       do if (++ci >= 0x100) goto Break;
       while(weight[ci]);
       if (ci - ii > 1)
         rebuildWeight(weight, COLLAT, ii +1, ci, 1);

       fc = 0;
       for(ci = 0xff; ci > 0; ci--) /* what types are presents? */
         if (ii == COLLAT[ci])
           {
            int fx;
            if ((fx = CTYPE(ci) & _lc_LUP) & _lc_CTL
         /*??*/ && !(fx & ~_lc_CTL) /*!(fx & _lc_SPC)*/
                || !ii)
              {          /* full resolving of Control characters */
               weight[ii]--;
               weight[++COLLAT[ci]]++;
               if (ii) goto Continue;
              }
            else fc |= fx;
           }

       if (!(fc & lmf)) lmf = _lc_UPP;
       if (!(fc & lmf) || !(fc & ~lmf)) break;
                 /* resolving by case (UPP/LOW) */
       for(ci = 0; ci < 0x100; ci++)
         if (ii == COLLAT[ci] &&
             lmf == (_lc_LUP & CTYPE(ci)))
           {  /* ^ signed ctype_t must works correctly here ?? */
            weight[ii]--;
            weight[++COLLAT[ci]]++;
           }
       if (lmf == _lc_UPP) break;
       else lmf = _lc_UPP; /* optional - to avoid bad CTYPEs */
Continue: ;
      }
   }
Break: ;
#undef  COLLAT
}

static void buildColl_i(const unsigned char DOS_FAR *igncase2, int si)
{
 unsigned char weight[0x100];

 memcpy(_lc_collati + si, _lc_collate + si, 0x100 - si);
 while(si-- > 0)
   _lc_collati[si] =
   _lc_collate[(si < 0x80 ? _lc_toupper
                          : igncase2)[si]];
 rebuildWeight(weight, _lc_collati, 0, 0, 0);
 si = 0;
 do if (++si >= 0x100) return;
 while(weight[si]);
 if (si > 1)
   rebuildWeight(weight, _lc_collati, 1, si, 1);
}

/*-----------------------------------------------------------------------*/
#if !defined(_Windows)

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 unsigned ii;
 struct _dos_LCT_ dlt;

 if (ccp != _lcn_C_)
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(&dli, sizeof(dli), 1, ccp) ||
        0 > _dos_getLC_(&dlt, sizeof(dlt), 2, ccp =
                              catLID(dli))) return _lcn_BAD_;
   }
 memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
 for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                  _lc_tolower[ii] = ii;
 if (ccp != _lcn_C_)
   {
    if ((ii = dlt.t->size) > 0x80) ii = 0x80;
#if 1 & DOS_FAR_MODE
    _fmemcpy
#else
    memcpy
#endif
          (_lc_toupper + 0x80, dlt.t->t, ii);
    if (0 > _dos_getLC_(&dlt, sizeof(dlt), 6, ccp)) ii = 0;
    else if ((ii = dlt.t->size) > 0x100) ii = 0x100;
    buildCtype(CtypeT, _lc_tolower,
                       _lc_toupper, 0x100, dlt.t->t, ii);
   }
 return ccp;
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 unsigned ii = 0;
 struct _dos_LCT_ dlt;

 if (ccp != _lcn_C_)
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(&dli, sizeof(dli), 1, ccp) ||
        0 > _dos_getLC_(&dlt, sizeof(dlt), 6, ccp =
                              catLID(dli))) return _lcn_BAD_;
    if ((ii = dlt.t->size) > 0x100) ii = 0x100;
#if 1 & DOS_FAR_MODE
    _fmemcpy
#else
    memcpy
#endif
          (_lc_collate, dlt.t->t, ii);
   }
 for(_lc_collate[0] = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;

 if (ccp != _lcn_C_)
   {
    ctype_t cType2[0x80];
    memset(cType2, 0, sizeof(cType2));
    if (0 > _dos_getLC_(&dlt, sizeof(dlt), 2, ccp)) ii = 0;
    else if ((ii = dlt.t->size) > 0x80) ii = 0x80;
    buildCtype(cType2 - 0x80, NULL,
               &dlt.t->t[-0x80], ii += 0x80,
               _lc_collate, 0x100);
    buildColl(cType2 - 0x80, _lc_collate);
    buildColl_i(&dlt.t->t[-0x80], ii);
   }
 else buildColl_i(_lc_toupper, 0x80);
 return ccp;
}

#elif !defined(USE_OLENLS)  /*_Windows*/

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 int ii;

 if (ccp != _lcn_C_ && ccp != _lcn_DEF_) return _lcn_BAD_;
 memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
 for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                  _lc_tolower[ii] = ii;
 if (ccp != _lcn_C_)
   buildCtype(CtypeT, _lc_tolower, _lc_toupper);

 return ccp;
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 int ii;

 if (ccp != _lcn_C_ && ccp != _lcn_DEF_) return _lcn_BAD_;

 for(ii = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;

 if (ccp != _lcn_C_)
   {
    unsigned char igncase2[0x80];
    ctype_t         cType2[0x80];
    memset(cType2, 0, sizeof(cType2));
    buildCtype(cType2 - 0x80, NULL, igncase2 - 0x80);
    getCollat();
    buildColl(cType2 - 0x80);
    buildColl_i(igncase2 - 0x80, 0x100);
   }
 else buildColl_i(_lc_toupper, 0x80);

 return ccp;
}

#else          /*USE_OLENLS*/

LC_ID_ _lc_ctype_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_)
   {
    int ii;
    memset(CtypeT + 0x80, 0, 0x80 * sizeof(ctype_t));
    for(ii = 0x80; ii <= 0xff; ii++) _lc_toupper[ii] =
                                     _lc_tolower[ii] = ii;
    return ccp;
   }
 return buildCtype(ccp, CtypeT, _lc_tolower, _lc_toupper);
}

LC_ID_ _lc_collate_(LC_ID_ ccp)
{
 int ii;
 unsigned char igncase2[0x80];
 ctype_t         cType2[0x80];

 if (ccp == _lcn_C_)
   {
    for(ii = 0; ii <= 0xff; ii++) _lc_collate[ii] = ii;
    buildColl_i(_lc_toupper, 0x80);
   }
 else if (_lcn_BAD_ != (ccp = buildCtype(ccp,
                        cType2 - 0x80, NULL, igncase2 - 0x80)))
   {
    getCollat(ccp);
    buildColl(cType2 - 0x80);
    buildColl_i(igncase2 - 0x80, 0x100);
   }
 return ccp;
}

#endif       /*USE_OLENLS*/

/* end of lc_chars.c */