/*
Ŀ
jzbigltr.c								     
Purpose print a large character 8 * 8 chars on the screen at a given	     
cursor position.							     
Usage: 								     
jzbigltr('J',0,0,'');                                                      
							0000	     
This is the internal representation of the letter 'J'  000000             
with the exception of the char '' instead of a 1.     000000             
Keep this representation in mind while perusing the	000000	     
code below. -Jaz					0000	     
							0000	     
							0000	     
							00000000	     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/

jzbigltr(fchr , frow , fcol , fch , fattr)
char fchr;
int frow,fcol;
unsigned char fch;
int fattr;
{
	     /* point to the character table memory in rom */
  unsigned char far *wtable = (char far *) 0xF000FA6E;
  char wchar,wchrstr[2];		    /* used to call jzscrprn	  */
  int wrow,wcol;

  wtable += (fchr * 8); 		    /* 8 bytes for each character */

  wchrstr[0] = fch;			    /* convert char to str for */
  wchrstr[1] = 0;

  for (wrow = 0 ; wrow < 8 ; wrow ++) {     /* loop through chars in table */
    wchar = *(wtable+wrow);		    /* point to next character */
    for (wcol = 7 ; wcol >= 0 ; wcol --) {  /* loop through 8 bits	*/
      if (wchar & 1)
	jzscrprn(wchrstr,frow+wrow,fcol+wcol,fattr);
      wchar >>= 1;
    }
  }
}

