/*

        Compile this sample and run it.
        After this run TELNET.EXE localhost 10723
        Emulate some activity in TELNET and then look
        at TEST.EXE screen for results.

*/

#include "stdafx.h"
#include <stdio.h>
#include "iport.h"      // IPORT header file

// MyDisconnectCallback - this function is executed after
//                        the remote user disconnected.
int MyDisconnectCallback ( void* Param )
{
    IIpConnection* conn;

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    printf("Disconnect from %d\r\n", conn->GetID() ); // print the connection unique identifier
    return NULL;       // This function shouls always return NULL
}

// MyAcceptCallback - this function is executed after
//                    server had accepted an incoming connection.
//                    If return value is not zero, server closes connection.
//                    This is made to implement ban lists for 'bad' sites etc.
int MyAcceptCallback ( void* Param )
{
    IIpConnection* conn;

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    printf("Connection from %d\r\n", conn->GetID() );
    return 1;   // Accept all incoming connection
}

// MyMsgCallback - this function is executed each time when data package
//                 arrives. Put your package processing code here.
int MyMsgCallback ( void* Param )
{
    IIpConnection* conn;
    char str[255];

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    if ( conn->GetData() )              // if got any input...
    {
        sprintf ( str, "%d :: '%s'",conn->GetID(),conn->GetData() ); // print it
        puts ( str );
        conn->SendPKT ( str, strlen ( str ) );
    }

    return NULL;             // This function shouls always return NULL
}


int main(int argc, char* argv[])
{
    IIpService* myhost;

    // Initialize Windows Sockets.
    if ( IP_OPEN() == -1 )
    {
        puts ("error: Can't initialize WinSock.");
        return 0;
    }

    puts("Starting daemon.");

    // Start the daemon
    if ( -1 == BeginService( TRANS_TCP,            // TCP/IP daemon
                  10723,                // on port=10723
                  MyMsgCallback,        // call this when package arrives
                  MyAcceptCallback,     // call this when new connection is accepted
                  MyDisconnectCallback, // call this when connection dies
                  &myhost)             // store pointer in iphst
                  )
    {
        puts ( "error: Can't start service." );
        IP_CLOSE ();
        return 0;
    }

    puts("Receiving...\r\n***************\r\n");

    // Wait for any keyboard input
    getchar();

    puts("Finishing...");

    // Delete daemon and stop all it's threads.
    FinishService( myhost );

    // Uninitialize Windows Sockets.
    IP_CLOSE();

    // quit from program
    return 0;
}

