;/*************************************************************************
;** interpcom-1.1 (command interpreter - tutorial)                        **
;** samples.cmd : a program file for funct                                **
;**                                                                       **
;** Copyright (C) 1998  Jean-Marc Drezet                                  **
;**                                                                       **
;**  This library is free software; you can redistribute it and/or        **
;**  modify it under the terms of the GNU Library General Public          **
;**  License as published by the Free Software Foundation; either         **
;**  version 2 of the License, or (at your option) any later version.     **
;**									  **
;**  This library is distributed in the hope that it will be useful,      **
;**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
;**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
;**  Library General Public License for more details. 			  **
;**									  **
;**  You should have received a copy of the GNU Library General Public    **
;**  License along with this library; if not, write to the Free		  **
;**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
;**                                                                       **
;** Please mail any bug reports/fixes/enhancements to me at:              **
;**      drezet@math.jussieu.fr                                           **
;** or                                                                    **
;**      Jean-Marc Drezet                                                 **
;**      Institut de Mathematiques                                        **
;**      Aile 45-55                                                       **
;**      2, place Jussieu                                                 **
;**      75251 Paris Cedex 05                                             **
;**      France								  **
;**                                                                       **
; *************************************************************************/
;
;
;-------------------------------------------------------------------------
;-------- program of computation of a power series -----------------------
; serie F Np c n j
;
; F : real DP function 
; F will contain the sum of (c(p)/p!).x^p  from p=0 to p=n
;
; Np : number of points where the series is computed
; c : if  j==0  it is the function c(p)
;     if  j==1  it is a formula giving c(p) in terms of p
;     if  j==3  this parameter is not used, the program calc_func
;		is called and returns c(p) in the variable 'func'
; n : number of terms
; j : the parameter used previously
;------------------------------------------------------------------------
:serie
6
0
-1
desc_func #1
defxr_d xr_temp 1 #2
fix_xr_d xr_temp xmin (xmax-xmin)/(#2-1)
defunc_d f_temp xr_temp
defunc_d f_temp2 xr_temp
defunc_d X_temp xr_temp
fill_func X_temp x
const_func f_temp 1
;
if= #5 L1
p=0
if= #5-1 L2
if= #5-2 L3
goto end
L1:
val_func #3 0
goto L0
L2:
func=#3
goto L0
L3:
calc_func
goto L0
;
;
L0:
rmul f_temp func f_temp2
copy_func f_temp2 #1
fact=1
;
do i 1 #4
mul_func X_temp f_temp f_temp
if= #5 L1b
p=i
if= #5-1 L2b
goto L3b
L1b:
val_func #3 i
goto next
L2b:
func=#3
goto next
L3b:
calc_func
;
next:
fact=fact*i
func=func/fact
rmul f_temp func f_temp2
add_func #1 f_temp2 #1
enddo
;
end:
destroy xr_temp
;
;
;
;
;
;------------------------------------------------------------------------
;-------- test program for 'serie' : computes the exponentiel function -- 
;------------------------------------------------------------------------
:test_serie
1
1
-1
defxr_d xr 1 1001
defxr_d xrw 1 1000
fix_xr_d xr 0 .001
fix_xr_d xrw -1 0.1
defunc_d xx xrw
const_func xx 1
defunc_d F xr
defunc_d F2 xr
serie F 500 xx 20 0
serie F2 500 1 20 1
save_func F F
save_func F2 F2
destroy xrw
destroy xr
;
;
;
;
;
;------------------------------------------------------------------------
;--------------------- test program for 'serie' -------------------------
;    test_serieb a
;    Computes the function sum of (cos(a*p*p)/p!)x^p 
;    for a from 0 to 10 with step 0.5
;------------------------------------------------------------------------
:test_serieb
1
1
-1
defxr_d xr 1 1001
fix_xr_d xr 0 .001
defunc_d F xr
;
do k 0 20
a=k*.5
serie F 500 cos(a*p*p) 20 1
save_func F F_!(k)
enddo
;
destroy xr
;
;
;
;
;
;------------------------------------------------------------------------
;-------- test program for Bessel transforms ---------------------------- 
;------------------------------------------------------------------------
:test_bessel
1
1
-1
defxr_d xr 1 1000
fix_xr_d xr 0 0.003
defxr_d xr3 1 1000
fix_xr_d xr3 0.001 0.03
;
do i 0 5
j=i+1
defunc_d n!(i) xr
fill_func n!(i) x^j
def_four tr!(i) n!(i) 2048
defunc_d G!(i) xr3
def_bes_par zz!(i) i 400
trans_bessel tr!(i) zz!(i) G!(i)
save_func G!(i) G!(i)
defunc_d GG!(i) xr3
fill_func GG!(i) (3.^j)*jv(j,3.*x)/x
save_func GG!(i) GG!(i)
destroy tr!(i)
destroy zz!(i)
enddo
;
;
destroy xr
destroy xr3
;
;
;
;
;
;------------------------------------------------------------------------
;---------- Levy-Khintchin formula --------------------------------------
; This program computes the Levy-Khintchin transform of the function
; 	n(x) = 10*(1-x),    0 <= x <= 1
; i.e. the probability function with Poisson kernel n(x)
;------------------------------------------------------------------------
:Lev_Kh
1
1
-1
defxr_d xr 1 1000
fix_xr_d xr 0 0.001
defunc_d n xr
fill_func n 10*(1-x)
save_func n n
def_four tr1 n 2048
defxr_d xr1 1 2000
fix_xr_d xr1 0 0.0015
defunc_dC fC xr1
trans_four tr1 fC
defunc_d fC.r xr1
defunc_d fC.i xr1
real fC fC.r
imag fC fC.i
save_func fC.i fC.i
defunc_d t xr1
fill_func t x
defunc_d R xr1
defunc_d I xr1
mul_func fC.r t R
mul_func fC.i t I
defunc_d Si xr1
comp_func sin(x) R Si
defunc_d Ex xr1
comp_func exp(-x) I Ex
save_func Ex Ex
save_func Si Si
save_func R R
save_func I I
defunc_d f2 xr1
div_func Si t f2
val_func fC.r 0
fix_func_R f2 1 func
save_func f2 f2
defunc_d f3 xr1
mul_func f2 Ex f3
save_func f3 f3
def_four tr2 f3 2048
defxr_d xr2 1 4000
fix_xr_d xr2 0 0.01
defunc_dC P xr2
trans_four tr2 P
defunc_d P.r xr2
defunc_d P.i xr2
real P P.r
imag P P.i
save_func P.r P.r
save_func P.i P.i
val_func P.r 0
defunc_d cnst xr2
const_func cnst func
defunc_d q xr2
sub_func cnst P.r q
x=2/pi
rmul q x q
save_func q q
val_func q 18
;destroy xr
;destroy xr2
;destroy xr1
destroy tr1
destroy tr2
;
;
;
;
;
;------------------------------------------------------------------------
;------------ Execution of all the preceeding programs ------------------
;------------------------------------------------------------------------
:all
1
1
-1
time 0
test_serie
test_serieb
test_bessel
Lev_Kh
time
;
;
;
;
;
:all2
2
1
-1
time 0
do iii 1 #1
test_serie
test_serieb
test_bessel
Lev_Kh
enddo
time
;
;
;
;
;
