/* strrchr.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strrchr.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strrchr)
#endif

// strrchr() -- Scan a string for the last occurence of a character
//  char * strrchr(const char * const, const int);
// GIVEN:
//	p_str	String to search.
//	chr	Character to search for.
// RETURNS: (r8)
//	pointer	to the last occurence of the character in p_str
//	pointer to the terminating '\0' if not found.
// NOTES:
// only the last byte of chr is significant.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strrchr)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str==r32
chr==r33
ret_ptr==r8
tmp==r11
	mov tmp=0xFF
	and chr=chr,tmp
	mov ret_ptr=r0		// ret_ptr=0;
Loop:
	ld1 tmp=[p_str],1	// tmp=*(p_str++);
	cmp.eq p30,p31=tmp,r0	// if (tmp==0)
	(p30) br.cond.spnt Exit	//  goto Exit
	cmp.eq p30,p31=tmp,chr	// if(tmp==chr)
	(p30) mov ret_ptr=p_str	//   ret_ptr=p_str
	br.cond.sptk Loop	// goto Loop
Exit:
	cmp.eq p30,p31=ret_ptr,r0 // if(ret_ptr==0)
	(p30) mov ret_ptr=p_str
	sub ret_ptr=ret_ptr,r0,1	// --ret_ptr
	
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strrchr)
