/* memcmp.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"memcmp.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(memcmp)
#endif

// memcmp() -- Compare memory blocks.
//  int memcmp(const void * const, const void * const, const int); 
// GIVEN:
//	p_m1	Memory block.
//	p_m2	Memory block.
//	cnt	Number of bytes to compare.
// RETURNS: (r8)
//	<0	m1 < m2
//	0	m1 = m2
//	>0	m1 > m2
// NOTES:
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(memcmp)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_m1==r32
p_m2==r33
cnt==r34
ret_val==r8
tmp1==r9
tmp2==r10
	mov ret_val=r0
	mov ar.lc=cnt
Loop:
	ld1 tmp1=[p_m1],1
	ld1 tmp2=[p_m2],1
	cmp.eq p30,p31=tmp1,tmp2
	(p30) br Equal
	cmp.gtu p30,p31=tmp1,tmp2
	(p30) add ret_val=ret_val,r0,1		// ++ret_val
	(p31) sub ret_val=ret_val,r0,1		// --ret_val
	br Exit
Equal:
	br.cloop=Loop
Exit:
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(memcmp)






