# Makefile.g, ilibc_64.lib
# Byron Young, 2002

DEBUG_YES:=1
DEBUG_NO:=0
ILIBC_64_EXTERN_PTRS_NO:=0
ILIBC_64_EXTERN_PTRS_YES:=1


# =========================================
# Supported configurable parameters.
# -----------------------------------------

# =========================================
# DIR_C_INCLUDE
#  Set to location to copy *.h files into.
#  Will create directory ilibc_64 in this directory.
#  May be exactly equal to DIR_ASM_INCLUDE.
#  No trailing slash.
DIR_C_INCLUDE:=/home/bky/include
# -----------------------------------------

# =========================================
# DIR_ASM_INCLUDE
#  Set to location to copy *.inc files into.
#  Will create directory ilibc_64 in this directory.
#  May be exactly equal to DIR_C_INCLUDE.
#  No trailing slash.
DIR_ASM_INCLUDE:=/home/bky/include
# -----------------------------------------

# =========================================
# DIR_LIB
#  The directory to copy built libraries into.
#  No trailing slash.
DIR_LIB:=/home/bky/lib
# -----------------------------------------

# =========================================
# ILIBC_64_EXTERN_PTRS
#   ILIBC_64_EXTERN_PTRS_NO=0
#     Does not generate pointers to each function.
#     Default if not defined.
#   ILIBC_64_EXTERN_PTRS_YES=1
#     Generates pointers to each function.
#ILIBC_64_EXTERN_PTRS:=0
ILIBC_64_EXTERN_PTRS:=1
# -----------------------------------------

# A little more tweeking, if necessary
# =========================================
# ILIBC_64_PROCEDURE_SECTION_NAME
#   Automatically defaults to .text if not defined.
#   Set to another name as needed.
#   For the default .text, do NOT define!!
#ILIBC_64_PROCEDURE_SECTION_NAME:=.section .text, "ax", "progbits"
# ----------------------------------------

# ========================================
# ILIBC_64_EXTERN_PTRS_SECTION_NAME
#   Automatically defaults to .data if not defined.
#   Set to another name as needed.
#   For the default .data, do NOT define!!
# ILIBC_64_EXTERN_PTRS_SECTION_NAME:=.section .data, "wa", "progbits"
# ----------------------------------------


# Automatically set defaults, the section names are taken care of in the include files
ifndef ILIBC_64_EXTERN_PTRS
ILIBC_64_EXTERN_PTRS:=0
endif

# Create install directories, if necessary
ifeq (exists($(DIR_C_INCLUDE)),0)
error create_install_directory
endif

ifeq (exists($(DIR_ASM_INCLUDE)),0)
error create_install_directory
endif

ifeq (exists($(DIR_LIB)),0)
error create_install_directory
endif

# rest of global Makefile.g

CFLAGS_R:=
CFLAGS_D:=-g -W
CFLAGS_G:=-static -O0 -Wa,-a -Iinclude

ifeq ($(DEBUG),$(DEBUG_NO))
CFLAGS:=$(CFLAGS_G) $(CFLAGS_R)
else
CFLAGS:=$(CFLAGS_G) $(CFLAGS_D)
endif





















































































