/*
 * tstring.c
 *
 * 88-10-01 v1.0	created by greg yachuk, placed in the public domain
 * 88-10-06 v1.1	changed prerequisite list handling
 * 88-11-11 v1.2	fixed some bugs and added environment variables
 *
 */
#include <stdio.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>

#include "tstring.h"


char   *
talloc(n)
int	n;
{
	register char *s;

	s = malloc(n);
	if (s == NULL)
		terror(1, "no free memory");
	return (s);
}


char   *
trealloc(s, n)
register char *s;
int	n;
{
	s = realloc(s, n);
	if (s == NULL)
		talloc(n);	/* force an error */
	return (s);
}


char   *
tstrncpy(s, n)
register char *s;
int	n;
{
	s = strncpy(talloc(n+1), s, n);
	s[n] = '\0';
	return (s);
}


terror(n, s)
int	n;
char   *s;
{
	fputs("Make: ", stderr);
	fputs(s, stderr);
	if (n)
		exit(n);
}


/*
 * token	- take an input string and return a token each call
 *		- default token delimiter characters are `isspace()'
 *		- text between quotes (" and ') is a single token
 *
 *	called as	s = token(string, seps);
 *		or	s = token(string, NULL);
 *
 *	followed by	s = token(NULL, seps);
 *		or	s = token(NULL, NULL);
 *
 *	returns NULL when no more tokens are available
 */
char   *
token(s, sep)
char   *s;
char   *sep;
{
	static char *olds = NULL;
	char	quote = 0;		/* processing a quoted token */

	if (s)	olds = s;		/* we are starting all over again */

	if (!olds || !*olds)
		return (NULL);		/* no tokens left */

	while (isspace(*olds) || (sep && strchr(sep, *olds)))
		++olds;			/* skip leading spaces and sep's */

	if (*olds == NULL)
		return (NULL);		/* remainder is all separator's */

	s = olds;

	while (*olds)
	{
		if (isspace(*olds) || (sep && strchr(sep, *olds)))
		{
			*olds++ = '\0';	/* delimit the token */
			return (s);
		}
		else if (*olds == '"' || *olds == '\'')
		{
			quote = *olds++;
			while (*olds != quote && *olds)
				++olds;	/* search for the proper quote char */
			if (*olds != '\0')
				++olds;	/* didn't hit eos, so skip quote */
		}
		else	++olds;		/* otherwise, pass over char */
	}

	olds = NULL;
	return (s);			/* return last token */
}


/*
 * tokenize	- chop a string up into an array of (char *)'s
 */
char  **
tokenize(input)
char   *input;
{
	char  **argv;
	register int argc = 0;
	register int alen;

	alen = 20;		/* good initial guess */
	argv = (char **) talloc((alen + 1) * sizeof (char *));

	input = token(input, NULL);	/* use default separators */
	while (input)
	{
		if (alen == argc)
			argv = (char **) trealloc((char *) argv,
						  (alen <<= 1)*sizeof (char *));
		argv[argc++] = input;
		input = token(NULL, NULL);
	}

	argv[argc] = NULL;	/* mark end of array */

	return (argv);
}


/*
 * tgets	- read input, swallowing escaped newlines as necessary
 */
char   *
tgets(fd)
FILE   *fd;
{
	static char *input = NULL;
	static int inlen = 0;
	register char *ep;
	int	len;

	if (inlen == 0)
		input = talloc(inlen = 162);

	input[inlen-2] = '\n';
	ep = input - 1;
	while ((fgets(input, inlen, fd)) != NULL)
	{
		for(;;)
		{
			while (input[inlen-2] != '\n' && input[inlen-2] != '\0')
			{
				len = inlen;
				input = trealloc(input, inlen <<= 1);
				ep = &input[len-2];
				input[inlen-2] = '\n';
				fgets(ep+1, len+1, fd);
			}

			while (*++ep);
			*--ep = '\0';
			do {
				--ep;
			} while (isspace(*ep) && ep >= input);

			if (*ep == '\\' && *--ep != '\\')
				fgets(ep+1, inlen - (ep - input) - 1, fd);
			else
				break;
		}

		return (input);
	}

	inlen = 0;
	tfree(input);
	input = NULL;

	return (NULL);
}
