/*
 getargs.h

    header file for the getargs.c source

    Original Author: Allen Hollub
    Modified By: Virgilio So
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifndef __ARGS_H__
#define __ARGS_H__

/* used in struct ARGUMENTS variable "type" */
enum { BOOLEAN, CHARACTER, INTEGER, STRING};

/* pre-defined switch flag */
#define ARG_SLASH '/'
#define ARG_DASH  '-'

/* options */
#define SHOW_FLAGS 1
#define CHAIN_STR  2

/* user filled structure */
typedef struct
{
    char *flag;
    unsigned int  type;
    void *variable;
    char *description;
}
ARGUMENTS;

typedef struct
{
    int option;
    int start;
    int end;
}
ARG_OPTIONS;


#define TAB_SIZE (sizeof(arg_settings)/sizeof(ARGUMENTS))

/* public function prototypes */
int   init_arg(int argc, char **argv, ARGUMENTS *settings, int size, char switcher, ARG_OPTIONS *chain);
char *arg_error(int error_number);
char *get_program_name(char *argv);

#endif
