;

;
; Virtual memory manipulation procedures
;

	TITLE	FXVIRT

	.386p
	.387

FXVIRT_TEXT	SEGMENT	BYTE public USE16 'CODE'
FXVIRT_TEXT	ENDS

_DATA	SEGMENT	WORD public USE16 'DATA'
_DATA	ENDS

_BSS	SEGMENT	WORD public USE16 'BSS'
_BSS	ENDS

DGROUP	GROUP	_DATA, _BSS

;

include ..\source.asm\_fxvmm.inc

;

	extrn		_int86x:NEAR
	extrn		F_PADA@:NEAR

	extrn		_getdisk:NEAR

	extrn		__fxvmm_vrt_handle_buildswap:NEAR
	extrn		__fxvmm_vrt_handle_swapunlink:NEAR

	extrn		_strcpy:NEAR
	extrn		_chsize:NEAR
	extrn		_close:NEAR
	extrn		_lseek:NEAR
	extrn		_open:NEAR

	extrn		_fxvmm_error_code:WORD
	extrn		_fxvmm_global_vrt_handle:WORD

;

	public		__fxvmm_vrt_handle_init
	public		__fxvmm_vrt_handle_absread
	public		__fxvmm_vrt_handle_abswrite
	public		__fxvmm_vrt_handle_free
	public		__fxvmm_vrt_changesize
	public		__fxvmm_vrt_handle_alloc
	public		__fxvmm_vrt_handle_deinit

	public		_fxvmm_local_vrt_handle
	public		_fxvmm_strat_vrt_handle

	public		_fxvmm_vrt_swapsize
	public		_fxvmm_vrt_swapinsize
	public		_fxvmm_vrt_swaptemplate
	public		_fxvmm_vrt_swapdisk
	public	        _fxvmm_vrt_inithandle
	public		_fxvmm_vrt_swaphandle
	public		_fxvmm_vrt_swapname

;

FXVIRT_TEXT	SEGMENT
	assume	cs: FXVIRT_TEXT

;

__fxvmm_vrt_handle_init:

	push	bp
	mov	bp,sp
	sub	sp,+004h
	push	ds
	mov	ax,offset DGROUP:_fxvmm_vrt_swaptemplate  ; target
	push	ax

	call	far ptr _strcpy                           ; call the C function
	add	sp,+008h                                  ; strcpy() to copy swapstring
	call	far ptr _getdisk                          ; get the current disk
	assume	ds: DGROUP

	mov	_fxvmm_vrt_swapdisk,ax                    ; move result (ax) into _fxvmm_vrt_swapdisk
	mov	ax,0180h
	push	ax
	mov	ax,8104h
	push	ax
        push    word ptr [bp-002h]
        push    word ptr [bp-004h]
	call	far ptr __fxvmm_vrt_handle_buildswap
	add	sp,+004h
	push	dx
	push	ax
	push	ds

; We're making a copy of the returned string from the _fxvmm_tempname()
; function, just so that we keep a local variable, wich cannot be changed
; by the user while we're actually opening or closing a swap file.

	mov	ax,offset DGROUP:_fxvmm_vrt_swapname      ; setup _fxvmm_vrt_swapname
	push	ax                                        ; for strcpy()
	call	far ptr _strcpy                           ; copy returned string
	add	sp,+008h                                  ; into _fxvmm_vrt_swapname
	push	dx
	push	ax

; Open the swap file using the ANSI-C function open()

	call	far ptr _open
	add	sp,+008h
	mov	_fxvmm_vrt_swaphandle,ax
	cmp	ax,0FFFFh
	jz	@@L4
	mov	ax,0001h
	jmp	short @@L5
@@L4:	xor	ax,ax

; check to if any error occured, if so put them into the externally
; accessible fxvmm_error_code variable

@@L5:	mov	_fxvmm_vrt_inithandle,ax
	cmp	word ptr _fxvmm_vrt_inithandle,+000h
	jnz	@@L6
	mov	word ptr _fxvmm_error_code,0002h
@@L6:	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_vrt_handle_absread:
	push	bp
	mov	bp,sp
	xor	ax,ax
	push	ax
	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	add	dx,[bp+00Eh]
	adc	ax,[bp+010h]
	push	ax
	push	dx
	push	_fxvmm_vrt_swaphandle
	call	far ptr _lseek
	add	sp,+008h
        push    word ptr [bp+014h]
        push    word ptr [bp+012h]
        push    word ptr [bp+008h]
        push    word ptr [bp+006h]
	push	_fxvmm_vrt_swaphandle
	call	far ptr __fxvmm_longread
	add	sp,+00Ah
	mov	ax,[bp+010h]
	mov	dx,[bp+00Eh]
	add	dx,[bp+012h]
	adc	ax,[bp+014h]
	les	bx,dword ptr [bp+00Ah]
	push	dx
	mov	es:[bx+009h],ax
	mov	dx,ax
	pop	ax
	mov	es:[bx+007h],ax
	pop	bp
	retf

;

__fxvmm_vrt_handle_abswrite:
	push	bp
	mov	bp,sp
	xor	ax,ax
	push	ax
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	add	dx,[bp+00Ah]
	adc	ax,[bp+00Ch]
	push	ax
	push	dx
	push	_fxvmm_vrt_swaphandle
	call	far ptr _lseek
	add	sp,+008h
        push    word ptr [bp+014h]
        push    word ptr [bp+012h]
        push    word ptr [bp+010h]
        push    word ptr [bp+00Eh]
	push	_fxvmm_vrt_swaphandle
	call	far ptr __fxvmm_longwrite
	add	sp,+00Ah
	mov	ax,[bp+00Ch]
	mov	dx,[bp+00Ah]
	add	dx,[bp+012h]
	adc	ax,[bp+014h]
	les	bx,dword ptr [bp+006h]
	push	dx
	mov	es:[bx+009h],ax
	mov	dx,ax
	pop	ax
	mov	es:[bx+007h],ax
	pop	bp
	retf

;

__fxvmm_vrt_handle_free:
	push	bp
	mov	bp,sp
	pop	bp
	retf

;

__fxvmm_vrt_changesize:
	push	bp
	mov	bp,sp
        push    word ptr [bp+00Ah]
        push    word ptr [bp+008h]
        push    word ptr [bp+006h]
	call	far ptr _chsize
	add	sp,+006h
	cmp	ax,0FFFFh
	jz	@@L7
	mov	ax,0001h
	jmp	short @@L8
@@L7:	xor	ax,ax
@@L8:	pop	bp
	retf

;

__fxvmm_vrt_handle_alloc:
	push	bp
	mov	bp,sp
	cmp	word ptr _fxvmm_vrt_inithandle,+000h
	jnz	@@L9
	push	cs
	call	__fxvmm_vrt_handle_init
@@L9:	cmp	word ptr _fxvmm_vrt_inithandle,+000h
	jnz	@@L10
	xor	ax,ax
	pop	bp
	retf
@@L10:	mov	ax,_fxvmm_vrt_swapinsize
	mov	dx,_fxvmm_vrt_swapsize
	add	dx,[bp+006h]
	adc	ax,[bp+008h]
	push	ax
	push	dx
	push	_fxvmm_vrt_swaphandle
	push	cs
	call	near ptr __fxvmm_vrt_changesize
	add	sp,+006h
	or	ax,ax
	jz	@@L12
	les	bx,dword ptr [bp+00Ah]
	mov	ax,_fxvmm_vrt_swapinsize
	mov	dx,_fxvmm_vrt_swapsize
	mov	es:[bx+015h],ax
	mov	es:[bx+013h],dx
	les	bx,dword ptr [bp+00Ah]
	mov	word ptr es:[bx+009h],0000h
	mov	word ptr es:[bx+007h],0000h
	les	bx,dword ptr [bp+00Ah]
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	es:[bx+005h],ax
	mov	es:[bx+003h],dx
	mov	ax,_fxvmm_global_vrt_handle
	and	ax,007Fh
	les	bx,dword ptr [bp+00Ah]
	and	byte ptr es:[bx+002h],80h
	or	es:[bx+002h],al
	mov	ax,_fxvmm_vrt_swapinsize
	mov	dx,_fxvmm_vrt_swapsize
	add	dx,[bp+006h]
	adc	ax,[bp+008h]
	mov	_fxvmm_vrt_swapinsize,ax
	mov	_fxvmm_vrt_swapsize,dx
	mov	ax,0001h
	pop	bp
	retf
@@L12:	mov	word ptr _fxvmm_error_code,0002h
	xor	ax,ax
	pop	bp
	retf

;

__fxvmm_vrt_handle_deinit:
	push	bp
	mov	bp,sp
	cmp	word ptr _fxvmm_vrt_swaphandle,+000h
	jz	@@L13
	push	_fxvmm_vrt_swaphandle
	call	far ptr _close
	add	sp,+002h
	push	ds
	mov	ax,offset DGROUP:_fxvmm_vrt_swapname
	push	ax
 	call	far ptr __fxvmm_vrt_handle_swapunlink
	add	sp,+004h
@@L13:	mov	word ptr _fxvmm_vrt_inithandle,0000h
	pop	bp
	retf

;

__fxvmm_longread:
        push	bp
	mov	bp,sp
	sub	sp,+020h
	mov	ax,[bp+00Eh]
	mov	dx,[bp+00Ch]
	mov	[bp-00Ah],ax
	mov	[bp-00Ch],dx
	mov	ax,[bp+00Ah]
	mov	dx,[bp+008h]
	mov	[bp-00Eh],ax
	mov	[bp-010h],dx
	mov	ax,[bp+006h]
	mov	[bp-01Eh],ax
	mov	byte ptr [bp-01Fh],3Fh
	jmp	@$L1
@$L6:	cmp	word ptr [bp+00Eh],+000h
	jg	@$L2
	jl	@$L3
	cmp	word ptr [bp+00Ch],-001h
	jnc	@$L2
@$L3:	mov	ax,[bp+00Ch]
	jmp	short @$L4
@$L2:	mov	ax,0FFFFh
@$L4:	mov	[bp-01Ch],ax
	mov	ax,[bp-00Eh]
	mov	[bp-002h],ax
	mov	ax,[bp-010h]
	mov	[bp-01Ah],ax
	push	ss
	lea	ax,[bp-008h]
	push	ax
	push	ss
	lea	ax,[bp-020h]
	push	ax
	push	ss
	lea	ax,[bp-020h]
	push	ax
	mov	ax,0021h
	push	ax
	call	far ptr _int86x
	add	sp,+00Eh
	mov	bx,[bp-020h]
	xor	cx,cx
	mov	dx,ss
	lea	ax,[bp-010h]
	call	far ptr F_PADA@
	mov	ax,[bp-020h]
	sub	[bp+00Ch],ax
	sbb	word ptr [bp+00Eh],+000h
	mov	ax,[bp-00Eh]
	mov	[bp-002h],ax
	mov	ax,[bp-010h]
	mov	[bp-01Ah],ax
	cmp	word ptr [bp-014h],+000h
	jz	@$L1
	assume	ds: DGROUP
	mov	word ptr _fxvmm_error_code,0002h
	mov	dx,0FFFFh
	mov	ax,0FFFFh
	mov	sp,bp
	pop	bp
	retf
@$L1:	mov	ax,[bp+00Ch]
	or	ax,[bp+00Eh]
	jz	@$L5
	jmp	@$L6
@$L5:	mov	dx,[bp-00Ah]
	mov	ax,[bp-00Ch]
	sub	ax,[bp+00Ch]
	sbb	dx,[bp+00Eh]
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_longwrite:
	push	bp
	mov	bp,sp
	sub	sp,+020h
	mov	ax,[bp+00Eh]
	mov	dx,[bp+00Ch]
	mov	[bp-00Ah],ax
	mov	[bp-00Ch],dx
	mov	ax,[bp+00Ah]
	mov	dx,[bp+008h]
	mov	[bp-00Eh],ax
	mov	[bp-010h],dx
	mov	ax,[bp+006h]
	mov	[bp-01Eh],ax
	mov	byte ptr [bp-01Fh],40h
	jmp     @$L7
@$L12:	cmp	word ptr [bp+00Eh],+000h
	jg	@$L8
	jl	@$L9
	cmp	word ptr [bp+00Ch],-001h
	jnc	@$L8
@$L9:	mov	ax,[bp+00Ch]
	jmp	short @$L10
@$L8:	mov	ax,0FFFFh
@$L10:	mov	[bp-01Ch],ax
	mov	ax,[bp-00Eh]
	mov	[bp-002h],ax
	mov	ax,[bp-010h]
	mov	[bp-01Ah],ax
	push	ss
	lea	ax,[bp-008h]
	push	ax
	push	ss
	lea	ax,[bp-020h]
	push	ax
	push	ss
	lea	ax,[bp-020h]
	push	ax
	mov	ax,0021h
	push	ax
	call	far ptr _int86x
	add	sp,+00Eh
	mov	bx,[bp-020h]
	xor	cx,cx
	mov	dx,ss
	lea	ax,[bp-010h]
	call	far ptr F_PADA@
	mov	ax,[bp-020h]
	sub	[bp+00Ch],ax
	sbb	word ptr [bp+00Eh],+000h
	mov	ax,[bp-00Eh]
	mov	[bp-002h],ax
	mov	ax,[bp-010h]
	mov	[bp-01Ah],ax
	cmp	word ptr [bp-014h],+000h
	jz	@$L7
	mov	word ptr _fxvmm_error_code,0002h
	mov	dx,0FFFFh
	mov	ax,0FFFFh
	mov	sp,bp
	pop	bp
	retf

@$L7:	mov	ax,[bp+00Ch]
	or	ax,[bp+00Eh]
	jz	@$L11
	jmp	@$L12

@$L11:	mov	dx,[bp-00Ah]
	mov	ax,[bp-00Ch]
	sub	ax,[bp+00Ch]
	sbb	dx,[bp+00Eh]
	mov	sp,bp
	pop	bp
	retf

;

FXVIRT_TEXT	ENDS
_DATA	SEGMENT

_fxvmm_local_vrt_handle	db	001h
                     	db	000h
                   	dd	FXVIRT_TEXT:__fxvmm_vrt_handle_alloc
                  	dd	FXVIRT_TEXT:__fxvmm_vrt_handle_free
                    	dd	FXVIRT_TEXT:__fxvmm_vrt_handle_absread
                 	dd	FXVIRT_TEXT:__fxvmm_vrt_handle_abswrite
                  	dd	FXVIRT_TEXT:__fxvmm_vrt_handle_deinit
                 	dd	DGROUP:_fxvmm_global_vrt_handle
_fxvmm_strat_vrt_handle	dd	DGROUP:_fxvmm_local_vrt_handle

_DATA	ENDS

;

_BSS	SEGMENT

_fxvmm_vrt_swapsize	dw	1  dup(?)
_fxvmm_vrt_swapinsize	dw	1  dup(?)
_fxvmm_vrt_swaptemplate	db	80 dup(?)
_fxvmm_vrt_swapdisk	dw	1  dup(?)
_fxvmm_vrt_inithandle	dw	1  dup(?)
_fxvmm_vrt_swaphandle	dw	1  dup(?)
_fxvmm_vrt_swapname	db	80 dup(?)

_BSS	ENDS
END

;
