/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strmvstr
 *
 *  Description :  Copy an input string in an output string
 *		   with replacing all occurences of a target string.
 *
 *  Parameters  :  out      char  *out_str    result
 *                 in       char  *in_str     in string
 *                 in       char  *target     target string to replace
 *                 in       char  *new_str    string to put in place of target
 *
 *  Return code :  pointer to result.
 *
 *  OS/Compiler :  All
 ***/ 
      
char *strmvstr( char *out_str, const char *in_str, const char *target, const char *new_str )

{ char *ptr = out_str;
  const char *ptr_new = new_str;
  unsigned count;

  for ( count = 0; *out_str = *in_str; out_str ++, in_str ++ )
      if ( *out_str == *target ) { target ++; count ++;
      				   if ( ! *target )
    				      { out_str -= count - 1;
    				        target -= count;
    				        count = 0;
    				        while ( *out_str++ = *new_str++ );
				        new_str = ptr_new;
				        out_str --; out_str --;
				      }
				 }
			    else { target -= count;
			     	   out_str -= count;
				   in_str -= count;
				   count = 0;
				 }

  return ptr;
}
