/* reflex.h: structure definitions for Reflex data bases */

#define HANDLE   void far *                       /* 32-bit pointer */
#define RXID     "3Q.!&@#$!&&"                 /* Reflex identifier */

typedef struct {                    /* data file section descriptor */
  int  dfType;                                /* section tytpe code */
  long dfAddr;                        /* start addr in file (bytes) */
  long dfLen;                                     /* length (bytes) */
} DFDESC;

typedef struct {                           /* file header structure */
  int    hdrSz;                        /* size of file header = 512 */
  char   stamp[12];               /* identification = "3Q.!&@#$!&&" */
  int    dirty;                    /* non-zero implies corrupt file */
  int    verViews;                       /* view info version level */
  int    verModels;                /* modeling system version level */
  int    verData;                         /* raw data version level */
  int    fRecalc;              /* non-zero implies recalc necessary */
  char   screenType;         /* active screen type at file creation */
  char   checkSum;                                 /* file checksum */
  char   reserved[38];                   /* reserved for future use */
  int    sectionCt;            /* number of sections of type DFDESC */
  DFDESC dfSection[];                        /* section descriptors */
} DFHDR;

typedef struct {                                 /* field sort spec */
  unsigned  fldType     : 7;           /* used internally by Reflex */
  unsigned isAscending  : 1;                       /* sorting order */
  unsigned  fieldID     : 8;      /* field ID: index to field defin */
} FLDSORTSPEC;

typedef FLDSORTSPEC SORTSPEC[6];                /* sort specs array */

typedef struct {                     /* text table master structure */
  HANDLE    index;                              /* pointer to index */
  HANDLE    pool;                           /* pointer to text pool */
} ETREC;

typedef struct {                         /* field descriptor record */
  unsigned nameOffset;         /* offset of field name in name pool */
  char     dataType;                                  /* field type */
  char     precision;                /* decimal precision = 5 bits,
                                             field formats = 3 bits */
  unsigned fldOffset;                  /* offset of field in record */
  ETREC    etr;                              /* repeating text info */
  unsigned isDescend : 1;                        /* descending flag */
  unsigned sortPos : 7;                          /* sort precedence */
  unsigned reserved : 8;                                /* not used */
} FLDDESC;

typedef struct {                         /* data base master record */
  unsigned totalRecs;            /* total number of records in file */
  unsigned filtRecs;    /* # recs passing most recent global filter */
} MASTREC;

/* GLOBALS */
FILE           *lst;                                    /* printer */
unsigned       nflds;                       /* # field descriptors */
unsigned       base, temp;  /* point of reference for control info */
int            *work;             /* for getting lengths from file */
DFHDR          *head;                             /* header record */
DFDESC         *descr;                 /* section descriptor table */
SORTSPEC       *sort;                   /* global sort specs table */
char           *pool;                           /* field name pool */
FLDDESC        *dtable;                  /* field descriptor table */
int            *etpool;                    /* enumerated text pool */
MASTREC        *mast;                             /* master record */
