#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*        MS-WINDOWS front end       */
/*                                   */
/*     general windows functions     */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include "commdlg.h"
#include "strtbl.h"
#include "defines.h"
int		cxChar, cyChar;				/* text scale                           */
WORD	wAdjX, wAdjY;				/* constants to adjust x-y units        */

void InitTxtMetrics( HWND hWnd );
int TxtX( int x );
int TxtY( int y );
void InitScrScale( void );
WORD ScrX( int x );
WORD ScrY( int y );
short AskAboutSave( HWND hWnd, HANDLE hInst, char *fn, WORD style );
LPSTR FAR PASCAL GetOFileName( HWND hWnd, LPSTR achFileName, int sizebuff, LPSTR title, LPSTR filter );
LPSTR FAR PASCAL GetSFileName( HWND hWnd, LPSTR achFileName, int sizebuff, LPSTR title, LPSTR filter );
void ErrorHandler( HANDLE hInst, int nRc );

#pragma alloc_text( CODE15, InitTxtMetrics, TxtX, TxtY, InitScrScale, ScrX, ScrY, AskAboutSave, GetOFileName, GetSFileName)


/*
  3 functions to convert coordinates into proper text coordinates. Usage: call
  InitTxtMetrics(hWnd) as early as possible (for example when initializing the instance).
  Then use TxtX( xcoordinate) and TxtY( ycoordinate ) instead of xcoordinate or ycoordinate
*/

void InitTxtMetrics( HWND hWnd )
{
 HANDLE hDC;
 TEXTMETRIC tm;

 hDC = GetDC( hWnd );
 GetTextMetrics( hDC, &tm );
 cxChar = tm.tmAveCharWidth;
 cyChar = tm.tmHeight + tm.tmExternalLeading;
 ReleaseDC( hWnd, hDC );
}

int TxtX( int x )
{
 return (x +1) * cxChar;
}

int TxtY( int y )
{
 return (y + 1) * cyChar;
}


/*
  3 functions to convert coordinates into proper screen coordinates. Usage: call InitScr()
  as early as possible (for example when initializing the instance). Then use
  ScrX( xcoordinate) and ScrY( ycoordinate ) instead of xcoordinate or ycoordinate
*/

void InitScrScale( void )
{
 LONG lDlgBaseUnits;                                    /*dialog base units                     */

 lDlgBaseUnits = GetDialogBaseUnits();
 wAdjX = LOWORD(lDlgBaseUnits);
 wAdjY = HIWORD(lDlgBaseUnits);
}

WORD ScrX( int x )
{
 return (x * wAdjX)/4;
}

WORD ScrY( int y )
{
 return (y * wAdjY)/8;
}


/*
  a function to ask if the user wants to save before exiting
*/
short AskAboutSave( HWND hWnd, HANDLE hInst, char *fn, WORD style )
{
 char buff[256], buff2[128];
 short nRet;

 LoadString(hInst, IDS_SAVEQUERY, buff2, sizeof(buff2));
 wsprintf( buff, buff2, (LPSTR) ( fn[0] ? fn : "<untitled>" ) );
 MessageBeep( MB_ICONQUESTION );
#ifdef GWTOP
 nRet = MessageBox( hWnd, buff, (LPSTR) "Topology", style);
#else
 nRet = MessageBox( hWnd, buff, (LPSTR) "Simulation", style);
#endif
 if( (nRet == IDYES) || (nRet == IDOK) )
  SendMessage( hWnd, WM_COMMAND, fn[0] ? IDM_F_SAVE : IDM_F_SAVEAS, 0 );
 return nRet;
}

/*
  a function to call the open file common dialog
*/

LPSTR FAR PASCAL GetOFileName( HWND hWnd, LPSTR achFileName, int sizebuff, LPSTR title, LPSTR filter )
{
    OPENFILENAME    ofn;

    /* first fill up the ofn structure */
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
    ofn.lpstrFilter = filter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nFilterIndex = 1;
	*achFileName = '\0';		/* pass in NULL */
	ofn.lpstrFile = achFileName;
	ofn.nMaxFile = sizebuff;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = title;
	ofn.lpstrFileTitle = NULL;
    ofn.lpstrDefExt = NULL;
    ofn.Flags = OFN_HIDEREADONLY |
                OFN_PATHMUSTEXIST;
    if (  GetOpenFileName( (LPOPENFILENAME) &ofn ) ) return achFileName;
    else return NULL;
}

/*
  a function to call the save file common dialog
*/

LPSTR FAR PASCAL GetSFileName( HWND hWnd, LPSTR achFileName, int sizebuff,
                               LPSTR title, LPSTR filter )
{
    OPENFILENAME    ofn;

    /* first fill up the ofn structure */
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
    ofn.lpstrFilter = filter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nFilterIndex = 1;
	/**achFileName = '\0';		pass in NULL */
	ofn.lpstrFile = achFileName;
	ofn.nMaxFile = sizebuff;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = title;
	ofn.lpstrFileTitle = NULL;
    ofn.lpstrDefExt = NULL;
    ofn.Flags = OFN_HIDEREADONLY |
                OFN_NOREADONLYRETURN |
                OFN_OVERWRITEPROMPT |
                OFN_PATHMUSTEXIST;
    if (  GetSaveFileName( (LPOPENFILENAME) &ofn ) ) return achFileName;
    else return NULL;
}

void ErrorHandler( HANDLE hInst, int nRc )
{
 char szString[128];					/* variable to load resource strings    */

 if( nRc < 32 )
 switch( nRc )
 {
  case 0:
   LoadString( hInst, IDS_ERR_NOEXEC, szString, sizeof(szString) );
   MessageBeep( MB_ICONEXCLAMATION );
   MessageBox( NULL, szString, NULL, MB_ICONEXCLAMATION );
   break;
  case 2:
  case 3:
   LoadString( hInst, IDS_ERR_BADCONFIG, szString, sizeof(szString) );
   MessageBeep( MB_ICONEXCLAMATION );
   MessageBox( NULL, szString, NULL, MB_ICONEXCLAMATION );
   break;
  default:
   LoadString( hInst, IDS_ERR_UNDEF, szString, sizeof(szString) );
   MessageBeep( MB_ICONEXCLAMATION );
   MessageBox( NULL, szString, NULL, MB_ICONEXCLAMATION );
 }
 return;
}
