/*
    Filename: C:\DAVE\CPP\BIBLE\biblevrs.cpp
    Author  : Dave Nelson
    Created : Thu 26-Nov-1998 19:55:12
    Modified: Fri 20-Aug-1999 15:33:46 - Dave Nelson
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAXLEN      132

extern int random(int min, int max);
int exist(const char *fn){
FILE *fp = fopen(fn,"r");
    if(fp){
        fclose(fp);
        return -1;
        }
    else return 0;
    }
const char *bible = "BIBLEVRS.TXT";

main(int argc, char **argv){
int vc,rv;                              // verse count, read verse #
int lv;                                 // last verse
int cnt;                                // TRUE==count the verses
int sho;                                // TRUE==show verse number
int lst;                                // TRUE==repeat last verse
int mem;                                // >0==memorize, <0==randomize
int i;
char s[MAXLEN+1];                       // input string
long lpos,mpos,cpos;                    // last/memorize/count positions
char fn[80]="\0", *cp, addr[80];
FILE *fp;
    vc=cnt=sho=mem=lst=0;
    lv=rv=-1;
    lpos=mpos=cpos=0L;
    for(argc--; argc; argc--){
        cp = argv[argc];
        if(*cp=='/'||*cp=='-') switch(toupper(*(cp+1))){
            case 'C':                   // count verses
                cnt++;
                break;
            case 'F':                   // file name
                strcpy(fn,strupr(cp+2));
                break;
            case 'L':                   // repeat last
                lst++;
                break;
            case 'M':                   // memorize
                if( (i = atoi(cp+2)))   rv = i-1;
                mem=1;
                break;
            case 'N':                   // force verse number
                rv = atoi(cp+2)-1;
                break;
            case 'R':                   // randomize (stop memorizing)
                mem=-1;
                break;
            case 'S':                   // show verse number
                sho++;
                break;
            case '?':                   // help!
            case 'H':
                fprintf(stderr,"\nBible Verse-a-Day\tv1.01\t(c) 1998,99 by Dave Nelson\n");
                if(*(cp+2)=='?')
                    fprintf(stdout,
                    "\nThe verse file is a simple text file containing commands and verses. Lines"
                    "\nbeginning with '#' are comments. The command section comes first, and contains:"
                    "\n\tCLS\t\tClear screen first (optional)."
                    "\n\tCOUNT=00000\tWhere 00000 is the number of verses on file."
                    "\n\tLAST=00000\tLast verse displayed.  If this line is not present,"
                    "\n\t\t\tyou will not be able to use the /m command to"
                    "\n\t\t\tmemorize the last verse automatically."
                    "\n\tMEMORIZE=00000\tVerse number to memorize.  If this line is not"
                    "\n\t\t\tpresent, verse memorization will be disabled."
                    "\n\tPlease note that the COUNT, LAST, and MEMORIZE lines should not be"
                    "\n\tchanged by hand.  If you do change them, make sure they are entered"
                    "\n\texactly as shown, with a five-digit, zero-filled number on the right"
                    "\n\tof the equal sign.\n"
                    "\nFollowing the command section are verses. Each verse must be preceded by a"
                    "\nline starting with '>' and the chapter/verse address.  For example:"
                    "\n\t>John 3:16"
                    "\n\tFor God so loved the world ..."
                    "\nPut as many verses as you like, as long as it's no more than 32,767.  Use -c"
                    "\nto update the count.\n");
                else
                    fprintf(stdout,
                    "\nUsage:\tBIBLEVRS [opts]"
                    "\n\twhere 'opts' is any of the following:"
                    "\n\t-fX\tUse file 'X' for verses (default is .\\BIBLEVRS.TXT)."
                    "\n\t-n123\tForce verse no. 123 to be selected."
                    "\n\t-m\tMemorize the last verse displayed."
                    "\n\t-m123\tMemorize verse number 123."
                    "\n\t-r\tRandomize (cancel memorization)."
                    "\n\t-l\tRepeat the last verse."
                    "\n\t-s\tShow number of verse selected."
                    "\n\t-c\tCount verses and update the COUNT=x line."
                    "\n\t-?\tDisplay this message."
                    "\n\t-??\tDisplay help on text file contents/format.\n");

                    return 0;
                break;
            default:
                fprintf(stderr,"ERROR:\tUnknown option '%s'."
                    "\n\tUse BIBLEVRS -? for help.",cp);
                return 3;
            }
        else strcpy(fn,strupr(cp));
        }

    if(strlen(fn)==0){
        if(exist(bible)) strcpy(fn, bible);
        else {
            strcpy(fn,argv[0]);
            if( (cp = strrchr(fn,'\\'))==NULL) cp = fn;
            else cp++;
            strcpy(cp, bible);
            }
        }

    if( (fp = fopen(fn,"r+"))==NULL){
        fprintf(stderr,"ERROR in %s: Unable to open file.", fn);
        return 1;
        }

    printf("\n");

    while(fgets(s,MAXLEN,fp)){
        if(*s=='#') continue;
        if(*s=='>') break;
        if(strnicmp(s,"CLS",3)==0){
            system(s);
            continue;
            }
        if(strnicmp(s,"COUNT=",6)==0){
            cpos = ftell(fp)-(strlen(s));
            vc = atoi(s+6);
            continue;
            }
        if(strnicmp(s,"LAST=",5)==0){
            lpos = ftell(fp)-(strlen(s));
            lv = atoi(s+5)-1;
            if(lst) rv = lv;
            continue;
            }
        if(strnicmp(s,"MEMORIZE=",9)==0){
            mpos = ftell(fp)-(strlen(s));
            if(!mem && (rv<0)) {        // no /m and no verse yet,
                i = atoi(s+9);          // and there is a MEMORIZE verse,
                if(i) rv = i-1;         // use it.
                }
            continue;
            }
        }

/*  At this point, we should be positioned at the first verse.  */

    if(cnt){
        int nc = 0;
        if(*s=='>') nc++;
        while(fgets(s,MAXLEN,fp)) if(*s=='>') nc++;
        printf("Verse count: %d", nc);
        if(vc==nc) printf("\t(no update required).");
        else {
            fseek(fp,cpos-1,SEEK_SET);
            fprintf(fp,"COUNT=%0.05d\n",nc);
            fclose(fp);
            printf("\t(count updated).");
            }
        return 0;
        }

    if(vc==0) {
        fprintf(stderr,"ERROR: No verses, or no COUNT=x line in %s.",fn);
        return 2;
        }

    if((mem>0) && (rv<0)) rv = lv;
    if(rv<0||rv>=vc) rv = random(0, vc-1);      // if no #, get random #
    for(i=0; i<rv; i++){                        // count verses
        while(fgets(s,MAXLEN,fp)){              // loop thru verse text
            if(*s=='>') break;
            }
        }

/*  Okay, we're at the desired verse.   */

    strcpy(addr, s+1);              // save address of verse
    while(fgets(s,MAXLEN,fp)){
        if(*s=='>') break;
        if(*s=='#') continue;       // might conceivably be a comment here
        printf("%s",s);             // there is already a \n on the line
        }
    printf("\n\t\t%s",addr);        // output the verse address
    if(sho) printf("\n(verse number %d)",rv+1);

    if((lv != rv) && lpos){
        fseek(fp,lpos-1,SEEK_SET);
        fprintf(fp,"LAST=%0.05d\n",rv+1);
        }
    if(mem && mpos){
        fseek(fp,mpos-1,SEEK_SET);
        fprintf(fp,"MEMORIZE=%0.05d\n",(mem<0? 0:rv+1));
        }

    fclose(fp);
    printf("\n");
    return 0;
    }
