/* -- Hershey Font code format converter ------------------------------------
 |
 |    Author: Wayne C. Crawford, University of California, Berkeley.
 |
 |    This program is hereby released into the public domain.
 |    No restriction is placed on the use of code, commercial or otherwise.
 |
 |    Converts Hershey Font in James Hurt format (see README.OLD) to
 |	AutoCAD *.SHP format.
 |
 |    Usage: hrsh2acd fontfile.fnt <--, (where fontfile is in J. Hurt format)
 |	produces output with suffix .SHP
 |
 *--------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#ifndef TRUE
#define TRUE   1
#define FALSE  0
#endif

FILE	*OUTfile, *fopen();		/* some files */
int	aboveheight = 21;
int	belowheight = 6;
int	commandcount = 0;
int	charnum;
int	linelength = 0;
int	lastlength = 0;
int	last_was_cart = FALSE;
int	already_nine = FALSE;
int	skipflag = 1; 		/* 1 if next draw is 'pen up' */
int	oldx, oldy;
char	char_string[1000];
char	*char_name[]= {"spc","kexc","kdblqt","kns","kds","kpc","kand","kapos",
	      	"klp","krp","kas","kpls","kcma","ksub","kper","kdiv","n0",
		"n1","n2","n3","n4","n5","n6","n7","n8","n9","kcol","ksmc",
		"klt","keq","kgt","kqm","kea","uca","ucb","ucc","ucd","uce",
		"ucf","ucg","uch","uci","ucj","uck","ucl","ucm","ucn","uco",
		"ucp","ucq","ucr","ucs","uct","ucu","ucv","ucw","ucx","ucy",
		"ucz","klb","kbkslsh","krb","kcaret","kundrl","krvap","lca",
		"lcb","lcc","lcd","lce","lcf","lcg","lch","lci","lcj","lck",
		"lcl","lcm","lcn","lco","lcp","lcq","lcr","lcs","lct","lcu",
		"lcv","lcw","lcx","lcy","lcz","klbr","kvbar","krbr","ktilde",
		"kdeg","kpls-min","kdiam"};

/* ---- scanint: a function to scan an integer, using n characters of
 *          the input file, ignoring newlines. (scanf won't work
 *          because it also ignores blanks)
 * ------------------------------------------------------------------- */
int scanint(file,n)
FILE *file;
int n;
{
char buf[20];
int i,c;

    for (i=0;i<n;i++)
    {
      	while ((c = fgetc(file)) == '\n') ; /* discard spare newlines */
        if (c == EOF) return(-1);
        buf[i] = c;
    }
    buf[i] = 0;
    return(atoi(buf));
}

/****************************************************************************/
/****************   The following routines translate from    ****************/
/****************   skip/draw/move to AUTOCAD format:	     ****************/
/****************************************************************************/

static void skip()
{
	if (already_nine)
	{
		linelength += sprintf(char_string+linelength,"(0,0),");
		commandcount+=2;
		already_nine = FALSE;
	}
	linelength += sprintf(char_string+linelength,"2,");
	commandcount++;
	skipflag = TRUE;
	last_was_cart = FALSE;
}

static void unskip()
{
	if (already_nine)
	{
		linelength += sprintf(char_string+linelength,"(0,0),");
		commandcount+=2;
		already_nine = FALSE;
	}
	linelength += sprintf(char_string+linelength,"1,");
	commandcount++;
	skipflag = FALSE;
	last_was_cart = FALSE;
}

static int good_polar(x,y)
int x,y;
{
	if (x<0) x*=-1;
	if (y<0) y*=-1;
	if ((x==0)&&(y==0)) return(-1);
	if (x==0) return(1);
	else if (y==0) return(2);
	else if (x==y) return(3);
	else if (x==2*y) return(4);
	else if (y==2*x) return(5);
	else return(0);
}


static void cart_coord(x,y)
int x,y;
{
	char *ninespot;

	if (last_was_cart)
	{
	    if (!already_nine)
	    {
		ninespot = char_string+linelength-lastlength;
		*ninespot = '9';
		already_nine = TRUE;
	    }	
	    linelength += sprintf(char_string+linelength,"(%d,%d),",x,y);
	    commandcount+= 2;
	}	
	else
	{		
		lastlength = sprintf(char_string+linelength,"8,(%d,%d),",x,y);
		linelength += lastlength;
		commandcount+=3;
		already_nine = FALSE;
	}
	last_was_cart = TRUE;
}


static void polar_coord(x,y,type)
int x,y,type;
{
    if ( (x>15) || (y>15) || (x<-15) || (y<-15) )
    	cart_coord(x,y);
    else
    {		 
	if (already_nine)
	{
		linelength += sprintf(char_string+linelength,"(0,0),");
		commandcount+=2;
		already_nine = FALSE;
	}
	switch(type)
	{
	    case 1: if (y > 0)
		    	linelength += sprintf(char_string+linelength,"0%X4,",y);
		    else linelength += sprintf(char_string+linelength,"0%XC,",-y);
		    break;
	    case 2: if (x > 0)
		    	linelength += sprintf(char_string+linelength,"0%X0,",x);
		    else linelength += sprintf(char_string+linelength,"0%X8,",-x);
		    break;
	    case 3: if (x > 0)
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X2,",x);
		    	else linelength += sprintf(char_string+linelength,"0%XE,",x);
		    }
		    else
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X6,",-x);
		    	else linelength += sprintf(char_string+linelength,"0%XA,",-x);
		    }
		    break;
	    case 4: if (x > 0)
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X1,",x);
		    	else linelength += sprintf(char_string+linelength,"0%XF,",x);
		    }
		    else
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X7,",-x);
		    	else linelength += sprintf(char_string+linelength,"0%X9,",-x);
		    }
		    break;
	    case 5: if (x > 0)
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X3,",y);
		    	else linelength += sprintf(char_string+linelength,"0%XD,",-y);
		    }
		    else
		    {
			if (y > 0)
		    	    linelength += sprintf(char_string+linelength,"0%X5,",y);
		    	else linelength += sprintf(char_string+linelength,"0%XB,",-y);
		    }
		    break;
	    default: printf("Error in polar_cord()\n");
	}   
	commandcount++;
	last_was_cart = FALSE;
    }		
}

		
static void out_pos(newx,newy)
int newx,newy;
{
    int relx,rely,type;

    relx = newx-oldx;		
    rely = newy-oldy;		
    if ((type = good_polar(relx,rely)) > 0)
	polar_coord(relx,rely,type);
    else if (type == 0)
	cart_coord(relx,rely);
    else if (skipflag == TRUE)
    {	 
    	skipflag == FALSE;
	commandcount--;		/* Get rid of old skip command */
	linelength -= 2;
	return;	
    }	
    if (skipflag == TRUE)	
        unskip();
    oldx = newx;	
    oldy = newy;	
}


dump_fontinfo(name)	/* Put SHP file header */
char *name;
{
	register int i;
	int linelen;

	fprintf(OUTfile,"\*0,4,%s\n", name);
	fprintf(OUTfile,"%d,%d,0,0\n",aboveheight,belowheight);
}


dump_charinfo()		/* For each character, ASCII code, byte count, name */
{
	register int i;
	int linelen;

	fprintf(OUTfile,"\*%d,%d,%s\n",charnum,commandcount,char_name[charnum-32]);
	i = -1;
	linelen = 0;
doagain:
	if (linelen > 74)
	{
		linelen = 0;
		fprintf(OUTfile,"\n");
	}
	do
	{
	    putc(char_string[++i],OUTfile);
	    linelen++;
	} while( (char_string[i] != ',') && (char_string[i+1] != '\0') );
	if (char_string[i+1] != '\0') goto doagain;
	fprintf(OUTfile,"\n");
}


/****************************************************************************/
main(argc,argv)
int argc;
char **argv;
{
FILE    *INfile;
char    line[2][256];
int     x, y, startx, endx;
int     ipnt, ich, nch, i;
char    readfile[80], writefile[80];
char    *rfname, *wfname;		

    charnum = 32;	
    if (argc != 2) 
    {
        fprintf(stderr, "Usage: HRSH2ACD fontfile.fnt\n");
	fprintf(stderr, "	Converts Hershey Font in J. Hurt format to\n");
	fprintf(stderr, "	AutoCAD .SHP format.\n");	
        exit(1);
    }

    strcpy( readfile, strlwr(argv[1]) );
    strcpy( writefile, readfile);
    rfname = readfile;
    while ( *(++rfname) != '\0' );    /* Check if input filename is OK */
    --rfname; --rfname; --rfname;
    if( strcmp( rfname, "fnt") != 0 )
    {
	printf("Input file suffix must be .fnt\n");
	exit(2);
    }	

    if ( (INfile = fopen(readfile,"r")) == NULL )	/* input file */
    {
        fprintf(stderr,"Can't open input font file: %s\n", readfile);
        exit(1);
    }
    wfname = writefile;		/* make .SHP suffix for output file */
    while(*wfname++ != '.');		
    *wfname++ = 's';	
    *wfname++ = 'h';	
    *wfname = 'p';	
    OUTfile = fopen(writefile,"w"); 
    if( OUTfile == NULL )
    {
	fprintf(stderr,"Can't open output file: %s\n", writefile);
	exit(1);
    }

    linelength = 0;
    dump_fontinfo( writefile );
    fprintf(stderr, "Doing ASCII code....\n");

    while (TRUE) 
    {
	  fprintf(stderr, "   %3d\r", charnum);   /* Show current ASCII code */
          if ((ich = scanint(INfile,5)) < 1) 	
	  {
	      fclose(OUTfile);	
              exit(0);
          }
          nch = scanint(INfile,3);

          for (i=0; i<nch;i++) 
	  {
              if ((i==32) ||(i==68) ||(i==104) ||(i==140)) fgetc(INfile); /* skip newlines */
              line[0][i] = fgetc(INfile);
              line[1][i] = fgetc(INfile);
          }
          fgetc(INfile);

          startx=(int)line[0][0] - (int)'R';
          endx=(int)line[1][0] - (int)'R';

	  oldx = startx;
	  oldy = -9;

      	  skip();
	  /*   .. loop per line of data */
    	  for (ipnt=1;ipnt<nch;ipnt++) 
	  {
      	      if (line[0][ipnt] == ' ') 
	      {
	          /*  .. next data point is a move */
                  skip();
      	      } 
	      else 
	      {
	          /*   .. draw (or move) to this data point */
         	  x=(int)line[0][ipnt] -(int) 'R';
                  y=(int)line[1][ipnt] -(int) 'R';
		  out_pos(x,-y);
      	      }
    	  } /* for loop  .. end of this character */
	  skip();
	  out_pos(endx,-9);
	  sprintf(char_string+linelength-2,"0\0");
	  dump_charinfo();
	  charnum++; 
	  commandcount = 0; 
	  linelength = 0; 
   } /* "infinite" loop */
   fprintf(stderr, "\n");
   exit();
}
