; This program is made by Daniel Horchner.
; email: dbjh@gmx.net

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
videodsc        seg_descriptor  0,0,0, 10010010b, 10000000b,
videosel        dw      0

VBE_Info:
.VBE_Signature  db      'VBE2'          ; Indicate VBE 2.0 info is desired
                resb 14                 ; Not interested in...
.TotalMemory    dw      0
                resb 492                ; Not interested in...

ModeInfo:
.ModeAttributes dw      0
                resb 38                 ; Not interested in...
.PhysBasePtr    dd      0
                resb 212                ; Not interested in...

VidMode         dw      101h            ; 640x480x256
msg0            db      'VBE error.','$'
msg1            db      'No linear framebuffer available.','$'
msg2            db      'Mapping error.','$'

;32-bit code
main:
        mov word [v86r_ax],4f00h
        mov word [v86r_es],seg VBE_Info
        mov word [v86r_di],VBE_Info
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc near @exit

        mov word [v86r_ax],4f01h
        mov cx,[VidMode]
        mov [v86r_cx],cx
        mov word [v86r_es],seg ModeInfo
        mov word [v86r_di],ModeInfo
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc near @exit

        test word [ModeInfo.ModeAttributes],80h
        mov edx,msg1
        jz near errexit                 ; bit 7=1 -> Linear frame buf avail

                                        ; Set up the descriptor fields
        movzx eax,word [VBE_Info.TotalMemory] ; VBE returns # 64KB mem blocks
        shl eax,16                      ; amount video mem in bytes
        dec eax                         ; limit=size-1
        shr eax,12                      ; video mem in 4KB units
        mov [videodsc.limit0_15],ax
        shr eax,8
        and ah,0fh
        or [videodsc.gx00limit16_19],ah ; Who has got a PC with > 256MB VRAM?

        movzx eax,word [VBE_Info.TotalMemory]
        shl eax,16
        mov edx,[ModeInfo.PhysBasePtr]
        call map_phys_addr
        push edx                        ; Save linear address for if no error
        mov edx,msg2
        jc near errexit
        pop edx

        mov [videodsc.base0_15],dx      ; edx=lin addr to access phys memory
        shr edx,16
        mov [videodsc.base16_23],dl
        mov [videodsc.base24_31],dh

        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        or [videodsc.access],ch         ; Set the DPL bits to the CPL

        mov cx,1                        ; Allocate 1 descriptor
        call getdsc
        jc @exit
        mov [videosel],ax

        mov es,bx                       ; es:edi=pointer to 8 byte dsc buffer
        mov edi,videodsc
        mov bx,[videosel]               ; bx=selector
        call setdsc                     ; Set descriptor
        jc @exit

        mov word [v86r_ax],4f02h        ; Set VBE mode
        mov ax,[VidMode]
        mov [v86r_bx],ax
        or word [v86r_bx],4000h         ; bit 14=1 -> Use linear frame buffer
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc @exit

        mov es,[videosel]               ; Fill one screen
        mov ebx,640*480
.next_pixel:
        mov [es:ebx-1],bl
        dec ebx
        jnz .next_pixel

        mov byte [v86r_ah],0            ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        mov word [v86r_ax],3            ; Set video mode 3 (text 80x25x16)
        mov al,10h
        int RMCALL_VECT

@exit:
        jmp exit                        ; Return to real/V86 mode
errexit:
        call dosprint
        jmp exit

check_error:
        clc
        cmp byte [v86r_ah],0
        je .exit
        mov edx,msg0
        call dosprint
        stc
.exit:
        ret
