WITH Ada.Text_IO;
WITH Rationals;
WITH Rationals.IO; 
PROCEDURE Test_Rationals_1 IS
------------------------------------------------------------------
--|                                                              
--| Very rudimentary test of package Rationals and Rationals.IO
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
  
  A: Rationals.Rational;
  B: Rationals.Rational;
  C: Rationals.Rational;
  D: Rationals.Rational;
  E: Rationals.Rational;
  F: Rationals.Rational;

BEGIN -- Test_Rationals_1

  A := Rationals."/"(1,3);
  B := Rationals."/"(2,-4);
  Ada.Text_IO.Put(Item => "A = ");
  Rationals.IO.Put(Item => A);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "B = ");
  Rationals.IO.Put(Item => B);
  Ada.Text_IO.New_Line;

  -- Read in rational numbers C and D.   
  Ada.Text_IO.Put(Item => "Enter rational number C > ");
  Rationals.IO.Get(Item => C);
  Ada.Text_IO.Put(Item => "Enter rational number D > ");
  Rationals.IO.Get(Item => D);
  Ada.Text_IO.New_Line;

  E := Rationals."+"(A,B);                   -- form the sum   
  Ada.Text_IO.Put(Item => "E = A + B is ");
  Rationals.IO.Put(Item => E);  
  Ada.Text_IO.New_Line;

  F := Rationals."*"(C,D);                   -- form the product
  Ada.Text_IO.Put(Item => "F = C * D is ");
  Rationals.IO.Put(Item => F);  
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "A + E * F is ");
  Rationals.IO.Put(Item => Rationals."+"(A, Rationals."*"(E,F)));
  Ada.Text_IO.New_Line;

END Test_Rationals_1;
