FUNCTION LookUpName(L: List; Name: NameType) RETURN Natural IS
-- Pre:  L and Name are defined and L has at least one element
-- Post: returns location of Name in L, or 0 if Name not present
  
  Lower:  Positive;
  Upper:  Positive;
  Middle: Positive;
  
BEGIN

  Lower := L'First;
  Upper := L'Last;
  Middle := (Lower + Upper) / 2;
  -- integer division gives middle item if number of items
  -- is odd, item just below middle otherwise.
   
  IF Name = L(Middle) THEN     -- stopping case - we found it!
    RETURN Middle;
 
  ELSIF Lower = Upper THEN     -- stopping case - subarray has 
    RETURN 0;                  -- only one name and it's not the one
  
  ELSIF Name < L(middle) THEN  -- recursion - look in first half
    RETURN LookUpName(L(Lower..Middle-1),Name);
  
  ELSE                         -- recursion - look in second half   
    RETURN LookUpName(L(Middle+1..Upper),Name);
  
  END IF;
  
END LookUpName;
