WITH Reporter; USE Reporter;
WITH Ada.Numerics.Discrete_Random;
WITH Tellers; USE Tellers;
WITH Types; USE Types;
PACKAGE BODY Customers IS
------------------------------------------------------------------------
--| Body of customer package. Each customer executes ten random 
--| transactions with random tellers before terminating.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  TYPE Transactions IS (Deposit, Withdraw, Balance);

  PACKAGE RandomTransactions IS 
    NEW Ada.Numerics.Discrete_Random (Transactions);

  PACKAGE RandomTellers IS 
    NEW Ada.Numerics.Discrete_Random (TellerRange);

  SUBTYPE MoneyRange IS Money RANGE 1 .. 999;
  PACKAGE RandomAmounts IS 
    NEW Ada.Numerics.Discrete_Random (MoneyRange);

  PACKAGE RandomTimesBetweenVisits IS 
    NEW Ada.Numerics.Discrete_Random (TimeBetweenVisitsRange);

  TASK BODY Customer IS

    -- Local variables
    ID               : CustID;
    Amount           : Money;
    Stat             : Status;
    WaitTime         : TimeBetweenVisitsRange;
    Teller           : TellerRange;
    Transaction      : Transactions;
    NumTransactions : CONSTANT Integer := 10;

    T: RandomTransactions.Generator;
    R: RandomTellers.Generator;
    A: RandomAmounts.Generator;
    V: RandomTimesBetweenVisits.Generator;

  BEGIN -- Customer

    RandomTransactions.Reset(T);
    RandomTellers.Reset(R);
    RandomAmounts.Reset(A);
    RandomTimesBetweenVisits.Reset(V);

    Teller := RandomTellers.Random(R);
    TellerGroup(Teller).NewAcct(ID, Stat); -- Get new cust id
    ScreenManager.Put ("Account" & Integer'Image(ID) & " alive.");

    FOR I IN 1 .. NumTransactions LOOP

      WaitTime := RandomTimesBetweenVisits.Random(V);
      ScreenManager.Put("Account" & Integer'Image(ID) 
        & " will return after" & Integer'Image(WaitTime) 
        & " sec");
      DELAY Duration (WaitTime);

      Teller := RandomTellers.Random(R);
      Transaction := RandomTransactions.Random(T);
      Amount := RandomAmounts.Random(A);
      
      CASE Transaction IS -- Pick random transaction
        WHEN Deposit =>
          ScreenManager.Put("Account" & Integer'Image(ID) 
            & " depositing" & Integer'Image(Amount)
            & " with Teller " & Teller);
          TellerGroup (Teller).Deposit (ID, Amount, Stat);
        WHEN Withdraw =>
          ScreenManager.Put("Account" & Integer'Image(ID) 
            & " withdrawing" & Integer'Image(Amount)
            & " with Teller " & Teller);
          TellerGroup (Teller).Withdraw (ID, Amount, Stat);
        WHEN Balance =>
          ScreenManager.Put("Account" & Integer'Image(ID) 
            & " checking balance"
            & " with Teller " & Teller);
          TellerGroup (Teller).Balance (ID, Stat);
      END CASE;
    END LOOP;
    ScreenManager.Put("Account" & Integer'Image(ID) & " closed.");
  END Customer;

END Customers;
