WITH Ada.Text_IO;
PACKAGE Currency.IO IS
------------------------------------------------------------------
--|                                                              
--| Specification of the input/output child package for Currency
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------

  -- input operations to read a Quantity from terminal or file

  PROCEDURE Get (Item : OUT Quantity);
  PROCEDURE Get (File: IN Ada.Text_IO.File_Type; Item : OUT Quantity);
  -- Pre : File is open
  -- Post: The currency quantity is read as a normal 
  --   floating point value.

  -- output operations to display a Quantity on terminal or
  -- write it to an external file

  PROCEDURE Put (Item : IN Quantity; Width: IN Natural:=8);
  PROCEDURE Put (File : IN Ada.Text_IO.File_Type;
                 Item : IN Quantity; Width: IN Natural:=8);
  -- Pre:  File is open, Item is defined
  -- Post: Displays or writes the currency quantity.
  --       Width is used by analogy with Integer_IO
  
END Currency.IO;
