WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Temp_Table IS
------------------------------------------------------------------
--| Displays a table of Fahrenheit and
--| equivalent Celsius temperatures.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  CStart : CONSTANT Float := 100.0;     -- initial Celsius temp   
  CStep :  CONSTANT Float := -10.0;     -- change in Celsius temp   
  CLimit : CONSTANT Float := -20.0;     -- final Celsius temp   

  Celsius :         Float;              -- Celsius temp   
  Fahrenheit :      Float;              -- Fahrenheit temp   

BEGIN -- Temp_Table   

  Ada.Text_IO.Put(Item => "Celsius     Fahrenheit");  
  Ada.Text_IO.New_Line (Spacing => 2);

  Celsius := CStart;
  WHILE Celsius >= CLimit LOOP

    Fahrenheit := 1.8 * Celsius + 32.0;
    Ada.Float_Text_IO.Put(Item => Celsius, Fore => 4, Aft => 0, Exp => 0);  
    Ada.Text_IO.Put(Item => "        ");
    Ada.Float_Text_IO.Put(Item => Fahrenheit, Fore => 3, Aft => 1, Exp => 0);  
    Ada.Text_IO.New_Line;

    Celsius := Celsius + CStep;
  END LOOP;

END Temp_Table;
