WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Numerics;
PROCEDURE Pizzeria IS
 
  -- Computes and displays the unit price of a pizza
 
  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;

  -- Pi : CONSTANT NonNegFloat := 3.14159;
  -- unnecessary; better to get this from the standard library!
 
  Diameter  : NonNegFloat;  -- input  - diameter of a pizza
  Price     : NonNegFloat;  -- input  - price of a pizza
  UnitPrice : NonNegFloat;  -- output - unit price of a pizza
  Area      : NonNegFloat;  -- output - area of a pizza 
  Radius    : NonNegFloat;  -- radius of a pizza
 
BEGIN -- Pizzeria
 
  -- Read in the pizza diameter and price
  Ada.Text_IO.Put (Item => "Size of pizza in inches > ");
  Ada.Float_Text_IO.Get (Item => Diameter);
  Ada.Text_IO.Put (Item => "Price of pizza $");
  Ada.Float_Text_IO.Get (Item => Price);  
 
  -- Compute the pizza area   
  Radius := Diameter/2.0;
  Area := Ada.Numerics.Pi * Radius ** 2;
 
  -- Compute the pizza unit price
  UnitPrice := Price / Area;
 
  -- Display the unit price and area
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "The pizza unit price is $");
  Ada.Float_Text_IO.Put (Item => UnitPrice, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "The pizza area is ");
  Ada.Float_Text_IO.Put (Item => Area, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.Put (Item => " square inches.");
  Ada.Text_IO.New_Line;
 
END Pizzeria;
