WITH Ada.Text_IO;
WITH Sets_Generic;
PROCEDURE Music_Makers IS
------------------------------------------------------------------
--| Example of the use of Sets_Generic, to create musical ensembles
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  TYPE Instruments IS
    (Violin, Viola, Cello, BassViol,      -- classical strings
     Piano, Harpsichord, Organ,           -- classical keyboards
     Clarinet, Saxophone,                 -- single-reed woodwinds
     Oboe, Bassoon,                       -- double-reed woodwinds
     Flute, Piccolo,                      -- flutes
     Trumpet, Trombone, FrenchHorn, Tuba, -- brass
     Tympani, Snare, TomTom, BassDrum,    -- drums
     Cymbals, Triangle, Bells, Marimba,   -- percussion
     Guitar, Banjo, Ukelele,              -- folk strings
     Accordion, Keyboard);                -- miscellaneous

  PACKAGE Music_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Instruments);
  PACKAGE Ensembles IS NEW Sets_Generic (Universe => Instruments);
  USE Ensembles;

  SUBTYPE Ensemble IS Ensembles.Set; -- nickname for this program

  Strings: CONSTANT Ensemble := Violin + Viola + Cello + BassViol;
  Brasses: CONSTANT Ensemble := Trumpet + Trombone + FrenchHorn + Tuba;
  JazzDrums: CONSTANT Ensemble := Snare + TomTom + BassDrum + Cymbals;
  
  JazzCombo:        Ensemble;
  StringQuartet:    Ensemble;
  PhillyStringBand: Ensemble;
  RockBand:         Ensemble;

  PROCEDURE DisplayEnsemble(Band: Ensemble) IS
  BEGIN
    FOR Instrument IN Instruments LOOP
      IF IsIn(Band, Instrument) THEN
        Music_IO.Put(Instrument);
        Ada.Text_IO.New_Line;
      END IF;
    END LOOP;
    Ada.Text_IO.New_Line;
  END DisplayEnsemble;

BEGIN -- Music_Makers

  JazzCombo := JazzDrums + Guitar + BassViol + Trumpet;
  Ada.Text_IO.Put(Item => "Jazz Combo:");
  Ada.Text_IO.New_Line;
  DisplayEnsemble(Band => JazzCombo);

  PhillyStringBand := Guitar + Ukelele + Banjo + Accordion
    + Saxophone + Snare + BassDrum;
  Ada.Text_IO.Put(Item => "Philly String Band:");
  Ada.Text_IO.New_Line;
  DisplayEnsemble(Band => PhillyStringBand);

  StringQuartet := Strings - BassViol;
  Ada.Text_IO.Put(Item => "String Quartet:");
  Ada.Text_IO.New_Line;
  DisplayEnsemble(Band => StringQuartet);

  RockBand := Guitar + Keyboard + JazzDrums;
  Ada.Text_IO.Put(Item => "Rock Band:");
  Ada.Text_IO.New_Line;
  DisplayEnsemble(Band => RockBand);

END Music_Makers;
