WITH Ada.Unchecked_Deallocation;
PACKAGE BODY Lists_Generic IS
------------------------------------------------------------------
--|                                                              
--| generic package body for singly-linked lists;
--| the operations are provided as subunits of the package.
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
--|                                                              
------------------------------------------------------------------

  PROCEDURE Dispose IS
    NEW Ada.Unchecked_Deallocation (Object => ListNode, Name => ListPtr);

  PROCEDURE MakeEmpty (L : IN OUT List) IS SEPARATE;

  FUNCTION IsEmpty (L : IN List) RETURN Boolean IS SEPARATE;

  PROCEDURE AddToFront (L: IN OUT List; Element: IN ElementType) IS SEPARATE;

  FUNCTION RetrieveFront (L: IN List) RETURN ElementType IS SEPARATE;

  PROCEDURE RemoveFront (L: IN OUT List) IS SEPARATE;

  PROCEDURE AddToEnd (L: IN OUT List; Element: IN ElementType) IS SEPARATE;

  PROCEDURE Copy (Target: OUT List; Source: IN List) IS SEPARATE;

  PROCEDURE Display(L: IN List) IS SEPARATE;

END Lists_Generic;
