WITH Ada.Text_IO;
PROCEDURE Get_Natural_Token (NumData : OUT Natural) IS
------------------------------------------------------------------
--| Reads consecutive characters ending with the symbol %.  Computes
--| the integer value of the digit characters, ignoring non-digits.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  Base :     CONSTANT Positive := 10;   -- the number system base   
  Sentinel : CONSTANT Character := '%'; -- the sentinel character   

  Next :     Character;                 -- each character read   
  Digit :    Natural;                   -- the value of each numeric character 
                                        -- (its ASCII position)
BEGIN -- Get_Natural_Token   

  -- Accumulate the numeric value of the digits in NumData   
  NumData := 0;                         -- initial value is zero   
  Ada.Text_IO.Get(Item => Next);            -- Read first character   
  WHILE Next /= Sentinel LOOP
    -- invariant:
    --   No prior value of Next is the sentinel and
    --   if Next is a digit, NumData is multiplied by Base and
    --   Next's digit value is added to NumData
      
    IF (Next >= '0') AND (Next <= '9') THEN
      -- Process digit   
      Digit := Character'Pos(Next) - Character'Pos('0');  -- find digit value
      NumData := Base * NumData + Digit; -- Add digit value   
    END IF;
    Ada.Text_IO.Get(Item => Next);           -- Read next character   
  END  LOOP;
  -- assert:
  --   Next is the sentinel and
  --   NumData is the number in base Base formed from the digit
  --   characters read as data

END Get_Natural_Token;
